/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.StartLog;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public final class NbLoaderPool
extends DataLoaderPool
implements PropertyChangeListener,
Runnable,
LookupListener,
TaskListener {
    private static final Logger err = Logger.getLogger(NbLoaderPool.class.getName());
    private static List<DataLoader> loaders = new ArrayList<DataLoader>();
    private static Set<DataLoader> modifiedLoaders = new HashSet<DataLoader>();
    private static Map<String, DataLoader> names2Loaders = new HashMap<String, DataLoader>(200);
    private static Map<String, DataLoader> repNames2Loaders = new HashMap<String, DataLoader>(200);
    private static Map<String, String[]> installBefores = new HashMap<String, String[]>();
    private static Map<String, String[]> installAfters = new HashMap<String, String[]>();
    private static DataLoader[] loadersArray;
    private static boolean installationFinished;
    private static boolean updatingBatch;
    private static boolean updatingBatchUsed;
    private static final String LOADER_POOL_NAME = "loaders.ser";
    private static final long serialVersionUID = -8488524097175567566L;
    static boolean IN_TEST;
    private transient RequestProcessor.Task fireTask;
    private transient Lookup.Result mimeResolvers;
    private transient FileObject declarativeResolvers;
    private transient boolean listenersRegistered;
    private static RequestProcessor rp;
    private final FileChangeListener listener = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fileEvent) {
            NbLoaderPool.this.maybeFireChangeEvent();
        }

        public void fileDeleted(FileEvent fileEvent) {
            NbLoaderPool.this.maybeFireChangeEvent();
        }
    };

    public static synchronized void beginUpdates() {
        updatingBatch = true;
        updatingBatchUsed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endUpdates() {
        NbLoaderPool nbLoaderPool = NbLoaderPool.getNbLoaderPool();
        Class<NbLoaderPool> clazz = NbLoaderPool.class;
        synchronized (NbLoaderPool.class) {
            if (!updatingBatch) {
                throw new IllegalStateException();
            }
            updatingBatch = false;
            if (updatingBatchUsed) {
                updatingBatchUsed = false;
                NbLoaderPool.resort(nbLoaderPool);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void waitFinished() {
        NbLoaderPool.getNbLoaderPool().fireTask.waitFinished();
    }

    public static void add(ManifestSection.LoaderSection loaderSection) throws Exception {
        DataLoader dataLoader = (DataLoader)loaderSection.getInstance();
        NbLoaderPool.doAdd(dataLoader, loaderSection, NbLoaderPool.getNbLoaderPool());
    }

    static synchronized void doAdd(DataLoader dataLoader, ManifestSection.LoaderSection loaderSection, NbLoaderPool nbLoaderPool) throws Exception {
        Class<?> clazz;
        Iterator<DataLoader> iterator;
        if (err.isLoggable(Level.FINE) && loaderSection != null) {
            iterator = loaderSection.getInstallBefore() == null ? null : Arrays.asList(loaderSection.getInstallBefore());
            clazz = loaderSection.getInstallAfter() == null ? null : Arrays.asList(loaderSection.getInstallAfter());
            err.fine("add: " + dataLoader + " repclass: " + dataLoader.getRepresentationClass().getName() + " before: " + iterator + " after: " + clazz);
        }
        iterator = loaders.iterator();
        clazz = dataLoader.getClass();
        while (iterator.hasNext()) {
            if (iterator.next().getClass() != clazz) continue;
            iterator.remove();
            break;
        }
        loaders.add(dataLoader);
        dataLoader.removePropertyChangeListener((PropertyChangeListener)nbLoaderPool);
        dataLoader.addPropertyChangeListener((PropertyChangeListener)nbLoaderPool);
        String string = clazz.getName();
        names2Loaders.put(string, dataLoader);
        repNames2Loaders.put(dataLoader.getRepresentationClassName(), dataLoader);
        if (loaderSection != null) {
            String[] stringArray;
            String[] stringArray2 = loaderSection.getInstallBefore();
            if (stringArray2 != null) {
                installBefores.put(string, stringArray2);
            }
            if ((stringArray = loaderSection.getInstallAfter()) != null) {
                installAfters.put(string, stringArray);
            }
        }
        if (updatingBatch) {
            updatingBatchUsed = true;
        } else {
            NbLoaderPool.resort(nbLoaderPool);
        }
    }

    private static synchronized void resort(NbLoaderPool nbLoaderPool) {
        HashMap<DataLoader, List<DataLoader>> hashMap = new HashMap<DataLoader, List<DataLoader>>();
        NbLoaderPool.add2Deps(hashMap, installBefores, true);
        NbLoaderPool.add2Deps(hashMap, installAfters, false);
        if (err.isLoggable(Level.FINE)) {
            err.fine("Before sort: " + loaders);
        }
        try {
            loaders = Utilities.topologicalSort(loaders, hashMap);
            if (err.isLoggable(Level.FINE)) {
                err.fine("After sort: " + loaders);
            }
        }
        catch (TopologicalSortException topologicalSortException) {
            err.log(Level.WARNING, null, topologicalSortException);
            err.warning("Contradictory loader ordering: " + hashMap);
        }
        NbLoaderPool.update(nbLoaderPool);
    }

    private static void add2Deps(Map<DataLoader, List<DataLoader>> map, Map map2, boolean bl) {
        for (Map.Entry entry : map2.entrySet()) {
            String string = (String)entry.getKey();
            DataLoader dataLoader = names2Loaders.get(string);
            if (dataLoader == null) {
                throw new IllegalStateException("No such loader: " + string);
            }
            String[] stringArray = (String[])entry.getValue();
            if (stringArray == null) {
                throw new IllegalStateException("Null Install-" + (bl ? "Before" : "After") + " for " + string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                DataLoader dataLoader2 = repNames2Loaders.get(string2);
                if (dataLoader2 != null) {
                    if (bl) {
                        NbLoaderPool.addDep(map, dataLoader, dataLoader2);
                        continue;
                    }
                    NbLoaderPool.addDep(map, dataLoader2, dataLoader);
                    continue;
                }
                dataLoader2 = names2Loaders.get(string2);
                if (dataLoader2 == null) continue;
                NbLoaderPool.warn(string, string2, dataLoader2.getRepresentationClassName());
            }
        }
    }

    private static void addDep(Map<DataLoader, List<DataLoader>> map, DataLoader dataLoader, DataLoader dataLoader2) {
        List<DataLoader> list = map.get(dataLoader);
        if (list == null) {
            list = new LinkedList<DataLoader>();
            map.put(dataLoader, list);
        }
        if (!list.contains(dataLoader2)) {
            list.add(dataLoader2);
        }
    }

    private static void warn(String string, String string2, String string3) {
        err.warning("Warning: a possible error in the manifest containing " + string + " was found.");
        err.warning("The loader specified an Install-{After,Before} on " + string2 + ", but this is a DataLoader class.");
        err.warning("Probably you wanted " + string3 + " which is the loader's representation class.");
    }

    static void installationFinished() {
        installationFinished = true;
        if (!modifiedLoaders.isEmpty()) {
            NbLoaderPool.getNbLoaderPool().superFireChangeEvent();
        }
    }

    static synchronized boolean isModified(DataLoader dataLoader) {
        return modifiedLoaders.contains(dataLoader);
    }

    private static synchronized void writePool(ObjectOutputStream objectOutputStream, NbLoaderPool nbLoaderPool) throws IOException {
        String string;
        if (err.isLoggable(Level.FINE)) {
            err.fine("writePool");
        }
        objectOutputStream.writeObject(new HashMap());
        objectOutputStream.writeObject(new HashMap());
        for (DataLoader object2 : loaders) {
            if (!NbLoaderPool.isModified(object2)) {
                string = object2.getClass().getName();
                if (err.isLoggable(Level.FINE)) {
                    err.fine("writing unmodified " + string);
                }
                objectOutputStream.writeObject("=" + string);
                continue;
            }
            try {
                string = new NbMarshalledObject((Object)object2);
            }
            catch (IOException bl) {
                err.log(Level.WARNING, null, bl);
                string = null;
            }
            if (string == null) continue;
            if (err.isLoggable(Level.FINE)) {
                err.fine("writing modified " + object2.getClass().getName());
            }
            boolean string2 = false;
            ModuleInfo iOException = Modules.getDefault().ownerOf(object2.getClass());
            if (iOException != null && iOException.isEnabled()) {
                if (err.isLoggable(Level.FINE)) {
                    err.fine("belongs to module: " + iOException.getCodeNameBase());
                }
                objectOutputStream.writeObject(iOException.getCodeNameBase());
                int n = iOException.getCodeNameRelease();
                objectOutputStream.writeInt(n);
                SpecificationVersion specificationVersion = iOException.getSpecificationVersion();
                if (specificationVersion != null) {
                    objectOutputStream.writeObject(specificationVersion.toString());
                } else {
                    objectOutputStream.writeObject(null);
                }
                string2 = true;
            }
            if (!string2 && err.isLoggable(Level.FINE)) {
                err.fine("does not belong to any module");
            }
            objectOutputStream.writeObject(string);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("writing null");
        }
        objectOutputStream.writeObject(null);
        Enumeration enumeration = nbLoaderPool.allLoaders();
        while (enumeration.hasMoreElements()) {
            String string2;
            string = (DataLoader)enumeration.nextElement();
            if (loaders.contains(string)) continue;
            if (!NbLoaderPool.isModified((DataLoader)string)) {
                string2 = string.getClass().getName();
                if (!err.isLoggable(Level.FINE)) continue;
                err.fine("skipping unmodified " + string2);
                continue;
            }
            try {
                string2 = new NbMarshalledObject((Object)string);
            }
            catch (IOException iOException) {
                err.log(Level.WARNING, null, iOException);
                string2 = null;
            }
            if (string2 == null) continue;
            if (err.isLoggable(Level.FINE)) {
                err.fine("writing " + string.getClass().getName());
            }
            objectOutputStream.writeObject(string2);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("writing null");
        }
        objectOutputStream.writeObject(null);
        if (err.isLoggable(Level.FINE)) {
            err.fine("done writing");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void readPool(ObjectInputStream objectInputStream, NbLoaderPool nbLoaderPool) throws IOException, ClassNotFoundException {
        Object object;
        Iterator<DataLoader> iterator;
        objectInputStream.readObject();
        objectInputStream.readObject();
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<DataLoader> linkedList = new LinkedList<DataLoader>();
        Iterator iterator2 = Lookup.getDefault().lookupAll(ModuleInfo.class).iterator();
        HashMap<String, Iterator<DataLoader>> hashMap = new HashMap<String, Iterator<DataLoader>>();
        while (iterator2.hasNext()) {
            iterator = (ModuleInfo)iterator2.next();
            hashMap.put(iterator.getCodeNameBase(), iterator);
        }
        while (true) {
            Object object2;
            if ((iterator = objectInputStream.readObject()) == null) {
                if (!err.isLoggable(Level.FINE)) break;
                err.fine("reading null");
                break;
            }
            if (iterator instanceof String) {
                SpecificationVersion specificationVersion;
                object = (String)((Object)iterator);
                if (((String)object).length() > 0 && ((String)object).charAt(0) == '=') {
                    String string = ((String)object).substring(1);
                    object2 = names2Loaders.get(string);
                    if (object2 != null) {
                        if (err.isLoggable(Level.FINE)) {
                            err.fine("reading unmodified " + string);
                        }
                        linkedList.add((DataLoader)object2);
                        hashSet.add(object2.getClass());
                        continue;
                    }
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("skipping unmodified nonexistent " + string);
                    continue;
                }
                int n = objectInputStream.readInt();
                object2 = (String)objectInputStream.readObject();
                NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)objectInputStream.readObject();
                ModuleInfo moduleInfo = (ModuleInfo)hashMap.get(object);
                if (moduleInfo == null) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("No known module " + (String)object + ", skipping loader");
                    continue;
                }
                if (!moduleInfo.isEnabled()) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + (String)object + " is disabled, skipping loader");
                    continue;
                }
                if (moduleInfo.getCodeNameRelease() < n) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + (String)object + " is too old (major vers.), skipping loader");
                    continue;
                }
                if (object2 != null && ((specificationVersion = moduleInfo.getSpecificationVersion()) == null || specificationVersion.compareTo((Object)new SpecificationVersion((String)object2)) < 0)) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + (String)object + " is too old (spec. vers.), skipping loader");
                    continue;
                }
                if (err.isLoggable(Level.FINE)) {
                    err.fine("Module " + (String)object + " is OK, will try to restore loader");
                }
            } else {
                NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)iterator;
            }
            object = null;
            try {
                void object4;
                DataLoader dataLoader = (DataLoader)object4.get();
                if (dataLoader == null) continue;
                object2 = dataLoader.getClass();
                if (err.isLoggable(Level.FINE)) {
                    err.fine("reading modified " + ((Class)object2).getName());
                }
                linkedList.add(dataLoader);
                hashSet.add(object2);
            }
            catch (IOException iOException) {
                object = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = classNotFoundException;
            }
        }
        while (true) {
            if ((iterator = (NbMarshalledObject)objectInputStream.readObject()) == null) {
                if (!err.isLoggable(Level.FINE)) break;
                err.fine("reading null");
                break;
            }
            Object var7_11 = null;
            try {
                object = (DataLoader)iterator.get();
                if (!err.isLoggable(Level.FINE)) continue;
                err.fine("reading " + object.getClass().getName());
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
            }
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("done reading");
        }
        for (DataLoader dataLoader : loaders) {
            if (hashSet.contains(dataLoader.getClass())) continue;
            linkedList.add(dataLoader);
        }
        if (linkedList.size() > new HashSet(linkedList).size()) {
            throw new IllegalStateException("Duplicates in " + linkedList);
        }
        loaders = linkedList;
        NbLoaderPool.resort(nbLoaderPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() throws IOException {
        if (modifiedLoaders.isEmpty()) {
            return;
        }
        FileObject fileObject = NbLoaderPool.getLoaderPoolStorage(true);
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(outputStream);
            NbObjectOutputStream.writeSafely((ObjectOutput)nbObjectOutputStream, (Object)NbLoaderPool.getNbLoaderPool());
            nbObjectOutputStream.flush();
            nbObjectOutputStream.close();
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws IOException {
        FileObject fileObject = NbLoaderPool.getLoaderPoolStorage(false);
        if (fileObject != null) {
            try {
                NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(fileObject.getInputStream());
                try {
                    NbObjectInputStream.readSafely((ObjectInput)nbObjectInputStream);
                }
                finally {
                    nbObjectInputStream.close();
                }
            }
            catch (IOException iOException) {
                fileObject.delete();
                throw iOException;
            }
        }
    }

    private static FileObject getLoaderPoolStorage(boolean bl) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)LOADER_POOL_NAME);
        if (fileObject == null && bl) {
            fileObject = FileUtil.getConfigRoot().createData(LOADER_POOL_NAME);
        }
        return fileObject;
    }

    private static synchronized void update(NbLoaderPool nbLoaderPool) {
        if (err.isLoggable(Level.FINE)) {
            err.fine("update");
        }
        loadersArray = null;
        if (nbLoaderPool != null && installationFinished) {
            nbLoaderPool.superFireChangeEvent();
        }
        if (nbLoaderPool != null) {
            Enumeration enumeration = nbLoaderPool.allLoaders();
            while (enumeration.hasMoreElements()) {
                DataLoader dataLoader = (DataLoader)enumeration.nextElement();
                dataLoader.removePropertyChangeListener((PropertyChangeListener)nbLoaderPool);
                dataLoader.addPropertyChangeListener((PropertyChangeListener)nbLoaderPool);
            }
        }
    }

    public static synchronized boolean remove(DataLoader dataLoader, NbLoaderPool nbLoaderPool) {
        if (loaders.remove(dataLoader)) {
            if (err.isLoggable(Level.FINE)) {
                err.fine("remove: " + dataLoader);
            }
            String string = dataLoader.getClass().getName();
            names2Loaders.remove(string);
            repNames2Loaders.remove(dataLoader.getRepresentationClassName());
            installBefores.remove(string);
            installAfters.remove(string);
            dataLoader.removePropertyChangeListener((PropertyChangeListener)nbLoaderPool);
            if (updatingBatch) {
                updatingBatchUsed = true;
            } else {
                NbLoaderPool.resort(nbLoaderPool);
            }
            modifiedLoaders.remove(dataLoader);
            return true;
        }
        return false;
    }

    public static NbLoaderPool getNbLoaderPool() {
        assert (!Thread.holdsLock(NbLoaderPool.class));
        return (NbLoaderPool)DataLoaderPool.getDefault();
    }

    public NbLoaderPool() {
        this.fireTask = rp.create((Runnable)this, true);
    }

    private final DataFolder findServicesFolder() throws Exception {
        Method method = DataLoaderPool.class.getDeclaredMethod("getFolderLoader", new Class[0]);
        method.setAccessible(true);
        DataLoader dataLoader = (DataLoader)method.invoke(null, new Object[0]);
        FileObject fileObject = FileUtil.getConfigFile((String)"Services");
        return (DataFolder)dataLoader.findDataObject(fileObject, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Lookup findServicesLookup() {
        StartLog.logProgress((String)"Got Services folder");
        try {
            this.listenersRegistered = true;
            DataFolder dataFolder = this.findServicesFolder();
            FolderLookup folderLookup = new FolderLookup((DataObject.Container)dataFolder, "SL[");
            folderLookup.addTaskListener((TaskListener)this);
            Lookup lookup = folderLookup.getLookup();
            return lookup;
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            Lookup lookup = Lookup.EMPTY;
            return lookup;
        }
        finally {
            StartLog.logProgress((String)"created FolderLookup");
        }
    }

    public void taskFinished(Task task) {
        this.initListeners();
    }

    private void initListeners() {
        this.mimeResolvers = Lookup.getDefault().lookupResult(MIMEResolver.class);
        this.mimeResolvers.addLookupListener((LookupListener)this);
        this.listenToDeclarativeResolvers();
    }

    private void listenToDeclarativeResolvers() {
        this.declarativeResolvers = FileUtil.getConfigFile((String)"Services/MIMEResolver");
        if (this.declarativeResolvers != null) {
            this.declarativeResolvers.addFileChangeListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration<DataLoader> loaders() {
        if (!this.listenersRegistered) {
            this.initListeners();
        }
        Class<NbLoaderPool> clazz = NbLoaderPool.class;
        synchronized (NbLoaderPool.class) {
            if (loadersArray == null) {
                ArrayList<DataLoader> arrayList = new ArrayList<DataLoader>(loaders);
                arrayList.addAll(Lookup.getDefault().lookupAll(DataLoader.class));
                loadersArray = arrayList.toArray(new DataLoader[arrayList.size()]);
            }
            Object[] objectArray = loadersArray;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return Enumerations.array((Object[])objectArray);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DataLoader dataLoader = (DataLoader)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if ("actions".equals(string) && propertyChangeEvent.getNewValue() == null) {
            return;
        }
        modifiedLoaders.add(dataLoader);
        if (err.isLoggable(Level.FINE)) {
            err.fine("Got change in " + dataLoader.getClass().getName() + "." + string);
        }
        if ("actions".equals(string) || "displayName".equals(string)) {
            return;
        }
        if (installationFinished) {
            this.superFireChangeEvent();
        }
    }

    void superFireChangeEvent() {
        err.fine("Change in loader pool scheduled");
        this.fireTask.schedule(1000);
    }

    @Override
    public void run() {
        err.fine("going to fire change in loaders");
        super.fireChangeEvent(new ChangeEvent(this));
        err.fine("change event fired");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NbLoaderPool.writePool(objectOutputStream, NbLoaderPool.getNbLoaderPool());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        NbLoaderPool.readPool(objectInputStream, NbLoaderPool.getNbLoaderPool());
    }

    private Object readResolve() {
        return NbLoaderPool.getNbLoaderPool();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.maybeFireChangeEvent();
    }

    private void maybeFireChangeEvent() {
        if (IN_TEST || Main.isInitialized()) {
            this.superFireChangeEvent();
        }
    }

    static {
        installationFinished = false;
        updatingBatch = false;
        updatingBatchUsed = false;
        IN_TEST = false;
        rp = new RequestProcessor("Refresh Loader Pool");
    }
}

