/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.proc;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerBase;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.DebuggerUtilities;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.LoadObjectComparator;
import sun.jvm.hotspot.debugger.proc.ProcAddress;
import sun.jvm.hotspot.debugger.proc.ProcCDebugger;
import sun.jvm.hotspot.debugger.proc.ProcCFrame;
import sun.jvm.hotspot.debugger.proc.ProcDebugger;
import sun.jvm.hotspot.debugger.proc.ProcOopHandle;
import sun.jvm.hotspot.debugger.proc.ProcThreadFactory;
import sun.jvm.hotspot.debugger.proc.SharedObject;
import sun.jvm.hotspot.debugger.proc.amd64.ProcAMD64ThreadFactory;
import sun.jvm.hotspot.debugger.proc.sparc.ProcSPARCThreadFactory;
import sun.jvm.hotspot.debugger.proc.x86.ProcX86ThreadFactory;
import sun.jvm.hotspot.utilities.PlatformInfo;

public class ProcDebuggerLocal
extends DebuggerBase
implements ProcDebugger {
    protected static final int cacheSize = 0x1000000;
    private static LoadObjectComparator loadObjectComparator;
    private boolean unalignedAccessesOkay;
    private ProcThreadFactory threadFactory;
    private int pcRegIndex;
    private int fpRegIndex;
    private Map nameToDsoMap;
    private List loadObjects;
    private CDebugger cdbg;
    private boolean suspended;
    private long p_ps_prochandle;
    private long libthread_db_handle;
    private long p_td_thragent_t;
    private long p_td_init;
    private long p_td_ta_new;
    private long p_td_ta_delete;
    private long p_td_ta_thr_iter;
    private long p_td_thr_get_info;
    private long p_td_ta_map_id2thr;
    private long p_td_thr_getgregs;
    private int classes_jsa_fd;
    private long p_file_map_header;
    private boolean attached = false;
    private boolean isCore;
    private List threadListCache;
    private List loadObjectCache;
    private Map topFrameCache;

    public ProcDebuggerLocal(MachineDescription machDesc, boolean useCache) {
        this.machDesc = machDesc;
        String cpu = PlatformInfo.getCPU();
        if (cpu.equals("sparc")) {
            this.threadFactory = new ProcSPARCThreadFactory(this);
            this.pcRegIndex = 33;
            this.fpRegIndex = 30;
        } else if (cpu.equals("x86")) {
            this.threadFactory = new ProcX86ThreadFactory(this);
            this.pcRegIndex = 14;
            this.fpRegIndex = 6;
            this.unalignedAccessesOkay = true;
        } else if (cpu.equals("amd64") || cpu.equals("x86_64")) {
            this.threadFactory = new ProcAMD64ThreadFactory(this);
            this.pcRegIndex = 17;
            this.fpRegIndex = 10;
        } else {
            try {
                Class<?> tfc = Class.forName("sun.jvm.hotspot.debugger.proc." + cpu.toLowerCase() + ".Proc" + cpu.toUpperCase() + "ThreadFactory");
                Constructor<?>[] ctfc = tfc.getConstructors();
                this.threadFactory = (ProcThreadFactory)ctfc[0].newInstance(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Thread access for CPU architecture " + PlatformInfo.getCPU() + " not yet supported");
            }
        }
        if (useCache) {
            int cachePageSize = this.getPageSize();
            int cacheNumPages = this.parseCacheNumPagesProperty(0x1000000 / cachePageSize);
            this.initCache(cachePageSize, cacheNumPages);
        }
        this.resetNativePointers();
        this.clearCacheFields();
    }

    @Override
    public boolean hasProcessList() throws DebuggerException {
        return false;
    }

    @Override
    public List getProcessList() throws DebuggerException {
        throw new DebuggerException("Not yet supported");
    }

    @Override
    public synchronized void attach(int processID) throws DebuggerException {
        this.checkAttached();
        this.isCore = false;
        this.attach0(new Integer(processID).toString());
        this.attached = true;
        this.suspended = true;
    }

    @Override
    public synchronized void attach(String executableName, String coreFileName) throws DebuggerException {
        this.checkAttached();
        this.isCore = true;
        this.topFrameCache = new HashMap();
        this.attach0(executableName, coreFileName);
        this.attached = true;
        this.suspended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean detach() {
        if (!this.attached) {
            return false;
        }
        try {
            if (this.p_ps_prochandle == 0L) {
                boolean bl = false;
                return bl;
            }
            this.detach0();
            this.clearCache();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.resetNativePointers();
            this.clearCacheFields();
            this.suspended = false;
            this.attached = false;
        }
    }

    public synchronized void suspend() throws DebuggerException {
        this.requireAttach();
        if (this.suspended) {
            throw new DebuggerException("Process already suspended");
        }
        this.suspend0();
        this.suspended = true;
        this.enableCache();
        this.reresolveLoadObjects();
    }

    public synchronized void resume() throws DebuggerException {
        this.requireAttach();
        if (!this.suspended) {
            throw new DebuggerException("Process not suspended");
        }
        this.resume0();
        this.disableCache();
        this.suspended = false;
    }

    public synchronized boolean isSuspended() throws DebuggerException {
        this.requireAttach();
        return this.suspended;
    }

    @Override
    public Address parseAddress(String addressString) throws NumberFormatException {
        long addr = this.utils.scanAddress(addressString);
        if (addr == 0L) {
            return null;
        }
        return new ProcAddress(this, addr);
    }

    @Override
    public String getOS() {
        return PlatformInfo.getOS();
    }

    @Override
    public String getCPU() {
        return PlatformInfo.getCPU();
    }

    @Override
    public boolean hasConsole() throws DebuggerException {
        return false;
    }

    @Override
    public String consoleExecuteCommand(String cmd) throws DebuggerException {
        throw new DebuggerException("Can't execute console commands");
    }

    @Override
    public String getConsolePrompt() throws DebuggerException {
        return "";
    }

    @Override
    public CDebugger getCDebugger() throws DebuggerException {
        if (this.cdbg == null) {
            this.cdbg = new ProcCDebugger(this);
        }
        return this.cdbg;
    }

    @Override
    public synchronized Address lookup(String objectName, String symbol) {
        this.requireAttach();
        long addr = this.lookupByName0(objectName, symbol);
        if (addr == 0L) {
            return null;
        }
        return new ProcAddress(this, addr);
    }

    @Override
    public synchronized OopHandle lookupOop(String objectName, String symbol) {
        Address addr = this.lookup(objectName, symbol);
        if (addr == null) {
            return null;
        }
        return addr.addOffsetToAsOopHandle(0L);
    }

    @Override
    public MachineDescription getMachineDescription() {
        return this.machDesc;
    }

    public void setMachineDescription(MachineDescription machDesc) {
        this.machDesc = machDesc;
        this.setBigEndian(machDesc.isBigEndian());
        this.utils = new DebuggerUtilities(machDesc.getAddressSize(), machDesc.isBigEndian());
    }

    public synchronized int getRemoteProcessAddressSize() throws DebuggerException {
        this.requireAttach();
        return this.getRemoteProcessAddressSize0();
    }

    @Override
    public ThreadProxy getThreadForIdentifierAddress(Address addr) {
        return this.threadFactory.createThreadWrapper(addr);
    }

    @Override
    public ThreadProxy getThreadForThreadId(long id) {
        return this.threadFactory.createThreadWrapper(id);
    }

    @Override
    public long readJLong(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        if (this.unalignedAccessesOkay) {
            this.utils.checkAlignment(address, this.jintSize);
        } else {
            this.utils.checkAlignment(address, this.jlongSize);
        }
        byte[] data = this.readBytes(address, this.jlongSize);
        return this.utils.dataToJLong(data, this.jlongSize);
    }

    @Override
    public String addressValueToString(long address) {
        return this.utils.addressValueToString(address);
    }

    @Override
    public long readCInteger(long address, long numBytes, boolean isUnsigned) throws UnmappedAddressException, UnalignedAddressException {
        this.checkConfigured();
        if (!this.unalignedAccessesOkay) {
            this.utils.checkAlignment(address, numBytes);
        } else if (numBytes == 8L) {
            this.utils.checkAlignment(address, 4L);
        } else {
            this.utils.checkAlignment(address, numBytes);
        }
        byte[] data = this.readBytes(address, numBytes);
        return this.utils.dataToCInteger(data, isUnsigned);
    }

    @Override
    public ProcAddress readAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new ProcAddress(this, value);
    }

    @Override
    public ProcAddress readCompOopAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new ProcAddress(this, value);
    }

    @Override
    public ProcOopHandle readOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new ProcOopHandle(this, value);
    }

    @Override
    public ProcOopHandle readCompOopHandle(long address) {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new ProcOopHandle(this, value);
    }

    @Override
    public void writeBytesToProcess(long address, long numBytes, byte[] data) throws UnmappedAddressException, DebuggerException {
        if (this.isCore) {
            throw new DebuggerException("Attached to a core file!");
        }
        this.writeBytesToProcess0(address, numBytes, data);
    }

    @Override
    public synchronized ReadResult readBytesFromProcess(long address, long numBytes) throws DebuggerException {
        this.requireAttach();
        byte[] res = this.readBytesFromProcess0(address, numBytes);
        if (res != null) {
            return new ReadResult(res);
        }
        return new ReadResult(address);
    }

    protected int getPageSize() {
        int pagesize = this.getPageSize0();
        if (pagesize == -1) {
            pagesize = PlatformInfo.getCPU().equals("sparc") || PlatformInfo.getCPU().equals("amd64") ? 8196 : 4096;
        }
        return pagesize;
    }

    @Override
    public synchronized long[] getThreadIntegerRegisterSet(int tid) {
        this.requireAttach();
        return this.getThreadIntegerRegisterSet0(tid);
    }

    @Override
    public long getAddressValue(Address addr) {
        if (addr == null) {
            return 0L;
        }
        return ((ProcAddress)addr).getValue();
    }

    @Override
    public Address newAddress(long value) {
        if (value == 0L) {
            return null;
        }
        return new ProcAddress(this, value);
    }

    @Override
    public synchronized List getThreadList() throws DebuggerException {
        this.requireAttach();
        List res = null;
        if (this.isCore && this.threadListCache != null) {
            res = this.threadListCache;
        } else {
            res = new ArrayList();
            this.fillThreadList0(res);
            if (this.isCore) {
                this.threadListCache = res;
            }
        }
        return res;
    }

    @Override
    public synchronized List getLoadObjectList() throws DebuggerException {
        this.requireAttach();
        if (!this.suspended) {
            throw new DebuggerException("Process not suspended");
        }
        if (this.loadObjectCache == null) {
            this.updateLoadObjectCache();
        }
        return this.loadObjectCache;
    }

    @Override
    public synchronized CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        this.requireAttach();
        CFrame res = null;
        if (this.isCore && (res = (CFrame)this.topFrameCache.get(thread)) != null) {
            return res;
        }
        ThreadContext context = thread.getContext();
        int numRegs = context.getNumRegisters();
        long[] regs = new long[numRegs];
        for (int i = 0; i < numRegs; ++i) {
            regs[i] = context.getRegister(i);
        }
        res = this.fillCFrameList0(regs);
        if (this.isCore) {
            this.topFrameCache.put(thread, res);
        }
        return res;
    }

    @Override
    public synchronized ClosestSymbol lookup(long address) {
        this.requireAttach();
        return this.lookupByAddress0(address);
    }

    @Override
    public String demangle(String name) {
        return this.demangle0(name);
    }

    private void updateLoadObjectCache() {
        ArrayList res = new ArrayList();
        this.nameToDsoMap = new HashMap();
        this.fillLoadObjectList0(res);
        this.loadObjectCache = ProcDebuggerLocal.sortLoadObjects(res);
    }

    private static List sortLoadObjects(List in) {
        Object[] arr = in.toArray();
        Arrays.sort(arr, loadObjectComparator);
        return Arrays.asList(arr);
    }

    private long lookupByName(String objectName, String symbolName) throws DebuggerException {
        ProcAddress addr;
        SharedObject dso;
        if (this.nameToDsoMap == null) {
            this.getLoadObjectList();
        }
        if ((dso = (SharedObject)this.nameToDsoMap.get(objectName)) != null && (addr = (ProcAddress)dso.lookupSymbol(symbolName)) != null) {
            return addr.getValue();
        }
        return 0L;
    }

    private SharedObject findDSOByName(String fullPathName) {
        if (this.loadObjectCache == null) {
            return null;
        }
        for (SharedObject dso : this.loadObjectCache) {
            if (!dso.getName().equals(fullPathName)) continue;
            return dso;
        }
        return null;
    }

    private void reresolveLoadObjects() throws DebuggerException {
        if (this.loadObjectCache == null) {
            return;
        }
        this.updateLoadObjectCache();
    }

    private void checkAttached() {
        if (this.attached) {
            if (this.isCore) {
                throw new DebuggerException("already attached to a core file!");
            }
            throw new DebuggerException("already attached to a process!");
        }
    }

    private void requireAttach() {
        if (!this.attached) {
            throw new RuntimeException("not attached to a process or core file!");
        }
    }

    private void clearCacheFields() {
        this.loadObjectCache = null;
        this.nameToDsoMap = null;
        this.threadListCache = null;
        this.topFrameCache = null;
    }

    private void resetNativePointers() {
        this.p_ps_prochandle = 0L;
        this.libthread_db_handle = 0L;
        this.p_td_thragent_t = 0L;
        this.p_td_init = 0L;
        this.p_td_ta_new = 0L;
        this.p_td_ta_delete = 0L;
        this.p_td_ta_thr_iter = 0L;
        this.p_td_thr_get_info = 0L;
        this.p_td_ta_map_id2thr = 0L;
        this.p_td_thr_getgregs = 0L;
        this.classes_jsa_fd = -1;
        this.p_file_map_header = 0L;
    }

    private native void attach0(String var1) throws DebuggerException;

    private native void attach0(String var1, String var2) throws DebuggerException;

    private native void detach0() throws DebuggerException;

    private native int getRemoteProcessAddressSize0() throws DebuggerException;

    private native int getPageSize0() throws DebuggerException;

    private native long[] getThreadIntegerRegisterSet0(long var1) throws DebuggerException;

    private native void fillThreadList0(List var1) throws DebuggerException;

    private native ProcCFrame fillCFrameList0(long[] var1) throws DebuggerException;

    private ProcCFrame createSenderFrame(ProcCFrame f, long pc, long fp) {
        ProcCFrame sender = new ProcCFrame(this, this.newAddress(pc), this.newAddress(fp));
        if (f != null) {
            f.setSender(sender);
        }
        return sender;
    }

    private native void fillLoadObjectList0(List var1) throws DebuggerException;

    private LoadObject createLoadObject(String fileName, long textsize, long base) {
        File f = new File(fileName);
        Address baseAddr = this.newAddress(base);
        SharedObject res = this.findDSOByName(fileName);
        if (res != null) {
            Address oldBase = res.getBase();
            if (!((Object)baseAddr).equals(oldBase)) {
                res.setBase(baseAddr);
            }
        } else {
            res = new SharedObject(this, fileName, f.length(), baseAddr);
        }
        this.nameToDsoMap.put(f.getName(), res);
        return res;
    }

    private native long lookupByName0(String var1, String var2) throws DebuggerException;

    private native ClosestSymbol lookupByAddress0(long var1) throws DebuggerException;

    private ClosestSymbol createClosestSymbol(String name, long offset) {
        return new ClosestSymbol(name, offset);
    }

    private native byte[] readBytesFromProcess0(long var1, long var3) throws DebuggerException;

    private native void writeBytesToProcess0(long var1, long var3, byte[] var5) throws DebuggerException;

    private native void suspend0() throws DebuggerException;

    private native void resume0() throws DebuggerException;

    private native String demangle0(String var1);

    private static native void initIDs() throws DebuggerException;

    static {
        System.loadLibrary("saproc");
        ProcDebuggerLocal.initIDs();
        loadObjectComparator = new LoadObjectComparator();
    }
}

