/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux.arm;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.arm.ARMThreadContext;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;
import sun.jvm.hotspot.debugger.linux.arm.LinuxARMCFrame;

public class LinuxARMThreadContext
extends ARMThreadContext {
    private LinuxDebugger debugger;

    public LinuxARMThreadContext(LinuxDebugger debugger) {
        this.debugger = debugger;
    }

    @Override
    public void setRegisterAsAddress(int index, Address value) {
        this.setRegister(index, this.debugger.getAddressValue(value));
    }

    @Override
    public Address getRegisterAsAddress(int index) {
        return this.debugger.newAddress(this.getRegister(index));
    }

    @Override
    public LinuxARMCFrame getTopFrame(Debugger dbg) {
        Address sp = this.getRegisterAsAddress(13);
        if (sp == null) {
            return null;
        }
        Address pc = this.getRegisterAsAddress(15);
        if (pc == null) {
            return null;
        }
        return new LinuxARMCFrame((LinuxDebugger)dbg, sp, pc);
    }
}

