/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.ArithmeticInstruction;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86FPInstruction;

public class X86FPArithmeticInstruction
extends X86FPInstruction
implements ArithmeticInstruction {
    private final int operation;
    private final Operand operand1;
    private final Operand operand2;
    private final String description;

    public X86FPArithmeticInstruction(String name, int operation, Operand op1, Operand op2, int size, int prefixes) {
        super(name, size, prefixes);
        this.operation = operation;
        this.operand1 = op1;
        this.operand2 = op2;
        this.description = this.initDescription();
    }

    @Override
    protected String initDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        if (this.operand1 != null) {
            buf.append(this.getOperandAsString(this.operand1));
        }
        if (this.operand2 != null) {
            buf.append(comma);
            buf.append(this.getOperandAsString(this.operand2));
        }
        return buf.toString();
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        return this.description;
    }

    @Override
    public Operand getArithmeticDestination() {
        return this.operand1;
    }

    @Override
    public Operand getOperand1() {
        return this.operand1;
    }

    public Operand getOperand2() {
        return this.operand2;
    }

    @Override
    public Operand[] getArithmeticSources() {
        return new Operand[]{this.operand1, this.operand2};
    }

    @Override
    public int getOperation() {
        return this.operation;
    }

    @Override
    public boolean isArithmetic() {
        return true;
    }
}

