/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCV9PrivilegedRegisterInstruction;

public class SPARCV9WrprInstruction
extends SPARCV9PrivilegedRegisterInstruction {
    private final SPARCRegister rs1;
    private final ImmediateOrRegister operand2;

    public SPARCV9WrprInstruction(SPARCRegister rs1, ImmediateOrRegister operand2, int regNum) {
        super("wrpr", regNum);
        this.rs1 = rs1;
        this.operand2 = operand2;
    }

    @Override
    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.rs1.toString());
        buf.append(comma);
        if (this.operand2.isRegister()) {
            buf.append(this.operand2.toString());
        } else {
            int value = ((Immediate)this.operand2).getNumber().intValue();
            buf.append(Integer.toHexString(value));
        }
        buf.append(comma);
        buf.append(SPARCV9WrprInstruction.getPrivilegedRegisterName(this.regNum));
        return buf.toString();
    }

    public SPARCRegister getSourceRegister1() {
        return this.rs1;
    }

    public ImmediateOrRegister getOperand2() {
        return this.operand2;
    }
}

