/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NetworkAccess {
    private static final Logger err = Logger.getLogger(NetworkAccess.class.getName());
    private static final RequestProcessor NETWORK_ACCESS = new RequestProcessor("autoupdate-network-access", 10, false);

    private NetworkAccess() {
    }

    public static Task createNetworkAcessTask(URL uRL, int n, NetworkListener networkListener) {
        return new Task(uRL, n, networkListener);
    }

    public static void initSSL(HttpURLConnection httpURLConnection) throws IOException {
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            try {
                TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }
                }};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, trustManagerArray, new SecureRandom());
                httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                });
                httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
    }

    public static interface NetworkListener {
        public void streamOpened(InputStream var1, int var2);

        public void accessCanceled();

        public void accessTimeOut();

        public void notifyException(Exception var1);
    }

    private static interface SizedConnection
    extends Callable<InputStream> {
        public int getContentLength();
    }

    public static class Task
    implements Cancellable {
        private URL url;
        private int timeout;
        private NetworkListener listener;
        private ExecutorService es = Executors.newSingleThreadExecutor();
        private Future<InputStream> connect = null;
        private RequestProcessor.Task rpTask = null;

        private Task(URL uRL, int n, NetworkListener networkListener) {
            if (uRL == null) {
                throw new IllegalArgumentException("URL cannot be null.");
            }
            if (networkListener == null) {
                throw new IllegalArgumentException("NetworkListener cannot be null.");
            }
            this.url = uRL;
            this.timeout = n;
            this.listener = networkListener;
            this.postTask();
        }

        private void postTask() {
            final SizedConnection sizedConnection = this.createCallableNetwork(this.url, this.timeout);
            this.rpTask = NETWORK_ACCESS.post(new Runnable(){

                @Override
                public void run() {
                    Task.this.connect = Task.this.es.submit(sizedConnection);
                    InputStream inputStream = null;
                    try {
                        inputStream = (InputStream)Task.this.connect.get(Task.this.timeout, TimeUnit.MILLISECONDS);
                        if (Task.this.connect.isDone()) {
                            Task.this.listener.streamOpened(inputStream, sizedConnection.getContentLength());
                        } else if (Task.this.connect.isCancelled()) {
                            Task.this.listener.accessCanceled();
                        } else {
                            Task.this.listener.accessTimeOut();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Task.this.listener.notifyException(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        if (throwable != null && throwable instanceof Exception) {
                            Task.this.listener.notifyException((Exception)throwable);
                        } else {
                            Task.this.listener.notifyException(executionException);
                        }
                    }
                    catch (CancellationException cancellationException) {
                        Task.this.listener.accessCanceled();
                    }
                    catch (TimeoutException timeoutException) {
                        IOException iOException = new IOException(NbBundle.getMessage(NetworkAccess.class, (String)"NetworkAccess_Timeout", (Object)Task.this.url));
                        iOException.initCause(timeoutException);
                        Task.this.listener.notifyException(iOException);
                    }
                }
            });
        }

        public void waitFinished() {
            assert (this.rpTask != null) : "RequestProcessor.Task must be initialized.";
            this.rpTask.waitFinished();
        }

        public boolean isFinished() {
            assert (this.rpTask != null) : "RequestProcessor.Task must be initialized.";
            return this.rpTask.isFinished();
        }

        private SizedConnection createCallableNetwork(final URL uRL, final int n) {
            return new SizedConnection(){
                private int contentLength = -1;

                @Override
                public int getContentLength() {
                    return this.contentLength;
                }

                @Override
                public InputStream call() throws Exception {
                    Object object;
                    Object object2;
                    Object object3;
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(n);
                    if (uRLConnection instanceof HttpsURLConnection) {
                        NetworkAccess.initSSL((HttpsURLConnection)uRLConnection);
                    }
                    if (uRLConnection instanceof HttpURLConnection) {
                        uRLConnection.connect();
                        if (((HttpURLConnection)uRLConnection).getResponseCode() == 302 && null != (object3 = uRLConnection.getHeaderField("Location")) && !((String)object3).isEmpty()) {
                            object2 = new URL((String)object3);
                            object = ((URL)object2).openConnection();
                            ((URLConnection)object).setRequestProperty("User-Agent", "NetBeans");
                            ((URLConnection)object).setConnectTimeout(n);
                            uRLConnection = (HttpURLConnection)object;
                        }
                    }
                    object3 = uRLConnection.getInputStream();
                    this.contentLength = uRLConnection.getContentLength();
                    object2 = uRLConnection.getHeaderFields();
                    object = new StringBuilder("Connection opened for:\n");
                    ((StringBuilder)object).append("    Url: " + uRLConnection.getURL() + "\n");
                    for (String string : object2.keySet()) {
                        ((StringBuilder)object).append("    " + (string == null ? "Status" : string) + ": " + object2.get(string) + "\n");
                    }
                    ((StringBuilder)object).append("\n");
                    err.log(Level.FINE, ((StringBuilder)object).toString());
                    return new BufferedInputStream((InputStream)object3);
                }
            };
        }

        public boolean cancel() {
            return this.connect.cancel(true);
        }
    }
}

