/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sampler;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.sampler.Bundle;
import org.netbeans.modules.sampler.Sampler;
import org.netbeans.modules.sampler.SamplesOutputStream;
import org.netbeans.modules.sampler.SelfSampleVFS;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

final class InternalSampler
extends Sampler {
    private static final String SAMPLER_NAME = "selfsampler";
    private static final String FILE_NAME = "selfsampler.npss";
    private static final String UNKNOW_MIME_TYPE = "content/unknown";
    private static final String DEBUG_ARG = "-Xdebug";
    private static final Logger LOGGER = Logger.getLogger(InternalSampler.class.getName());
    private static Boolean debugMode;
    private static String lastReason;
    private ProgressHandle progress;

    static InternalSampler createInternalSampler(String string) {
        if (SamplesOutputStream.isSupported() && InternalSampler.isRunMode()) {
            return new InternalSampler(string);
        }
        return null;
    }

    private static synchronized boolean isDebugged() {
        if (debugMode == null) {
            debugMode = Boolean.FALSE;
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            if (list.contains(DEBUG_ARG)) {
                debugMode = Boolean.TRUE;
            }
        }
        return debugMode;
    }

    private static boolean isRunMode() {
        boolean bl = true;
        String string = null;
        if (InternalSampler.isDebugged()) {
            string = "running in debug mode";
            bl = false;
        }
        if (bl) {
            try {
                Class.forName("org.netbeans.lib.profiler.server.ProfilerServer", false, ClassLoader.getSystemClassLoader());
                string = "running under profiler";
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!bl && !string.equals(lastReason)) {
            LOGGER.log(Level.INFO, "Slowness detector disabled - {0}", string);
        }
        lastReason = string;
        return bl;
    }

    InternalSampler(String string) {
        super(string);
    }

    @Override
    protected void printStackTrace(Throwable throwable) {
        Exceptions.printStackTrace((Throwable)throwable);
    }

    @Override
    protected void saveSnapshot(byte[] byArray) throws IOException {
        SelfSampleVFS selfSampleVFS;
        FileObject fileObject;
        File file = File.createTempFile(SAMPLER_NAME, ".npss");
        File file2 = Places.getUserDirectory();
        File file3 = null;
        file = FileUtil.normalizeFile((File)file);
        this.writeToFile(file, byArray);
        if (file2 != null) {
            file3 = new File(new File(new File(file2, "var"), "log"), "uigestures");
        }
        if (UNKNOW_MIME_TYPE.equals((fileObject = (selfSampleVFS = file3 != null && file3.exists() ? new SelfSampleVFS(new String[]{FILE_NAME, "selfsampler.log"}, new File[]{file, file3}) : new SelfSampleVFS(new String[]{FILE_NAME}, new File[]{file})).findResource(FILE_NAME)).getMIMEType())) {
            String string = Bundle.SelfSamplerAction_SavedFile(file.getAbsolutePath());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
        } else {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            ((Openable)dataObject.getLookup().lookup(Openable.class)).open();
        }
    }

    private void writeToFile(File file, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    @Override
    void openProgress(int n) {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        this.progress = ProgressHandleFactory.createHandle((String)Bundle.Save_Progress());
        this.progress.start(n);
    }

    @Override
    void closeProgress() {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        this.progress.finish();
        this.progress = null;
    }

    @Override
    void progress(int n) {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        if (this.progress != null) {
            this.progress.progress(n);
        }
    }
}

