/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.io.IOException;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.TaskConfigurator;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.ui.panels.PIDSelectPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ProfilingSupport {
    public static final String RERUN_PROP = "profiler.rerun";
    private static ProfilingSupport defaultInstance;
    private boolean profilingActionInvoked = false;

    private ProfilingSupport() {
    }

    public static synchronized ProfilingSupport getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingSupport();
        }
        return defaultInstance;
    }

    public boolean checkProfilingInProgress() {
        Profiler profiler = Profiler.getDefault();
        int n = profiler.getProfilingState();
        int n2 = profiler.getProfilingMode();
        if (n == 8 || n == 4) {
            if (n2 == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilingSupport_StopStartProfileSessionMessage(), (String)Bundle.CAPTION_Question())) {
                    return true;
                }
                profiler.stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilingSupport_StopStartAttachSessionMessage(), (String)Bundle.CAPTION_Question())) {
                    return true;
                }
                profiler.detachFromApp();
            }
        }
        return false;
    }

    public int selectApplicationPid() {
        return PIDSelectPanel.selectPID();
    }

    public AttachSTPData selectTaskForAttach(Lookup.Provider provider, SessionSettings sessionSettings) {
        TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureAttachProfilerTask(provider);
        if (configuration == null) {
            return null;
        }
        return new AttachSTPData(configuration.getProfilingSettings(), configuration.getProject());
    }

    public ProfilingSettings selectTaskForProfiling(Lookup.Provider provider, SessionSettings sessionSettings, FileObject fileObject, boolean bl) {
        TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureProfileProjectTask(provider, fileObject, bl);
        if (configuration == null) {
            return null;
        }
        return configuration.getProfilingSettings();
    }

    public void setProfilingActionInvoked(boolean bl) {
        this.profilingActionInvoked = bl;
    }

    public boolean isProfilingActionInvoked() {
        return this.profilingActionInvoked;
    }

    void doAttach() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AttachSTPData attachSTPData;
                    if (ProfilingSupport.this.checkProfilingInProgress()) {
                        return;
                    }
                    Lookup.Provider provider = null;
                    Profiler profiler = Profiler.getDefault();
                    GlobalProfilingSettings globalProfilingSettings = profiler.getGlobalProfilingSettings();
                    SessionSettings sessionSettings = new SessionSettings();
                    sessionSettings.setPortNo(globalProfilingSettings.getPortNo());
                    ProjectProfilingSupport projectProfilingSupport = ProjectProfilingSupport.get(provider);
                    projectProfilingSupport.setupProjectSessionSettings(sessionSettings);
                    boolean bl = false;
                    ProfilingSettings profilingSettings = null;
                    while (!bl) {
                        attachSTPData = ProfilingSupport.this.selectTaskForAttach(provider, sessionSettings);
                        if (attachSTPData == null) {
                            return;
                        }
                        provider = attachSTPData.getProject();
                        profilingSettings = attachSTPData.getSettings();
                        ProfilerLogger.log((String)(">>> Project: " + provider));
                        ProfilerLogger.log((String)(">>> Profiling settings: " + profilingSettings));
                        bl = true;
                    }
                    ((NetBeansProfiler)profiler).setProfiledProject(provider, null);
                    attachSTPData = null;
                    try {
                        attachSTPData = ProjectStorage.loadAttachSettings(provider);
                    }
                    catch (IOException iOException) {
                        ProfilerDialogs.displayWarning((String)Bundle.ProfilingSupport_FailedLoadSettingsMsg(iOException.getMessage()));
                        ProfilerLogger.log((Exception)iOException);
                    }
                    ProfilerLogger.log((String)(">>> Attach settings: " + attachSTPData));
                    if (attachSTPData == null) {
                        attachSTPData = AttachWizard.getDefault().configure((AttachSettings)attachSTPData);
                        if (attachSTPData == null) {
                            return;
                        }
                        ProjectStorage.saveAttachSettings((Lookup.Provider)provider, (AttachSettings)attachSTPData);
                    }
                    if (!attachSTPData.isRemote() && attachSTPData.isDynamic16()) {
                        int n = ProfilingSupport.this.selectApplicationPid();
                        if (n == -1) {
                            return;
                        }
                        attachSTPData.setPid(n);
                    }
                    profiler.attachToApp(profilingSettings, (AttachSettings)attachSTPData);
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                }
            }
        });
    }

    void modifyProfiling() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NetBeansProfiler netBeansProfiler = NetBeansProfiler.getDefaultNB();
                TargetAppRunner targetAppRunner = netBeansProfiler.getTargetAppRunner();
                try {
                    boolean bl = netBeansProfiler.getProfilingMode() == 0;
                    targetAppRunner.getAppStatusHandler().pauseLiveUpdates();
                    ProfilingSettings profilingSettings = ProfilingSupport.this.selectTaskForProfiling(netBeansProfiler.getProfiledProject(), null, netBeansProfiler.getProfiledSingleFile(), bl);
                    if (profilingSettings == null) {
                        return;
                    }
                    netBeansProfiler.modifyCurrentProfiling(profilingSettings);
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                    targetAppRunner.getAppStatusHandler().resumeLiveUpdates();
                }
            }
        });
    }

    public static class AttachSTPData {
        private ProfilingSettings ps;
        private Lookup.Provider p;

        private AttachSTPData(ProfilingSettings profilingSettings, Lookup.Provider provider) {
            this.ps = profilingSettings;
            this.p = provider;
        }

        public Lookup.Provider getProject() {
            return this.p;
        }

        public ProfilingSettings getSettings() {
            return this.ps;
        }
    }
}

