/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;

public final class ProfilingMonitor {
    static final String PROPERTY_SERVER_STATE = "serverState";
    static final String PROPERTY_SERVER_PROGRESS = "serverProgress";
    private UpdateThread monitorThread;
    private boolean updateThreadStarted = false;
    private int serverState = 0;
    private int serverProgress = -1;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ProfilingMonitor() {
        this.monitorThread = new UpdateThread();
    }

    public void monitorVM(TargetAppRunner targetAppRunner) {
        this.setServerState(1);
        this.setServerProgress(-1);
        if (!this.updateThreadStarted) {
            this.updateThreadStarted = true;
            this.monitorThread.start();
        }
        this.monitorThread.monitor(targetAppRunner);
    }

    public void stopDisplayingVM() {
        if (this.monitorThread != null) {
            this.monitorThread.monitor(null);
        }
    }

    public void stopUpdateThread() {
        if (this.monitorThread != null) {
            this.monitorThread.stopThread();
            this.monitorThread = null;
        }
    }

    private void setServerState(int n) {
        if (this.serverState != n) {
            int n2 = this.serverState;
            this.serverState = n;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_SERVER_STATE, n2, n);
        }
    }

    int getServerState() {
        return this.serverState;
    }

    private void setServerProgress(int n) {
        if (this.serverProgress != n) {
            int n2 = this.serverProgress;
            this.serverProgress = n;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_SERVER_PROGRESS, n2, n);
        }
    }

    int getServerProgress() {
        return this.serverProgress;
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    final class UpdateThread
    extends Thread {
        private static final int UPDATE_INTERVAL = 1200;
        private TargetAppRunner runner;
        private ThreadsDataManager threadsDataManager;
        private VMTelemetryDataManager vmTelemetryManager;
        private boolean doUpdateLiveResults;
        private boolean keepRunning;
        private volatile boolean oomeNotified;

        UpdateThread() {
            super("Profiler Monitor");
            this.keepRunning = true;
        }

        public void monitor(TargetAppRunner targetAppRunner) {
            this.oomeNotified = false;
            this.runner = targetAppRunner;
            this.threadsDataManager = Profiler.getDefault().getThreadsManager();
            this.vmTelemetryManager = Profiler.getDefault().getVMTelemetryManager();
            if (targetAppRunner != null) {
                this.vmTelemetryManager.maxHeapSize = targetAppRunner.getProfilingSessionStatus().maxHeapSize;
            }
        }

        @Override
        public void run() {
            while (this.keepRunning) {
                block8: {
                    try {
                        if (this.runner != null) {
                            ProfilerControlPanel2.getDefault().updateStatus();
                            final MonitoredData monitoredData = this.runner.getProfilerClient().getMonitoredData();
                            if (monitoredData != null) {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        block5: {
                                            try {
                                                ProfilingMonitor.this.setServerState(monitoredData.getServerState());
                                                ProfilingMonitor.this.setServerProgress(monitoredData.getServerProgress());
                                                UpdateThread.this.threadsDataManager.processData(monitoredData);
                                                UpdateThread.this.vmTelemetryManager.processData(monitoredData);
                                                if (!(!NetBeansProfiler.getDefaultNB().processesProfilingPoints() || UpdateThread.this.doUpdateLiveResults && LiveResultsWindow.hasDefault())) {
                                                    ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            try {
                                                                ProfilerClient profilerClient = Profiler.getDefault().getTargetAppRunner().getProfilerClient();
                                                                if (profilerClient.getCurrentInstrType() != 1) {
                                                                    profilerClient.forceObtainedResultsDump(true);
                                                                }
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    });
                                                }
                                                if (UpdateThread.this.doUpdateLiveResults && LiveResultsWindow.hasDefault()) {
                                                    LiveResultsWindow.getDefault().refreshLiveResults();
                                                }
                                                UpdateThread.this.doUpdateLiveResults = !UpdateThread.this.doUpdateLiveResults;
                                            }
                                            catch (Exception exception) {
                                                Profiler.getDefault().notifyException(8, exception);
                                            }
                                            catch (OutOfMemoryError outOfMemoryError) {
                                                if (UpdateThread.this.oomeNotified) break block5;
                                                UpdateThread.this.oomeNotified = true;
                                                ProfilerDialogs.displayError((String)Bundle.ProfilingMonitor_OomeMsg());
                                            }
                                        }
                                    }
                                });
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        NetBeansProfiler.getDefaultNB().checkAndUpdateState();
                                    }
                                });
                                this.runner = null;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof ThreadDeath)) break block8;
                        throw (ThreadDeath)throwable;
                    }
                }
                try {
                    UpdateThread.sleep(1200L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }

        private void stopThread() {
            this.keepRunning = false;
        }
    }
}

