/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.resource;

import com.sun.javafx.tools.resource.PackagerResource;
import java.io.File;

public class DeployResource
extends PackagerResource {
    private final Type type;
    private final String mode;
    private final String os;
    private final String arch;
    public static final String TYPE_LICENSE = "license";
    public static final String TYPE_DATA = "data";

    public DeployResource(File baseDir, String path) {
        this(baseDir, path, "eager");
    }

    public DeployResource(File baseDir, File file) {
        this(baseDir, file, "eager");
    }

    public DeployResource(File baseDir, String path, String mode) {
        super(baseDir, path);
        this.mode = mode;
        this.type = null;
        this.os = null;
        this.arch = null;
    }

    public DeployResource(File baseDir, File file, String mode) {
        this(baseDir, file, mode, null, null, null);
    }

    public DeployResource(File baseDir, File file, String mode, String type, String os, String arch) {
        super(baseDir, file);
        this.type = type == null ? (file.getName().endsWith(".jar") ? Type.jar : (file.getName().endsWith(".jnlp") ? Type.jnlp : Type.UNKNOWN)) : Type.valueOf(type);
        this.os = os;
        this.arch = arch;
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public Type getType() {
        return this.type;
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNKNOWN,
        jnlp,
        jar,
        nativelib,
        icon,
        license,
        data;

    }
}

