/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.sun.javafx.tools.ant.Callback;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.HtmlParam;
import com.sun.javafx.tools.packager.JSCallback;
import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.packager.bundlers.RelativeFileSet;
import com.sun.javafx.tools.resource.DeployResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployParams
extends CommonParams {
    final List<DeployResource> resources = new ArrayList<DeployResource>();
    String id;
    String title;
    String vendor;
    String description;
    String category;
    String licenseType;
    String copyright;
    String version;
    Boolean systemWide;
    String applicationClass;
    String preloader;
    List<Param> params;
    List<HtmlParam> htmlParams;
    List<String> arguments;
    int width;
    int height;
    String embeddedWidth = null;
    String embeddedHeight = null;
    String appName;
    String codebase;
    boolean embedJNLP = true;
    boolean embedCertificates = false;
    boolean allPermissions = false;
    String updateMode = "background";
    boolean isExtension = false;
    boolean isSwingApp = false;
    boolean needShortcut = false;
    boolean needMenu = false;
    boolean needInstall = false;
    String outfile;
    boolean includeDT;
    String placeholder = null;
    String appId = null;
    boolean offlineAllowed = true;
    List<JSCallback> callbacks;
    List<Template> templates = new LinkedList<Template>();
    String jrePlatform = "1.6+";
    String fxPlatform = "2.2+";
    File javaRuntimeToUse = null;
    boolean javaRuntimeWasSet = false;
    List<String> jvmargs = new LinkedList<String>();
    Map<String, String> jvmUserArgs = new HashMap<String, String>();
    Map<String, String> properties = new HashMap<String, String>();
    String fallbackApp = "com.javafx.main.NoJavaFXFallback";
    List<Icon> icons = new LinkedList<Icon>();
    BundleParams bundleParams = null;
    Bundler.BundleType bundleType = Bundler.BundleType.NONE;
    String targetFormat = null;

    public void setJavaRuntimeSource(File src) {
        this.javaRuntimeToUse = src;
        this.javaRuntimeWasSet = true;
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSystemWide(Boolean systemWide) {
        this.systemWide = systemWide;
    }

    public void setJRE(String v) {
        this.jrePlatform = v;
    }

    public void setSwingAppWithEmbeddedJavaFX(boolean v) {
        this.isSwingApp = v;
    }

    public void setNeedInstall(boolean b) {
        this.needInstall = b;
    }

    public void setOfflineAllowed(boolean b) {
        this.offlineAllowed = b;
    }

    public void setNeedShortcut(boolean b) {
        this.needShortcut = b;
    }

    public void setNeedMenu(boolean b) {
        this.needMenu = b;
    }

    public void setEmbeddedDimensions(String w, String h) {
        this.embeddedWidth = w;
        this.embeddedHeight = h;
    }

    public void setFallback(String v) {
        if (v == null) {
            return;
        }
        this.fallbackApp = "none".equals(v) || "null".equals(v) ? null : v;
    }

    public void setJavafx(String v) {
        this.fxPlatform = v;
    }

    public void addJvmArg(String v) {
        this.jvmargs.add(v);
    }

    public void addJvmUserArg(String n, String v) {
        this.jvmUserArgs.put(n, v);
    }

    public void addJvmProperty(String n, String v) {
        this.properties.put(n, v);
    }

    public void setAllPermissions(boolean allPermissions) {
        this.allPermissions = allPermissions;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setArguments(List<String> args) {
        this.arguments = args;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEmbedJNLP(boolean embedJNLP) {
        this.embedJNLP = embedJNLP;
    }

    public void setEmbedCertifcates(boolean v) {
        this.embedCertificates = v;
    }

    public void setPlaceholder(String p) {
        this.placeholder = p;
    }

    public void setAppId(String id) {
        this.appId = id;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setHtmlParams(List<HtmlParam> htmlParams) {
        this.htmlParams = htmlParams;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    public void setPreloader(String preloader) {
        this.preloader = preloader;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = updateMode;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setExtension(boolean isExtension) {
        this.isExtension = isExtension;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public void setIncludeDT(boolean doEmbed) {
        this.includeDT = doEmbed;
    }

    public void setJSCallbacks(List<JSCallback> list) {
        this.callbacks = list;
    }

    public void setCallbacks(List<Callback> list) {
        ArrayList<JSCallback> jslist = new ArrayList<JSCallback>(list.size());
        for (Callback cb : list) {
            jslist.add(new JSCallback(cb.getName(), cb.getCmd()));
        }
        this.callbacks = jslist;
    }

    public void addTemplate(File in, File out) {
        this.templates.add(new Template(in, out));
    }

    List<File> expandFileset(File root) {
        LinkedList<File> files = new LinkedList<File>();
        if (IOUtils.isNotSymbolicLink(root)) {
            if (root.isDirectory()) {
                for (File f : root.listFiles()) {
                    files.addAll(this.expandFileset(f));
                }
            } else {
                files.add(root);
            }
        }
        return files;
    }

    @Override
    public void addResource(File baseDir, String path) {
        File file = new File(baseDir, path);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        for (File f : this.expandFileset(file)) {
            this.resources.add(new DeployResource(baseDir, f));
        }
    }

    @Override
    public void addResource(File baseDir, File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        for (File f : this.expandFileset(file)) {
            this.resources.add(new DeployResource(baseDir, f));
        }
    }

    public void addResource(File baseDir, String path, String type) {
        this.resources.add(new DeployResource(baseDir, path, type));
    }

    public void addResource(File baseDir, File file, String type) {
        this.resources.add(new DeployResource(baseDir, file, type));
    }

    public void addResource(File baseDir, File file, String mode, String type, String os, String arch) {
        this.resources.add(new DeployResource(baseDir, file, mode, type, os, arch));
    }

    @Override
    public void validate() throws PackagerException {
        if (this.outdir == null) {
            throw new PackagerException("ERR_MissingArgument", "-outdir");
        }
        if (this.outfile == null) {
            throw new PackagerException("ERR_MissingArgument", "-outfile");
        }
        if (this.resources.isEmpty()) {
            throw new PackagerException("ERR_MissingAppResources");
        }
        if (this.applicationClass == null) {
            throw new PackagerException("ERR_MissingArgument", "-appclass");
        }
    }

    public void addIcon(String href, String kind, int w, int h, int d, RunMode m) {
        this.icons.add(new Icon(href, kind, w, h, d, m));
    }

    public void setBundleType(Bundler.BundleType type) {
        this.bundleType = type;
    }

    public void setTargetFormat(String t) {
        this.targetFormat = t;
    }

    private String getArch() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if ("x86".equals(arch) || "i386".equals(arch) || "i486".equals(arch) || "i586".equals(arch) || "i686".equals(arch)) {
            arch = "x86";
        } else if ("x86_64".equals(arch) || "amd64".equals("arch")) {
            arch = "x86_64";
        }
        return arch;
    }

    public BundleParams getBundleParams() {
        if (this.bundleParams == null && this.bundleType != Bundler.BundleType.NONE) {
            this.bundleParams = new BundleParams();
            HashSet<File> files = new HashSet<File>();
            String currentOS = System.getProperty("os.name").toLowerCase();
            String currentArch = this.getArch();
            for (DeployResource r : this.resources) {
                String os = r.getOs();
                String arch = r.getArch();
                if (os != null && !currentOS.contains(os.toLowerCase()) || arch != null && !currentArch.startsWith(arch.toLowerCase()) || r.getType() == DeployResource.Type.nativelib) continue;
                files.add(new File(this.outdir, r.getRelativePath()));
                if (r.getType() != DeployResource.Type.license) continue;
                this.bundleParams.addLicenseFile(r.getRelativePath());
            }
            RelativeFileSet appResources = new RelativeFileSet(this.outdir, files);
            this.bundleParams.setIdentifier(this.id);
            this.bundleParams.setAppResource(appResources);
            if (this.javaRuntimeWasSet) {
                this.bundleParams.setRuntime(this.javaRuntimeToUse);
            } else {
                this.bundleParams.setDefaultRuntime();
            }
            this.bundleParams.setApplicationClass(this.applicationClass);
            this.bundleParams.setName(this.appName);
            this.bundleParams.setAppVersion(this.version);
            this.bundleParams.setType(this.bundleType);
            this.bundleParams.setBundleFormat(this.targetFormat);
            this.bundleParams.setVendor(this.vendor);
            this.bundleParams.setShortcutHint(this.needShortcut);
            this.bundleParams.setMenuHint(this.needMenu);
            this.bundleParams.setSystemWide(this.systemWide);
            this.bundleParams.setCopyright(this.copyright);
            this.bundleParams.setApplicationCategory(this.category);
            this.bundleParams.setLicenseType(this.licenseType);
            this.bundleParams.setDescription(this.description);
            this.bundleParams.setTitle(this.title);
            this.bundleParams.setJvmProperties(this.properties);
            this.bundleParams.setJvmargs(this.jvmargs);
            this.bundleParams.setJvmUserArgs(this.jvmUserArgs);
            File appIcon = null;
            for (Icon ic : this.icons) {
                if (ic.kind != null && !ic.kind.equals("default") || (appIcon = new File(ic.href)).exists()) continue;
                Log.debug("Icon [" + ic.href + "] is not valid absolute path. " + "Assume it is relative to the output dir.");
                appIcon = new File(this.outdir, ic.href);
            }
            this.bundleParams.setIcon(appIcon);
        }
        return this.bundleParams;
    }

    static class Icon {
        static final int UNDEFINED = -1;
        String href;
        String kind;
        int width = -1;
        int height = -1;
        int depth = -1;
        RunMode mode = RunMode.WEBSTART;

        Icon(String href, String kind, int w, int h, int d, RunMode m) {
            this.mode = m;
            this.href = href;
            this.kind = kind;
            if (w > 0) {
                this.width = w;
            }
            if (h > 0) {
                this.height = h;
            }
            if (d > 0) {
                this.depth = d;
            }
        }
    }

    static class Template {
        File in;
        File out;

        Template(File in, File out) {
            this.in = in;
            this.out = out;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunMode {
        WEBSTART,
        EMBEDDED,
        STANDALONE,
        ALL;

    }
}

