/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.wizards;

import com.jrockit.mc.ui.checkedstate.CheckedStateManager;
import com.jrockit.mc.ui.checkedstate.ContainerProviderModifier;
import com.jrockit.mc.ui.checkedstate.SetProviderModifier;
import com.jrockit.mc.ui.wizards.Messages;
import java.util.Collection;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class TreeContentProviderWizardPage
extends WizardPage {
    private CheckedStateManager m_checkManager;
    private boolean m_selectAllAtStart;
    public static final String TREE_NAME = "wizards.importexport.tree.name";

    public TreeContentProviderWizardPage(String pageName) {
        super(pageName);
    }

    protected void initialize() {
    }

    public void createControl(Composite parent) {
        this.initialize();
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        control.setLayout((Layout)layout);
        Control topContainer = this.createTopContainer(control);
        if (topContainer != null) {
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            topContainer.setLayoutData((Object)gd);
        }
        GridData gd1 = new GridData(4, 4, true, true);
        Composite contents = this.createContents(control);
        contents.setLayoutData((Object)gd1);
        contents.setData("name", (Object)TREE_NAME);
        GridData gd2 = new GridData(4, 4, false, true);
        Composite buttonContainer = this.createButtonContainer(control);
        buttonContainer.setLayoutData((Object)gd2);
        Control bottomContainer = this.createBottomContainer(control);
        if (bottomContainer != null) {
            GridData gd3 = new GridData(4, 4, true, false);
            gd3.horizontalSpan = 1;
            bottomContainer.setLayoutData((Object)gd3);
        }
        this.setControl((Control)control);
    }

    protected abstract void initializeViewer(TreeViewer var1);

    protected Control createBottomContainer(Composite parent) {
        return null;
    }

    protected Control createTopContainer(Composite parent) {
        return null;
    }

    protected Composite createButtonContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        this.createButtonWithHandler(container, Messages.TreeContentProviderWizardPage_SELECT_ALL_TEXT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeContentProviderWizardPage.this.m_checkManager.selectAll();
                TreeContentProviderWizardPage.this.updatePageComplete();
            }
        });
        this.createButtonWithHandler(container, Messages.TreeContentProviderWizardPage_DESELECT_ALL_TEXT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeContentProviderWizardPage.this.m_checkManager.deselectAll();
                TreeContentProviderWizardPage.this.updatePageComplete();
            }
        });
        return container;
    }

    private Control createButtonWithHandler(Composite parent, String text, SelectionListener s) {
        GridData gd1 = new GridData(4, 4, true, false);
        Button button = new Button(parent, 0);
        button.setText(text);
        button.addSelectionListener(s);
        button.setLayoutData((Object)gd1);
        return button;
    }

    protected void updatePageComplete() {
        this.m_checkManager.getViewer().getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeContentProviderWizardPage.this.setPageComplete(TreeContentProviderWizardPage.this.getSelectedItems().size() > 0);
            }
        });
    }

    protected Composite createContents(Composite parent) {
        CheckboxTreeViewer ctw = new CheckboxTreeViewer(parent);
        this.initializeViewer((TreeViewer)ctw);
        this.m_checkManager = new CheckedStateManager(ctw);
        ContainerProviderModifier spm = new ContainerProviderModifier(this.m_checkManager);
        SetProviderModifier setProviderModifier = new SetProviderModifier();
        this.m_checkManager.addModifierProvider(spm);
        this.m_checkManager.addModifierProvider(setProviderModifier);
        this.setPageComplete(false);
        ctw.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TreeContentProviderWizardPage.this.updatePageComplete();
            }
        });
        if (this.m_selectAllAtStart) {
            this.m_checkManager.selectAll();
            this.updatePageComplete();
        }
        return ctw.getTree();
    }

    protected void setSelectAllAtStart(boolean selectAllAtStart) {
        this.m_selectAllAtStart = selectAllAtStart;
    }

    public Collection<?> getSelectedItems() {
        return this.m_checkManager.getAllChecked();
    }
}

