/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Token;
import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;

public class PercentageField
extends NumberField {
    private final NumberFormat m_percantageFormat = NumberFormat.getPercentInstance();

    public PercentageField(int id) {
        this(id, 2);
    }

    public PercentageField(int id, int accuracy) {
        super(id);
        this.m_percantageFormat.setMinimumFractionDigits(accuracy);
        this.m_percantageFormat.setMaximumFractionDigits(accuracy);
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number && PercentageField.isValid((Number)object)) {
            return this.m_percantageFormat.format(((Number)object).doubleValue());
        }
        return Field.defaultFormat(null);
    }

    @Override
    public String formatForClipboard(Object object) {
        if (object instanceof Number) {
            return NumberField.formatNumberForClipboard(100.0 * ((Number)object).doubleValue());
        }
        return Field.defaultFormat(null);
    }

    @Override
    public String getUnit() {
        return "%";
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        Token token = tokenizer.peek();
        ParsePosition pp = new ParsePosition(token.start);
        Number number = NumberFormat.getPercentInstance().parse(NumberField.replaceWithBreakingSpace(tokenizer.getText()), pp);
        if (pp.getIndex() != token.start) {
            tokenizer.setCharacterPosition(pp.getIndex());
            return number.doubleValue();
        }
        number = NumberField.parseNumber(tokenizer);
        if (number != null) {
            return number.doubleValue();
        }
        return null;
    }
}

