/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Token;
import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Messages;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.osgi.util.NLS;

public class NumberField
extends Field {
    private static NumberFormat m_numberFormat = NumberFormat.getInstance();
    private static NumberFormat m_numberHighPrecision = NumberFormat.getInstance();

    public NumberField(int id) {
        super(id);
    }

    public static boolean isValid(Number number) {
        if (number instanceof Integer) {
            return number.intValue() != Integer.MIN_VALUE;
        }
        if (number instanceof Long) {
            return number.longValue() != Long.MIN_VALUE;
        }
        if (number instanceof Double) {
            return !NumberField.isPatchedNanosNA(number.doubleValue()) && !Double.isNaN(number.doubleValue()) && number.doubleValue() != Double.NEGATIVE_INFINITY;
        }
        if (number instanceof Float) {
            return !Float.isNaN(number.floatValue()) && number.floatValue() != Float.NEGATIVE_INFINITY;
        }
        return true;
    }

    private static boolean isPatchedNanosNA(double doubleValue) {
        return doubleValue == -9.223372036854775E12;
    }

    public static String formatNumber(Number number) {
        if (NumberField.isValid(number)) {
            return NumberField.removeNonBreakingSpace(m_numberFormat.format(number));
        }
        return NumberField.defaultFormat(null);
    }

    protected static String removeNonBreakingSpace(String s) {
        return s.replace('\u00a0', ' ');
    }

    protected static String replaceWithBreakingSpace(String s) {
        return s.replace(' ', '\u00a0');
    }

    public static String formatNumberForClipboard(Number number) {
        return NumberField.removeNonBreakingSpace(NumberField.formatNumber(number));
    }

    public static String formatNumberForClipboardWithPrecision(Number value, int fractionDigits) {
        if (NumberField.isValid(value)) {
            m_numberHighPrecision.setMaximumFractionDigits(fractionDigits);
            m_numberHighPrecision.setMinimumFractionDigits(fractionDigits);
            return NumberField.removeNonBreakingSpace(m_numberHighPrecision.format(value));
        }
        return NumberField.defaultFormat(null);
    }

    public void setTimeBased(boolean derivative) {
        this.setBoolean("timeBased", derivative);
    }

    public boolean getTimeBased() {
        return this.getBoolean("timeBased", false);
    }

    protected String getTimeUnit(String unit) {
        return this.getTimeBased() ? NLS.bind((String)Messages.NumberField_UNIT_PER_SECOND, (Object)unit) : unit;
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number) {
            return NumberField.formatNumber((Number)object);
        }
        return super.formatObject(object);
    }

    @Override
    public String formatForClipboard(Object object) {
        if (object instanceof Number) {
            return NumberField.formatNumberForClipboard((Number)object);
        }
        return super.formatObject(object);
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        return NumberField.parseNumber(tokenizer);
    }

    @Override
    public int compare(Object a, Object b, boolean order) {
        if (a instanceof Number && b instanceof Number) {
            return order ? NumberField.compareNumber((Number)a, (Number)b) : NumberField.compareNumber((Number)b, (Number)a);
        }
        return order ? NumberField.defaultFormat(a).compareTo(NumberField.defaultFormat(b)) : NumberField.defaultFormat(b).compareTo(NumberField.defaultFormat(a));
    }

    public static int compareNumber(Number numberA, Number numberB) {
        double b;
        double a = numberA.doubleValue();
        if (a < (b = numberB.doubleValue())) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    protected static Double parseNumber(Tokenizer tokenizer) throws ParseException {
        Token token = tokenizer.peek();
        if (token != null) {
            ParsePosition p = new ParsePosition(token.start);
            Number n = m_numberFormat.parse(NumberField.replaceWithBreakingSpace(tokenizer.getText()), p);
            if (p.getIndex() != token.start) {
                tokenizer.setCharacterPosition(p.getIndex());
                return n.doubleValue();
            }
            throw new ParseException("Numeric value " + token.text + " could not be read.", token.start);
        }
        return null;
    }
}

