/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.ExceptionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class DialogToolkit {
    private DialogToolkit() {
    }

    public static void showError(Shell shell, String title, String message) {
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
    }

    public static void showException(Shell shell, String title, Throwable t) {
        ExceptionDialog.openExceptionDialog(shell, title, t.getMessage(), t);
    }

    public static void showException(Shell shell, String title, String message, Throwable t) {
        ExceptionDialog.openExceptionDialog(shell, title, message, t);
    }

    public static boolean openWizard(Shell shell, IWizard wizard) {
        WizardDialog dlg = new WizardDialog(shell, wizard);
        dlg.create();
        return dlg.open() == 0;
    }

    public static synchronized void showExceptionDialogAsync(final Display display, final String title, final String message, final Throwable t) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DialogToolkit.showException(display.getActiveShell(), title, message, t);
            }
        });
    }

    public static synchronized void showExceptionDialogAsync(Display display, String title, Throwable t) {
        DialogToolkit.showExceptionDialogAsync(display, title, t.getMessage(), t);
    }

    public static synchronized void showErrorDialogAsync(final Display display, final String title, final String message) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DialogToolkit.showError(display.getActiveShell(), title, message);
            }
        });
    }

    public static void showWarning(Shell shell, String title, String message) {
        MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
    }

    public static synchronized void showWarningDialogAsync(final Display display, final String title, final String message) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)display.getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public static boolean openQuestionOnUiThread(final String title, final String message) {
        final boolean[] result = new boolean[1];
        DisplayToolkit.safeSyncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
        return result[0];
    }
}

