/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.Messages;
import com.jrockit.mc.ui.fields.TableSettingsDialog;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.IFieldUI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FieldTableEditAction
extends Action {
    private IFieldUI[] m_fields;
    private final boolean showSortOrderSetting;

    public FieldTableEditAction(IDialogSettings settings) {
        this(true);
    }

    public FieldTableEditAction(boolean showSortOrderSetting) {
        this.setText(Messages.TableSectionPart_TABLE_SETTINGS_TEXT);
        this.setToolTipText(Messages.TableSectionPart_TABLE_SETTINGS_TEXT);
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("settings_obj.gif"));
        this.setId("field.table.edit");
        this.showSortOrderSetting = showSortOrderSetting;
    }

    public void setFields(IFieldUI[] fields) {
        this.m_fields = fields;
    }

    public IFieldUI[] getFields() {
        return this.m_fields;
    }

    public void run() {
        Shell shell = Display.getCurrent().getActiveShell();
        HashSet<IFieldUI> beforeSet = new HashSet<IFieldUI>(FieldTableEditAction.getVisibleFields(this.getFields()));
        TableSettingsDialog tsd = new TableSettingsDialog(shell, this.m_fields, this.showSortOrderSetting);
        tsd.open();
        HashSet<IFieldUI> afterSet = new HashSet<IFieldUI>(FieldTableEditAction.getVisibleFields(this.m_fields));
        if (!beforeSet.equals(afterSet)) {
            if (this.m_fields.length > 0) {
                ((Field)this.m_fields[0]).setChanged();
                ((Field)this.m_fields[0]).notifyListeners("visibility.change");
            }
            this.notifyResult(true);
        }
    }

    static List<IFieldUI> getVisibleFields(IFieldUI[] fields) {
        ArrayList<IFieldUI> list = new ArrayList<IFieldUI>();
        if (fields != null) {
            IFieldUI[] iFieldUIArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IFieldUI field = iFieldUIArray[n2];
                if (field.isVisible()) {
                    list.add(field);
                }
                ++n2;
            }
        }
        return list;
    }
}

