/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class Stamps {
    private static final Logger LOG = Logger.getLogger(Stamps.class.getName());
    private static AtomicLong moduleJARs;
    private static File moduleNewestFile;
    private static String[] dirs;
    private static File[] fallbackCache;
    private static boolean populated;
    private Worker worker = new Worker();
    private static final Stamps MODULES_JARS;

    private Stamps() {
    }

    static void main(String ... stringArray) {
        if (stringArray.length == 1 && "reset".equals(stringArray[0])) {
            moduleJARs = null;
            dirs = null;
            fallbackCache = null;
            Stamps.stamp(false);
            return;
        }
        if (stringArray.length == 1 && "init".equals(stringArray[0])) {
            moduleJARs = null;
            dirs = null;
            fallbackCache = null;
            Stamps.stamp(true);
            return;
        }
        if (stringArray.length == 1 && "clear".equals(stringArray[0])) {
            moduleJARs = null;
            dirs = null;
            fallbackCache = null;
            return;
        }
    }

    public static Stamps getModulesJARs() {
        return MODULES_JARS;
    }

    public long lastModified() {
        return Stamps.moduleJARs();
    }

    public boolean exists(String string) {
        return this.file(string, null) != null;
    }

    public InputStream asStream(String string) {
        ByteBuffer byteBuffer = this.asByteBuffer(string, false, false);
        if (byteBuffer == null) {
            return null;
        }
        return new ByteArrayInputStream(byteBuffer.array());
    }

    public MappedByteBuffer asMappedByteBuffer(String string) {
        return (MappedByteBuffer)this.asByteBuffer(string, true, true);
    }

    public ByteBuffer asByteBuffer(String string) {
        return this.asByteBuffer(string, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final File file(String string, int[] nArray) {
        Stamps.checkPopulateCache();
        Object object = this;
        synchronized (object) {
            if (this.worker.isProcessing(string)) {
                LOG.log(Level.FINE, "Worker processing when asking for {0}", string);
                return null;
            }
        }
        object = Places.getCacheSubfile((String)string);
        long l = ((File)object).lastModified();
        if (l <= 0L) {
            LOG.log(Level.FINE, "Cache does not exist when asking for {0}", string);
            object = Stamps.findFallbackCache(string);
            if (object == null || (l = ((File)object).lastModified()) <= 0L) {
                return null;
            }
            LOG.log(Level.FINE, "Found fallback cache at {0}", object);
        }
        if (Stamps.moduleJARs() > l) {
            LOG.log(Level.FINE, "Timestamp does not pass when asking for {0}. Newest file {1}", new Object[]{string, moduleNewestFile});
            return null;
        }
        long l2 = ((File)object).length();
        if (l2 > Integer.MAX_VALUE) {
            LOG.warning("Cache file is too big: " + l2 + " bytes for " + object);
            return null;
        }
        if (nArray != null) {
            nArray[0] = (int)l2;
        }
        LOG.log(Level.FINE, "Cache found: {0}", string);
        return object;
    }

    private ByteBuffer asByteBuffer(String string, boolean bl, boolean bl2) {
        int[] nArray = new int[1];
        File file = this.file(string, nArray);
        if (file == null) {
            return null;
        }
        try {
            ByteBuffer byteBuffer;
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            if (bl2) {
                byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, nArray[0]);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                byteBuffer = bl ? ByteBuffer.allocateDirect(nArray[0]) : ByteBuffer.allocate(nArray[0]);
                int n = fileChannel.read(byteBuffer);
                if (n != nArray[0]) {
                    LOG.warning("Read less than expected: " + n + " expected: " + nArray + " for " + file);
                    return null;
                }
                byteBuffer.flip();
            }
            fileChannel.close();
            return byteBuffer;
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Cannot read cache " + file, iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSave(Updater updater, String string, boolean bl) {
        boolean bl2;
        Worker worker = this.worker;
        synchronized (worker) {
            bl2 = this.worker.addStorage(new Store(updater, string, bl));
        }
        LOG.log(bl2 ? Level.FINE : Level.FINER, "Scheduling save for {0} cache", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(int n) {
        Worker worker = this.worker;
        synchronized (worker) {
            this.worker.start(n);
        }
    }

    public void shutdown() {
        this.waitFor(true);
    }

    public void discardCaches() {
        Stamps.discardCachesImpl(moduleJARs);
    }

    private static void discardCachesImpl(AtomicLong atomicLong) {
        File file = Places.getUserDirectory();
        long l = System.currentTimeMillis();
        if (file != null) {
            File file2 = new File(file, ".lastModified");
            if (file2.exists()) {
                file2.setLastModified(l);
            } else {
                file2.getParentFile().mkdirs();
                try {
                    file2.createNewFile();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Cannot create " + file2, iOException);
                }
            }
        }
        if (atomicLong != null) {
            atomicLong.set(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void waitFor(boolean bl) {
        Worker worker;
        Worker worker2 = this.worker;
        synchronized (worker2) {
            this.flush(0);
            worker = this.worker;
        }
        worker.waitFor(bl);
    }

    static long moduleJARs() {
        AtomicLong atomicLong = moduleJARs;
        if (atomicLong == null) {
            atomicLong = new AtomicLong();
            AtomicReference<File> atomicReference = new AtomicReference<File>();
            Stamps.stamp(true, atomicLong, atomicReference);
            moduleJARs = atomicLong;
            moduleNewestFile = atomicReference.get();
        }
        return atomicLong.longValue();
    }

    private static AtomicLong stamp(boolean bl) {
        AtomicLong atomicLong = new AtomicLong();
        AtomicReference<File> atomicReference = new AtomicReference<File>();
        Stamps.stamp(bl, atomicLong, atomicReference);
        return atomicLong;
    }

    private static synchronized String[] dirs() {
        if (dirs == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = System.getProperty("netbeans.dirs");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            dirs = arrayList.toArray(new String[arrayList.size()]);
        }
        return dirs;
    }

    private static void stamp(boolean bl, AtomicLong atomicLong, AtomicReference<File> atomicReference) {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<File> hashSet = new HashSet<File>();
        String string = System.getProperty("netbeans.home");
        if (string != null) {
            long l = Stamps.stampForCluster(new File(string), atomicLong, atomicReference, hashSet, bl, true, null);
            stringBuilder.append("home=").append(l).append('\n');
        }
        for (String string2 : Stamps.dirs()) {
            File file = new File(string2);
            long l = Stamps.stampForCluster(file, atomicLong, atomicReference, hashSet, bl, true, null);
            if (l == -1L) continue;
            stringBuilder.append(file.getName()).append('=').append(l).append('\n');
        }
        File file = Places.getUserDirectory();
        if (file != null) {
            AtomicInteger atomicInteger = new AtomicInteger();
            Stamps.stampForCluster(file, atomicLong, atomicReference, new HashSet<File>(), false, false, atomicInteger);
            stringBuilder.append("user=").append(atomicLong.longValue()).append('\n');
            stringBuilder.append("crc=").append(atomicInteger.intValue()).append('\n');
            stringBuilder.append("locale=").append(Locale.getDefault()).append('\n');
            stringBuilder.append("branding=").append(NbBundle.getBranding()).append('\n');
            File file2 = new File(Places.getCacheDirectory(), "lastModified/all-checksum.txt");
            if (!Stamps.compareAndUpdateFile(file2, stringBuilder.toString(), atomicLong)) {
                Stamps.discardCachesImpl(atomicLong);
            }
        }
    }

    private static long stampForCluster(File file, AtomicLong atomicLong, AtomicReference<File> atomicReference, Set<File> set, boolean bl, boolean bl2, AtomicInteger atomicInteger) {
        long l;
        File file2 = new File(file, ".lastModified");
        if (bl && (l = file2.lastModified()) > 0L) {
            if (l > atomicLong.longValue()) {
                atomicReference.set(file2);
                atomicLong.set(l);
            }
            return l;
        }
        if (Places.getUserDirectory() != null) {
            file2 = new File(new File(Places.getCacheDirectory(), "lastModified"), Stamps.clusterLocalStamp(file));
            if (bl && (l = file2.lastModified()) > 0L) {
                if (l > atomicLong.longValue()) {
                    atomicReference.set(file2);
                    atomicLong.set(l);
                }
                return l;
            }
        } else {
            bl2 = false;
        }
        File file3 = new File(new File(file, "config"), "Modules");
        File file4 = new File(file, "modules");
        AtomicReference<File> atomicReference2 = new AtomicReference<File>();
        AtomicLong atomicLong2 = new AtomicLong();
        if (!(Stamps.highestStampForDir(file3, atomicReference2, atomicLong2, atomicInteger) && Stamps.highestStampForDir(file4, atomicReference2, atomicLong2, atomicInteger) || file.isDirectory())) {
            return -1L;
        }
        if (atomicLong2.longValue() > atomicLong.longValue()) {
            atomicReference.set(atomicReference2.get());
            atomicLong.set(atomicLong2.longValue());
        }
        if (bl2) {
            try {
                file2.getParentFile().mkdirs();
                file2.createNewFile();
                file2.setLastModified(atomicLong2.longValue());
            }
            catch (IOException iOException) {
                System.err.println("Cannot write timestamp to " + file2);
            }
        }
        return atomicLong2.longValue();
    }

    private static boolean highestStampForDir(File file, AtomicReference<File> atomicReference, AtomicLong atomicLong, AtomicInteger atomicInteger) {
        if (file.getName().equals(".nbattrs")) {
            return true;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            long l;
            if (atomicInteger != null) {
                atomicInteger.addAndGet(file.getName().length());
            }
            if ((l = file.lastModified()) > atomicLong.longValue()) {
                atomicReference.set(file);
                atomicLong.set(l);
            }
            return false;
        }
        for (File file2 : fileArray) {
            Stamps.highestStampForDir(file2, atomicReference, atomicLong, atomicInteger);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compareAndUpdateFile(File file, String string, AtomicLong atomicLong) {
        try {
            long l;
            boolean bl;
            boolean bl2;
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = new byte[byArray.length];
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                int n = fileInputStream.read(byArray2);
                bl2 = n == byArray2.length && fileInputStream.available() == 0 && Arrays.equals(byArray, byArray2);
                bl = !bl2;
                l = file.lastModified();
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl2 = true;
                bl = true;
                l = atomicLong.get();
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            if (bl) {
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                if (bl2) {
                    file.setLastModified(l);
                }
            } else if (l > atomicLong.get()) {
                atomicLong.set(l);
            }
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static void deleteCache(File file) throws IOException {
        int n = 0;
        if (file.exists()) {
            File file2 = new File(file.getParentFile(), file.getName() + "." + n++);
            file2.delete();
            boolean bl = false;
            Random random = null;
            for (int i = 0; i < 10 && !(bl = file.renameTo(file2)); ++i) {
                LOG.log(Level.INFO, "cannot rename (#{0}): {1}", new Object[]{i, file});
                System.gc();
                System.runFinalization();
                LOG.info("after GC");
                if (random == null) {
                    random = new Random();
                }
                try {
                    int n2 = random.nextInt(1000) + 1;
                    Thread.sleep(n2);
                    LOG.log(Level.INFO, "Slept {0} ms", n2);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.INFO, "Interrupted", interruptedException);
                }
            }
            if (!bl) {
                file.deleteOnExit();
                throw new IOException("Could not delete: " + file);
            }
            if (!file2.delete()) {
                file2.deleteOnExit();
            }
        }
    }

    private static File findFallbackCache(String string) {
        if (fallbackCache == null) {
            File file;
            fallbackCache = new File[0];
            if (Stamps.dirs().length >= 1 && (file = new File(new File(new File(Stamps.dirs()[0]), "var"), "cache")).isDirectory()) {
                fallbackCache = new File[]{file};
            }
        }
        if (fallbackCache.length == 0) {
            return null;
        }
        return new File(fallbackCache[0], string);
    }

    static void checkPopulateCache() {
        if (populated) {
            return;
        }
        populated = true;
        File file = Places.getCacheDirectory();
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            return;
        }
        InputStream inputStream = Stamps.getModulesJARs().asStream("populate.zip");
        if (inputStream == null) {
            return;
        }
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            ZipEntry zipEntry;
            byte[] byArray = new byte[4096];
            LOG.log(Level.FINE, "Found populate.zip about to extract it into {0}", file);
            zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (zipEntry.isDirectory()) continue;
                File file2 = new File(file, zipEntry.getName().replace('/', File.separatorChar));
                file2.getParentFile().mkdirs();
                fileOutputStream = new FileOutputStream(file2);
                while ((n = zipInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Failed to populate {0}", file);
        }
    }

    static String clusterLocalStamp(File file) {
        return file.getName().replaceAll("\\.\\.", "__");
    }

    static String readRelativePath(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        if (string.isEmpty()) {
            return string;
        }
        String string2 = dataInput.readUTF();
        if ("user".equals(string)) {
            return System.getProperty("netbeans.user").concat(string2);
        }
        if ("home".equals(string)) {
            return System.getProperty("netbeans.home").concat(string2);
        }
        if ("abs".equals(string)) {
            return string2;
        }
        int n = Integer.parseInt(string);
        Object[] objectArray = Stamps.dirs();
        if (n < 0 || n >= objectArray.length) {
            throw new IOException("Bad index " + n + " for " + Arrays.toString(objectArray));
        }
        return objectArray[n].concat(string2);
    }

    static void writeRelativePath(String string, DataOutput dataOutput) throws IOException {
        Stamps.produceRelativePath(string, dataOutput);
    }

    private static void produceRelativePath(String string, Object object) throws IOException {
        if (string.isEmpty()) {
            if (object instanceof DataOutput) {
                DataOutput dataOutput = (DataOutput)object;
                dataOutput.writeUTF(string);
            }
            return;
        }
        if (Stamps.testWritePath(string, System.getProperty("netbeans.user"), "user", object)) {
            return;
        }
        int n = 0;
        for (String string2 : Stamps.dirs()) {
            if (Stamps.testWritePath(string, string2, "" + n, object)) {
                return;
            }
            ++n;
        }
        if (Stamps.testWritePath(string, System.getProperty("netbeans.home"), "home", object)) {
            return;
        }
        LOG.log(Level.FINE, "Cannot find relative path for {0}", string);
        Stamps.doWritePath("abs", string, object);
    }

    private static boolean testWritePath(String string, String string2, String string3, Object object) throws IOException {
        if (string2 == null || string2.isEmpty()) {
            return false;
        }
        if (string.startsWith(string2)) {
            String string4 = string.substring(string2.length());
            Stamps.doWritePath(string3, string4, object);
            return true;
        }
        return false;
    }

    private static void doWritePath(String string, String string2, Object object) throws IOException {
        if (object instanceof DataOutput) {
            DataOutput dataOutput = (DataOutput)object;
            dataOutput.writeUTF(string);
            dataOutput.writeUTF(string2);
        } else {
            Collection collection = (Collection)object;
            collection.add(string);
            collection.add(string2);
        }
    }

    static String findRelativePath(String string) {
        ArrayList arrayList = new ArrayList();
        try {
            Stamps.produceRelativePath(string, arrayList);
        }
        catch (IOException iOException) {
            return string;
        }
        return (String)arrayList.get(1);
    }

    static {
        MODULES_JARS = new Stamps();
    }

    private final class Worker
    extends Thread {
        private final LinkedList<Store> storages;
        private final HashSet<String> processing;
        private AtomicInteger delay;
        private boolean noNotify;

        public Worker() {
            super("Flushing caches");
            this.storages = new LinkedList();
            this.processing = new HashSet();
            this.setPriority(1);
        }

        public synchronized void start(int n) {
            if (this.delay == null) {
                this.delay = new AtomicInteger(n);
                super.start();
            }
        }

        public synchronized boolean addStorage(Store store) {
            boolean bl = true;
            this.processing.add(store.cache);
            Iterator iterator = this.storages.iterator();
            while (iterator.hasNext()) {
                Store store2 = (Store)iterator.next();
                if (!store2.equals(store)) continue;
                iterator.remove();
                bl = false;
            }
            this.storages.add(store);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n;
            for (int i = n = this.delay.get(); i >= 0; i -= 500) {
                try {
                    Worker worker = this;
                    synchronized (worker) {
                        this.wait(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.INFO, null, interruptedException);
                }
                if (n != this.delay.get()) break;
            }
            if (n > 512) {
                this.delay.compareAndSet(n, 512);
            }
            long l = System.currentTimeMillis();
            LOG.log(Level.FINE, "Storing caches {0}", this.storages);
            HashSet<Store> hashSet = new HashSet<Store>();
            while (true) {
                Store store;
                Worker worker = this;
                synchronized (worker) {
                    store = this.storages.poll();
                    if (store == null) {
                        Stamps.this.worker = new Worker();
                        break;
                    }
                }
                if (!store.store(this.delay)) continue;
                hashSet.add(store);
            }
            long l2 = System.currentTimeMillis() - l;
            LOG.log(Level.FINE, "Done storing caches {0}", hashSet);
            LOG.log(Level.FINE, "Took {0} ms", l2);
            this.processing.clear();
            for (Store store : hashSet) {
                if (this.noNotify) continue;
                store.updater.cacheReady();
            }
            LOG.log(Level.FINE, "Notified ready {0}", hashSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitFor(boolean bl) {
            try {
                this.noNotify = bl;
                this.delay.set(0);
                Worker worker = this;
                synchronized (worker) {
                    this.notifyAll();
                }
                this.join();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }

        private boolean isProcessing(String string) {
            return this.processing.contains(string);
        }
    }

    private static final class Store
    extends OutputStream {
        final Updater updater;
        final String cache;
        final boolean append;
        OutputStream os;
        AtomicInteger delay;
        int count;

        public Store(Updater updater, String string, boolean bl) {
            this.updater = updater;
            this.cache = string;
            this.append = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean store(AtomicInteger atomicInteger) {
            assert (this.os == null);
            File file = Places.getCacheDirectory();
            if (!file.isDirectory()) {
                LOG.log(Level.WARNING, "Nonexistent cache directory: {0}", file);
                return false;
            }
            File file2 = new File(file, this.cache);
            boolean bl = false;
            try {
                LOG.log(Level.FINE, "Cleaning cache {0}", file2);
                if (!this.append) {
                    Stamps.deleteCache(file2);
                }
                file2.getParentFile().mkdirs();
                LOG.log(Level.FINE, "Storing cache {0}", file2);
                this.os = new FileOutputStream(file2, this.append);
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this, 0x100000));
                this.delay = atomicInteger;
                this.updater.flushCaches(dataOutputStream);
                dataOutputStream.close();
                LOG.log(Level.FINE, "Done Storing cache {0}", file2);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Error saving cache {0}", file2);
                LOG.log(Level.INFO, iOException.getMessage(), iOException);
                bl = true;
            }
            finally {
                if (this.os != null) {
                    try {
                        this.os.close();
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.WARNING, "Error closing stream for " + file2, iOException);
                    }
                    this.os = null;
                }
                if (bl) {
                    file2.delete();
                    file2.deleteOnExit();
                } else {
                    file2.setLastModified(Stamps.moduleJARs());
                }
            }
            return !bl;
        }

        @Override
        public void close() throws IOException {
            this.os.close();
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void write(int n) throws IOException {
            this.os.write(n);
            this.count(1);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.os.write(byArray);
            this.count(byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.os.write(byArray, n, n2);
            this.count(n2);
        }

        private void count(int n) {
            this.count += n;
            if (this.count > 65536) {
                int n2 = this.delay.get();
                if (n2 > 0) {
                    try {
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                }
                this.count = 0;
            }
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Store store = (Store)object;
            if (!this.updater.equals(store.updater)) {
                return false;
            }
            return this.cache.equals(store.cache);
        }

        public int hashCode() {
            int n = 7;
            n = 19 * n + (this.updater != null ? this.updater.hashCode() : 0);
            n = 19 * n + (this.cache != null ? this.cache.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.cache;
        }
    }

    public static interface Updater {
        public void flushCaches(DataOutputStream var1) throws IOException;

        public void cacheReady();
    }
}

