/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.notifications;

import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.InformationProvider;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.NotificationsModel;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.management.JMException;
import javax.management.MBeanNotificationInfo;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

class NotificationInfoSectionPart
extends MCClientSectionPart {
    private final IConnectionHandle m_connectionHandle;
    private NotificationsModel m_model;
    private Observer m_observer;
    private TreeColumnComposite m_tree;
    private Button m_subscribeButton;

    public NotificationInfoSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, IConnectionHandle connectionHandle) {
        super(parent, toolkit, style, sectionIdentifier);
        this.m_connectionHandle = connectionHandle;
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) throws Exception {
        Composite container = this.getFormToolkit().createComposite(section);
        container.setLayout((Layout)new GridLayout(2, false));
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)MBeanBrowserPlugin.getDefault().getMCDialogSettings(), (String)"notificationInfoSectionPart");
        this.m_tree = new TreeColumnComposite(container, 0, settings);
        this.m_tree.addColumns(new IColumn[]{new Column("", "", "", new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MBeanNotificationInfo) {
                    MBeanNotificationInfo info = (MBeanNotificationInfo)element;
                    return String.format("%s [%s]", info.getDescription(), info.getName());
                }
                return super.getText(element);
            }
        })});
        this.m_tree.getViewer().setContentProvider((IContentProvider)new InformationProvider());
        this.m_tree.getViewer().setAutoExpandLevel(-1);
        this.m_tree.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonContainer = this.getFormToolkit().createComposite(container);
        buttonContainer.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        Button button = this.createSubscribeButton(this.getManagedForm(), this.getManagedForm().getToolkit(), buttonContainer);
        button.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        buttonContainer.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        buttonContainer.setLayoutData((Object)new GridData(4, 4, false, true));
        return container;
    }

    private Button createSubscribeButton(IManagedForm form, FormToolkit toolkit, Composite parent) {
        this.m_subscribeButton = toolkit.createButton(parent, Messages.NotificationInfoSectionPart_SUBSCRIBE_BUTTON_TEXT, 32);
        this.m_subscribeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String errorTitle = Messages.NotificationInfoSectionPart_ERROR_REMOVING_JMX_SUBSCRIPTION_TEXT;
                if (!NotificationInfoSectionPart.this.m_model.getSubscriptionEnabled()) {
                    errorTitle = Messages.NotificationInfoSectionPart_ERROR_ENABLE_JMX_SUBSCRIPTION_TEXT;
                }
                try {
                    NotificationInfoSectionPart.this.m_model.setSubscriptionEnabled(!NotificationInfoSectionPart.this.m_model.getSubscriptionEnabled());
                }
                catch (IOException e1) {
                    this.handleException(errorTitle, e1);
                }
                catch (JMException e1) {
                    this.handleException(errorTitle, e1);
                }
            }

            private void handleException(String errorTitle, Exception e) {
                if (NotificationInfoSectionPart.this.m_connectionHandle.isConnected()) {
                    DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)errorTitle, (String)e.getMessage(), (Throwable)e);
                } else {
                    NotificationInfoSectionPart.this.m_subscribeButton.setSelection(false);
                    NotificationInfoSectionPart.this.m_subscribeButton.setEnabled(false);
                }
            }
        });
        this.m_observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DisplayToolkit.safeAsyncExec((Widget)NotificationInfoSectionPart.this.getSection(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NotificationInfoSectionPart.this.m_subscribeButton.setSelection(NotificationInfoSectionPart.this.m_model.getSubscriptionEnabled());
                        NotificationInfoSectionPart.this.m_subscribeButton.setEnabled(NotificationInfoSectionPart.this.m_model.supportsSubscriptions());
                        NotificationInfoSectionPart.this.m_tree.getViewer().refresh();
                    }
                });
            }
        };
        return this.m_subscribeButton;
    }

    public void setModel(NotificationsModel model) {
        this.removeObserver();
        this.m_model = model;
        this.m_model.addObserver(this.m_observer);
        this.m_tree.getViewer().setInput((Object)model);
        this.m_observer.update(null, null);
    }

    public void clearModel() {
        this.removeObserver();
        this.m_model = null;
        this.m_tree.getViewer().setInput(null);
        this.m_subscribeButton.setSelection(false);
        this.m_subscribeButton.setEnabled(false);
    }

    private void removeObserver() {
        if (this.m_model != null) {
            this.m_model.deleteObserver(this.m_observer);
        }
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.NotificationInfoSectionPart_NOTICATION_INFORMATION_TITLE_TEXT);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void dispose() {
        this.removeObserver();
        if (this.m_model != null) {
            this.m_model.dispose();
        }
    }
}

