/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.notifications;

import com.jrockit.mc.console.ui.mbeanbrowser.notifications.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.NotificationsModel;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.ui.attributes.AttributeTreeBuilder;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.rjmx.util.internal.DefaultAttribute;
import com.jrockit.mc.rjmx.util.internal.SimpleAttributeInfo;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.management.Notification;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;

public class MBeanNotificationLogInspector {
    private final Observer m_observer;
    private NotificationsModel m_model;
    private List<NotificationValue> m_values;
    private final TreeColumnComposite m_inspector;

    public MBeanNotificationLogInspector(Composite parent, IDialogSettings settings) {
        this.m_inspector = AttributeTreeBuilder.buildDefault((Composite)parent, (IDialogSettings)settings);
        this.m_observer = this.createObserver();
        this.m_inspector.getViewer().getTree().setData("name", (Object)"mbeanbrowser.notificationsTab.LogInspectorTree");
    }

    public TreeColumnComposite getControl() {
        return this.m_inspector;
    }

    private Observer createObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (arg instanceof Notification) {
                    MBeanNotificationLogInspector.this.addAndShowNotification((Notification)arg);
                }
            }
        };
    }

    private void addAndShowNotification(Notification notification) {
        this.m_values.add(new NotificationValue(notification));
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MBeanNotificationLogInspector.this.m_inspector.isDisposed()) {
                    MBeanNotificationLogInspector.this.m_inspector.getViewer().refresh();
                }
            }
        });
    }

    private void removeObserver() {
        if (this.m_model != null) {
            this.m_model.deleteObserver(this.m_observer);
        }
    }

    public void setModel(NotificationsModel model) {
        this.removeObserver();
        this.m_model = model;
        this.m_model.addObserver(this.m_observer);
        this.m_values = this.createAttributes();
        this.m_inspector.getViewer().setInput(this.m_values);
        this.m_inspector.getViewer().refresh();
        this.m_observer.update(null, null);
    }

    public void clearModel() {
        this.removeObserver();
        this.m_model = null;
        this.m_inspector.getViewer().setInput(null);
    }

    private List<NotificationValue> createAttributes() {
        ArrayList<NotificationValue> notifications = new ArrayList<NotificationValue>();
        for (Notification notification : this.m_model.getNotifications()) {
            notifications.add(new NotificationValue(notification));
        }
        return notifications;
    }

    private static class NotificationValue
    extends DefaultAttribute {
        private static final DateFormat DATE_FORMAT;
        private static final String SECOND_FORMATTING = "ss";
        private static final String MILLIS_FORMATTING = ".SSS";
        private final Notification m_notification;
        private Collection<Object> m_children;

        static {
            DateFormat defaultFormat = DateFormat.getDateTimeInstance(3, 2);
            if (defaultFormat instanceof SimpleDateFormat) {
                SimpleDateFormat format = (SimpleDateFormat)defaultFormat;
                String pattern = format.toPattern();
                int index = pattern.indexOf(SECOND_FORMATTING);
                defaultFormat = index >= 0 ? new SimpleDateFormat(pattern.replace(SECOND_FORMATTING, "ss.SSS")) : new SimpleDateFormat(String.valueOf(pattern) + MILLIS_FORMATTING);
            }
            DATE_FORMAT = defaultFormat;
        }

        public NotificationValue(Notification notification) {
            super(NotificationValue.createAttributeInfo(notification));
            this.m_notification = notification;
        }

        private static synchronized IAttributeInfo createAttributeInfo(Notification notification) {
            return new SimpleAttributeInfo(DATE_FORMAT.format(new Date(notification.getTimeStamp())), notification.getType());
        }

        public Object getValue() {
            return this.m_notification.getMessage();
        }

        public boolean hasChildren() {
            return true;
        }

        public Collection<Object> getChildren() {
            if (this.m_children == null) {
                this.m_children = new ArrayList<Object>();
                this.m_children.add(new DefaultAttribute(Messages.MBeanNotificationLogInspector_TIME_STAMP_LABEL, (Object)this.m_notification.getTimeStamp()));
                this.m_children.add(new DefaultAttribute(Messages.MBeanNotificationLogInspector_TYPE_LABEL, (Object)this.m_notification.getType()));
                this.m_children.add(new DefaultAttribute(Messages.MBeanNotificationLogInspector_SEQUENCE_NUMBER_LABEL, (Object)this.m_notification.getSequenceNumber()));
                this.m_children.add(new DefaultAttribute(Messages.MBeanNotificationLogInspector_MESSAGE_LABEL, (Object)this.m_notification.getMessage()));
                this.m_children.add(new DefaultAttribute(Messages.MBeanNotificationLogInspector_USER_DATA_LABEL, this.m_notification.getUserData()));
            }
            return this.m_children;
        }

        public int hashCode() {
            return this.m_notification.hashCode();
        }

        public boolean equals(Object that) {
            return that instanceof NotificationValue && this.m_notification.equals(((NotificationValue)((Object)that)).m_notification);
        }
    }
}

