/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.jdp;

import com.jrockit.mc.browser.jdp.JDPPlugin;
import com.jrockit.mc.browser.jdp.Messages;
import com.jrockit.mc.common.jvm.Connectable;
import com.jrockit.mc.common.jvm.JVMArch;
import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.common.jvm.JVMType;
import com.jrockit.mc.jdp.client.DiscoveryEvent;
import com.jrockit.mc.jdp.client.DiscoveryListener;
import com.jrockit.mc.jdp.client.JDPClient;
import com.jrockit.mc.rjmx.IServerDescriptor;
import com.jrockit.mc.rjmx.ServerDescriptor;
import com.jrockit.mc.rjmx.descriptorprovider.AbstractDescriptorProvider;
import com.jrockit.mc.rjmx.descriptorprovider.IDescriptorListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JDPDescriptorProvider
extends AbstractDescriptorProvider
implements IPropertyChangeListener {
    private JDPClient jdpClient;
    private final JDPDiscoveryListener discoveryListener = new JDPDiscoveryListener();

    public JDPDescriptorProvider() {
        JDPPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public String getName() {
        return Messages.JDPDescriptorProvider_PROVIDER_NAME;
    }

    public String getDescription() {
        return Messages.JDPDescriptorProvider_PROVIDER_DESCRIPTION;
    }

    private synchronized void startClient() {
        this.getJDPClient().addDiscoveryListener((DiscoveryListener)this.discoveryListener);
        try {
            this.getJDPClient().start();
        }
        catch (IOException e) {
            JDPPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not start the JDP client.", e);
        }
    }

    private synchronized void shutDownClient() {
        this.getJDPClient().removeDiscoveryListener((DiscoveryListener)this.discoveryListener);
        this.getJDPClient().stop();
        this.jdpClient = null;
    }

    private synchronized JDPClient getJDPClient() {
        if (this.jdpClient == null) {
            this.jdpClient = new JDPClient(this.getAddress(), this.getPort(), this.getHeartBeatTimeout() * 1000);
        }
        return this.jdpClient;
    }

    private int getHeartBeatTimeout() {
        return JDPPlugin.getDefault().getPreferenceStore().getInt("com.jrockit.mc.jdp.hbtimeout");
    }

    private int getPort() {
        return JDPPlugin.getDefault().getPreferenceStore().getInt("com.jrockit.mc.jdp.port");
    }

    private InetAddress getAddress() {
        String address = JDPPlugin.getDefault().getPreferenceStore().getString("com.jrockit.mc.jdp.address");
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            JDPPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not resolve address for JDP! The JDP client will most likely fail.", e);
            return null;
        }
    }

    public void removeDescriptorListener(IDescriptorListener l) {
        super.removeDescriptorListener(l);
        this.m_descriptorListeners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            if (this.m_descriptorListeners.size() == 0) {
                super.addDescriptorListener(l);
                this.startClient();
                return;
            }
            super.addDescriptorListener(l);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.restartJDPClient();
    }

    private synchronized void restartJDPClient() {
        this.shutDownClient();
        this.startClient();
    }

    private class JDPDiscoveryListener
    implements DiscoveryListener {
        private static final String PATH_SEPARATOR = "/";

        private JDPDiscoveryListener() {
        }

        public void onDiscovery(DiscoveryEvent event) {
            switch (event.getKind()) {
                case LOST: {
                    JDPDescriptorProvider.this.onDescriptorRemoved(event.getDiscoverable().getSessionId());
                    break;
                }
                default: {
                    Map map = event.getDiscoverable().getPayload();
                    String name = (String)map.get("INSTANCE_NAME");
                    String url = (String)map.get("JMX_SERVICE_URL");
                    String commandLine = (String)map.get("MAIN_CLASS");
                    String pid = (String)map.get("PROCESS_ID");
                    JVMDescriptor jvmInfo = new JVMDescriptor(null, JVMType.UNKNOWN, JVMArch.UNKNOWN, commandLine, pid == null ? null : Integer.valueOf(Integer.parseInt(pid)), false, Connectable.MGMNT_AGENT_STARTED);
                    String path = null;
                    if (name != null) {
                        if (name.endsWith(PATH_SEPARATOR)) {
                            path = name;
                            name = null;
                        } else {
                            int index = name.lastIndexOf(47);
                            if (index != -1) {
                                path = name.substring(0, index);
                                name = name.substring(index + 1);
                            }
                        }
                    }
                    ServerDescriptor sd = new ServerDescriptor(event.getDiscoverable().getSessionId(), name, jvmInfo);
                    try {
                        JDPDescriptorProvider.this.onDescriptorDetected((IServerDescriptor)sd, path, new JMXServiceURL(url), null);
                        break;
                    }
                    catch (Exception e) {
                        JDPPlugin.getDefault().getLogger().log(Level.SEVERE, "Got broken event from JDP: " + url, e);
                    }
                }
            }
        }
    }
}

