/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.GroupByNode;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.OptimizerImpl;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VerifyAggregateExpressionsVisitor;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowFunctionNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;
import org.apache.derby.impl.sql.compile.WindowResultSetNode;

public class SelectNode
extends ResultSetNode {
    FromList fromList;
    FromTable targetTable;
    Vector selectAggregates;
    Vector whereAggregates;
    Vector havingAggregates;
    ValueNode whereClause;
    ValueNode originalWhereClause;
    GroupByList groupByList;
    WindowList windows;
    Vector windowFuncCalls;
    private boolean wasGroupBy;
    OrderByList orderByList;
    boolean orderByQuery;
    ValueNode offset;
    ValueNode fetchFirst;
    PredicateList wherePredicates;
    SubqueryList selectSubquerys;
    SubqueryList whereSubquerys;
    SubqueryList havingSubquerys;
    private boolean bindTargetListOnly;
    private boolean isDistinct;
    private boolean orderByAndDistinctMerged;
    boolean originalWhereClauseHadSubqueries;
    private FromList preJoinFL;
    ValueNode havingClause;
    private int nestingLevel;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws StandardException {
        CollectNodesVisitor collectNodesVisitor;
        this.resultColumns = (ResultColumnList)object;
        if (this.resultColumns != null) {
            this.resultColumns.markInitialSize();
        }
        this.fromList = (FromList)object3;
        this.whereClause = (ValueNode)object4;
        this.originalWhereClause = (ValueNode)object4;
        this.groupByList = (GroupByList)object5;
        this.havingClause = (ValueNode)object6;
        this.windows = (WindowList)object7;
        this.bindTargetListOnly = false;
        this.originalWhereClauseHadSubqueries = false;
        if (this.whereClause != null) {
            collectNodesVisitor = new CollectNodesVisitor(SubqueryNode.class, SubqueryNode.class);
            this.whereClause.accept(collectNodesVisitor);
            if (!collectNodesVisitor.getList().isEmpty()) {
                this.originalWhereClauseHadSubqueries = true;
            }
        }
        if (this.resultColumns != null) {
            collectNodesVisitor = new CollectNodesVisitor(WindowFunctionNode.class, SelectNode.class);
            this.resultColumns.accept(collectNodesVisitor);
            this.windowFuncCalls = collectNodesVisitor.getList();
            for (int i = 0; i < this.windowFuncCalls.size(); ++i) {
                WindowFunctionNode windowFunctionNode = (WindowFunctionNode)this.windowFuncCalls.elementAt(i);
                if (!(windowFunctionNode.getWindow() instanceof WindowDefinitionNode)) continue;
                this.windows = this.addInlinedWindowDefinition(this.windows, windowFunctionNode);
            }
        }
    }

    private WindowList addInlinedWindowDefinition(WindowList windowList, WindowFunctionNode windowFunctionNode) {
        WindowDefinitionNode windowDefinitionNode;
        WindowDefinitionNode windowDefinitionNode2 = (WindowDefinitionNode)windowFunctionNode.getWindow();
        if (windowList == null) {
            windowList = new WindowList();
            windowList.setContextManager(this.getContextManager());
        }
        if ((windowDefinitionNode = windowDefinitionNode2.findEquivalentWindow(windowList)) != null) {
            windowFunctionNode.setWindow(windowDefinitionNode);
        } else {
            windowList.addWindow((WindowDefinitionNode)windowFunctionNode.getWindow());
        }
        return windowList;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "SELECT";
    }

    public void makeDistinct() {
        this.isDistinct = true;
    }

    public void clearDistinct() {
        this.isDistinct = false;
    }

    boolean hasDistinct() {
        return this.isDistinct;
    }

    public void printSubNodes(int n) {
    }

    public FromList getFromList() {
        return this.fromList;
    }

    public ColumnReference findColumnReferenceInResult(String string) throws StandardException {
        if (this.fromList.size() != 1) {
            return null;
        }
        FromTable fromTable = (FromTable)this.fromList.elementAt(0);
        if (!(fromTable instanceof ProjectRestrictNode && ((ProjectRestrictNode)fromTable).getChildResult() instanceof FromBaseTable || fromTable instanceof FromBaseTable)) {
            return null;
        }
        int n = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (!(resultColumn.getExpression() instanceof ColumnReference)) {
                return null;
            }
            ColumnReference columnReference = (ColumnReference)resultColumn.getExpression();
            if (!columnReference.columnName.equals(string)) continue;
            return (ColumnReference)columnReference.getClone();
        }
        return null;
    }

    public ValueNode getWhereClause() {
        return this.whereClause;
    }

    public PredicateList getWherePredicates() {
        return this.wherePredicates;
    }

    public SubqueryList getSelectSubquerys() {
        return this.selectSubquerys;
    }

    public SubqueryList getWhereSubquerys() {
        return this.whereSubquerys;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        int n;
        int n2 = this.fromList.size();
        this.wherePredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.preJoinFL = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.nestingLevel = fromList.size() == 0 ? 0 : ((FromTable)fromList.elementAt(0)).getLevel() + 1;
        this.fromList.setLevel(this.nestingLevel);
        for (n = 0; n < n2; ++n) {
            fromList.insertElementAt(this.fromList.elementAt(n), 0);
        }
        this.fromList.bindTables(dataDictionary, fromList);
        for (n = 0; n < n2; ++n) {
            fromList.removeElementAt(0);
        }
        return this;
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        int n;
        int n2;
        int n3 = fromList.size();
        int n4 = this.fromList.size();
        if (!this.bindTargetListOnly) {
            this.fromList.bindExpressions(fromList);
        }
        this.selectSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.selectAggregates = new Vector();
        for (n2 = 0; n2 < n4; ++n2) {
            fromList.insertElementAt(this.fromList.elementAt(n2), n2);
        }
        fromList.setWindows(this.windows);
        this.resultColumns.bindExpressions(fromList, this.selectSubquerys, this.selectAggregates);
        if (this.bindTargetListOnly) {
            for (n2 = 0; n2 < n4; ++n2) {
                fromList.removeElementAt(0);
            }
            return;
        }
        this.whereAggregates = new Vector();
        this.whereSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.whereClause != null) {
            compilerContext.pushCurrentPrivType(0);
            n = this.orReliability(16384);
            this.whereClause = this.whereClause.bindExpression(fromList, this.whereSubquerys, this.whereAggregates);
            compilerContext.setReliability(n);
            if (this.whereAggregates.size() > 0) {
                throw StandardException.newException("42903");
            }
            if (this.whereClause.isParameterNode()) {
                throw StandardException.newException("42X19", "PARAMETER");
            }
            this.whereClause = this.whereClause.checkIsBoolean();
            this.getCompilerContext().popCurrentPrivType();
            SelectNode.checkNoWindowFunctions(this.whereClause, "WHERE");
        }
        if (this.havingClause != null) {
            n = this.orReliability(16384);
            this.havingAggregates = new Vector();
            this.havingSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
            this.havingClause.bindExpression(fromList, this.havingSubquerys, this.havingAggregates);
            this.havingClause = this.havingClause.checkIsBoolean();
            SelectNode.checkNoWindowFunctions(this.havingClause, "HAVING");
            compilerContext.setReliability(n);
        }
        for (n = 0; n < n4; ++n) {
            fromList.removeElementAt(0);
        }
        if (this.groupByList != null) {
            Vector vector = new Vector();
            this.groupByList.bindGroupByColumns(this, vector);
            SelectNode.checkNoWindowFunctions(this.groupByList, "GROUP BY");
        }
        if (this.groupByList != null || this.selectAggregates.size() > 0) {
            VerifyAggregateExpressionsVisitor verifyAggregateExpressionsVisitor = new VerifyAggregateExpressionsVisitor(this.groupByList);
            this.resultColumns.accept(verifyAggregateExpressionsVisitor);
        }
        int n5 = SelectNode.numDistinctAggregates(this.selectAggregates);
        if (this.groupByList == null && n5 > 1) {
            throw StandardException.newException("42Z02");
        }
    }

    public void bindExpressionsWithTables(FromList fromList) throws StandardException {
        this.bindExpressions(fromList);
    }

    public void bindTargetExpressions(FromList fromList) throws StandardException {
        CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(FromSubquery.class, FromSubquery.class);
        this.fromList.accept(collectNodesVisitor);
        this.bindTargetListOnly = collectNodesVisitor.getList().isEmpty();
        this.bindExpressions(fromList);
        this.bindTargetListOnly = false;
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        this.fromList.bindResultColumns(fromList);
        super.bindResultColumns(fromList);
        if (this.resultColumns.size() > 1012) {
            throw StandardException.newException("54004");
        }
        if (this.resultColumns.size() == 0) {
            throw StandardException.newException("42X81");
        }
    }

    public void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        this.fromList.bindResultColumns(fromList);
        super.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
    }

    void pushExpressionsIntoSelect(Predicate predicate) throws StandardException {
        this.wherePredicates.pullExpressions(this.referencedTableMap.size(), predicate.getAndNode());
        this.fromList.pushPredicates(this.wherePredicates);
    }

    public void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
        if (!((ResultColumn)this.resultColumns.elementAt(0) instanceof AllResultColumn)) {
            return;
        }
        if (n != 15) {
            throw StandardException.newException("42X38");
        }
        String string = ((AllResultColumn)this.resultColumns.elementAt(0)).getFullTableName();
        if (string != null && this.fromList.getFromTableByName(string, null, true) == null && fromList.getFromTableByName(string, null, true) == null && this.fromList.getFromTableByName(string, null, false) == null && fromList.getFromTableByName(string, null, false) == null) {
            throw StandardException.newException("42X10", string);
        }
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.fromList.getFromTableByName(string, string2, bl);
    }

    public void rejectParameters() throws StandardException {
        super.rejectParameters();
        this.fromList.rejectParameters();
    }

    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
        this.orderByQuery = true;
    }

    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2) {
        this.offset = valueNode;
        this.fetchFirst = valueNode2;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        ResultSetNode resultSetNode = this;
        this.whereClause = this.normExpressions(this.whereClause);
        this.havingClause = this.normExpressions(this.havingClause);
        boolean bl = this.fromList.LOJ_reorderable(n);
        if (bl) {
            FromList fromList2 = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindExpressions(fromList2);
            this.fromList.bindResultColumns(fromList2);
        }
        this.fromList.preprocess(n, this.groupByList, this.whereClause);
        this.resultColumns.preprocess(n, this.fromList, this.whereSubquerys, this.wherePredicates);
        if (this.whereClause != null) {
            if (this.whereSubquerys != null) {
                this.whereSubquerys.markWhereSubqueries();
            }
            this.whereClause.preprocess(n, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.groupByList != null) {
            this.groupByList.preprocess(n, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.havingClause != null) {
            this.havingSubquerys.markHavingSubqueries();
            this.havingClause = this.havingClause.preprocess(n, this.fromList, this.havingSubquerys, this.wherePredicates);
        }
        if (this.whereClause != null) {
            this.wherePredicates.pullExpressions(n, this.whereClause);
            this.whereClause = null;
        }
        this.fromList.flattenFromTables(this.resultColumns, this.wherePredicates, this.whereSubquerys, this.groupByList, this.havingClause);
        if (this.wherePredicates != null && this.wherePredicates.size() > 0 && this.fromList.size() > 0) {
            if (this.fromList.size() > 1) {
                this.performTransitiveClosure(n);
            }
            if (this.orderByList != null) {
                this.orderByList.removeConstantColumns(this.wherePredicates);
                if (this.orderByList.size() == 0) {
                    this.orderByList = null;
                    this.resultColumns.removeOrderByColumns();
                }
            }
        }
        if (this.groupByList != null && this.havingClause == null && this.selectAggregates.size() == 0 && this.whereAggregates.size() == 0) {
            this.isDistinct = true;
            this.groupByList = null;
            this.wasGroupBy = true;
        }
        if (this.isDistinct && this.groupByList == null) {
            int n2 = this.resultColumns.allTopCRsFromSameTable();
            if (n2 != -1 && this.fromList.returnsAtMostSingleRow(this.resultColumns, this.whereClause, this.wherePredicates, this.getDataDictionary())) {
                this.isDistinct = false;
            }
            if (this.isDistinct && this.orderByList != null && this.orderByList.allAscending()) {
                if (this.orderByList.isInOrderPrefix(this.resultColumns)) {
                    this.orderByList = null;
                } else {
                    resultSetNode = this.genProjectRestrictForReordering();
                    this.orderByList.resetToSourceRCs();
                    this.resultColumns = this.orderByList.reorderRCL(this.resultColumns);
                    resultSetNode.getResultColumns().removeOrderByColumns();
                    this.orderByList = null;
                }
                this.orderByAndDistinctMerged = true;
            }
        }
        this.fromList.pushPredicates(this.wherePredicates);
        this.referencedTableMap = new JBitSet(n);
        int n3 = this.fromList.size();
        for (int i = 0; i < n3; ++i) {
            this.referencedTableMap.or(((FromTable)this.fromList.elementAt(i)).getReferencedTableMap());
        }
        if (resultSetNode != this) {
            resultSetNode.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
        }
        if (this.orderByList != null) {
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(WindowFunctionNode.class);
            this.orderByList.accept(collectNodesVisitor);
            Vector vector = collectNodesVisitor.getList();
            for (int i = 0; i < vector.size(); ++i) {
                WindowFunctionNode windowFunctionNode = (WindowFunctionNode)vector.elementAt(i);
                this.windowFuncCalls.add(windowFunctionNode);
                if (!(windowFunctionNode.getWindow() instanceof WindowDefinitionNode)) continue;
                this.windows = this.addInlinedWindowDefinition(this.windows, windowFunctionNode);
            }
        }
        return resultSetNode;
    }

    private void performTransitiveClosure(int n) throws StandardException {
        this.wherePredicates.joinClauseTransitiveClosure(n, this.fromList, this.getCompilerContext());
        this.wherePredicates.searchClauseTransitiveClosure(n, this.fromList.hashJoinSpecified());
    }

    private ValueNode normExpressions(ValueNode valueNode) throws StandardException {
        if (valueNode != null) {
            valueNode = valueNode.eliminateNots(false);
            valueNode = valueNode.putAndsOnTop();
            valueNode = valueNode.changeToCNF(true);
        }
        return valueNode;
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.wherePredicates.addPredicate(predicate);
        return this;
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        if (this.isDistinct) {
            return false;
        }
        if (this.fromList.size() > 1) {
            return false;
        }
        if (this.selectSubquerys != null && this.selectSubquerys.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        if (!this.resultColumns.isCloneable()) {
            return false;
        }
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            return false;
        }
        if (this.orderByList != null && this.orderByList.size() > 0) {
            return false;
        }
        return this.offset == null && this.fetchFirst == null;
    }

    public ResultSetNode genProjectRestrict(int n) throws StandardException {
        Object object;
        SingleChildResultSetNode singleChildResultSetNode;
        Object object2;
        boolean bl = false;
        ResultSetNode resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(151, this.fromList.elementAt(0), this.resultColumns, this.whereClause, this.wherePredicates, this.selectSubquerys, this.whereSubquerys, null, this.getContextManager());
        if (this.selectAggregates != null && this.selectAggregates.size() > 0 || this.groupByList != null) {
            object2 = this.selectAggregates;
            if (this.havingAggregates != null && !this.havingAggregates.isEmpty()) {
                this.havingAggregates.addAll(this.selectAggregates);
                object2 = this.havingAggregates;
            }
            singleChildResultSetNode = (GroupByNode)this.getNodeFactory().getNode(137, resultSetNode, this.groupByList, object2, this.havingClause, this.havingSubquerys, null, new Integer(this.nestingLevel), this.getContextManager());
            ((GroupByNode)singleChildResultSetNode).considerPostOptimizeOptimizations(this.originalWhereClause != null);
            singleChildResultSetNode.assignCostEstimate(this.optimizer.getOptimizedCost());
            this.groupByList = null;
            resultSetNode = ((GroupByNode)singleChildResultSetNode).getParent();
            boolean bl2 = bl = bl || ((GroupByNode)singleChildResultSetNode).getIsInSortedOrder();
        }
        if (this.windows != null) {
            if (this.windows.size() > 1) {
                throw StandardException.newException("42ZC1");
            }
            object2 = (WindowNode)this.windows.elementAt(0);
            singleChildResultSetNode = (WindowResultSetNode)this.getNodeFactory().getNode(230, resultSetNode, object2, this.windowFuncCalls, new Integer(this.nestingLevel), this.getContextManager());
            resultSetNode = ((WindowResultSetNode)singleChildResultSetNode).getParent();
            singleChildResultSetNode.assignCostEstimate(this.optimizer.getOptimizedCost());
        }
        if (this.isDistinct) {
            this.resultColumns.verifyAllOrderable();
            boolean bl3 = false;
            if (n == 1 && !this.orderByAndDistinctMerged) {
                boolean bl4 = true;
                object = new HashSet();
                int n2 = this.resultColumns.size();
                for (int i = 1; i <= n2; ++i) {
                    BaseColumnNode baseColumnNode = this.resultColumns.getResultColumn(i).getBaseColumnNode();
                    if (baseColumnNode == null) {
                        bl4 = false;
                        break;
                    }
                    ((HashSet)object).add(baseColumnNode);
                }
                if (bl4 && resultSetNode.isPossibleDistinctScan((Set)object)) {
                    resultSetNode.markForDistinctScan();
                    bl3 = true;
                }
            }
            if (!bl3) {
                boolean bl5 = this.isOrderedResult(this.resultColumns, resultSetNode, !this.orderByAndDistinctMerged);
                resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(124, resultSetNode, new Boolean(bl5), null, this.getContextManager());
                resultSetNode.costEstimate = this.costEstimate.cloneMe();
                boolean bl6 = bl = bl || bl5;
            }
        }
        if (this.orderByList != null) {
            int n3;
            if (this.orderByList.getSortNeeded()) {
                resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(140, resultSetNode, this.orderByList, null, this.getContextManager());
                resultSetNode.costEstimate = this.costEstimate.cloneMe();
            }
            if ((n3 = this.getResultColumns().getOrderBySelect()) > 0) {
                ResultColumnList resultColumnList = resultSetNode.getResultColumns();
                object = resultColumnList.copyListAndObjects();
                resultSetNode.setResultColumns((ResultColumnList)object);
                resultColumnList.removeOrderByColumns();
                resultColumnList.genVirtualColumnNodes(resultSetNode, (ResultColumnList)object);
                resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(151, resultSetNode, resultColumnList, null, null, null, null, null, this.getContextManager());
            }
        }
        if (this.offset != null || this.fetchFirst != null) {
            ResultColumnList resultColumnList = resultSetNode.getResultColumns();
            ResultColumnList resultColumnList2 = resultColumnList.copyListAndObjects();
            resultSetNode.setResultColumns(resultColumnList2);
            resultColumnList.genVirtualColumnNodes(resultSetNode, resultColumnList2);
            resultSetNode = (RowCountNode)this.getNodeFactory().getNode(223, resultSetNode, resultColumnList, this.offset, this.fetchFirst, this.getContextManager());
        }
        if (this.wasGroupBy && this.resultColumns.numGeneratedColumnsForGroupBy() > 0 && this.windows == null) {
            ResultColumnList resultColumnList = resultSetNode.getResultColumns();
            ResultColumnList resultColumnList3 = resultColumnList.copyListAndObjects();
            resultSetNode.setResultColumns(resultColumnList3);
            resultColumnList.removeGeneratedGroupingColumns();
            resultColumnList.genVirtualColumnNodes(resultSetNode, resultColumnList3);
            resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(151, resultSetNode, resultColumnList, null, null, null, null, null, this.getContextManager());
        }
        if ((this.orderByList == null || !this.orderByList.getSortNeeded()) && this.orderByQuery) {
            bl = true;
        }
        if (bl) {
            resultSetNode.adjustForSortElimination(this.orderByList);
        }
        resultSetNode.costEstimate = this.costEstimate.cloneMe();
        return resultSetNode;
    }

    private boolean isOrderedResult(ResultColumnList resultColumnList, ResultSetNode resultSetNode, boolean bl) throws StandardException {
        int n = resultColumnList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (resultColumn.getExpression() instanceof ColumnReference) {
                ++n2;
                continue;
            }
            if (resultColumn.getExpression() instanceof ConstantNode) continue;
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        ColumnReference[] columnReferenceArray = new ColumnReference[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (!(resultColumn.getExpression() instanceof ColumnReference)) continue;
            columnReferenceArray[n3++] = (ColumnReference)resultColumn.getExpression();
        }
        return resultSetNode.isOrderedOn(columnReferenceArray, bl, null);
    }

    public ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        int n;
        if (this.wherePredicates != null) {
            for (int i = this.wherePredicates.size() - 1; i >= 0; --i) {
                if (!((Predicate)this.wherePredicates.elementAt(i)).isScopedForPush()) continue;
                this.wherePredicates.removeOptPredicate(i);
            }
        }
        if (predicateList != null) {
            if (this.wherePredicates == null) {
                this.wherePredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            }
            Predicate predicate = null;
            n = predicateList.size();
            for (int i = n - 1; i >= 0; --i) {
                predicate = (Predicate)predicateList.getOptPredicate(i);
                if (!predicate.isScopedToSourceResultSet()) continue;
                this.wherePredicates.addOptPredicate(predicate);
                predicateList.removeOptPredicate(predicate);
            }
        }
        Optimizer optimizer = this.getOptimizer(this.fromList, this.wherePredicates, dataDictionary, this.orderByList);
        optimizer.setOuterRows(d);
        while (optimizer.getNextPermutation()) {
            while (optimizer.getNextDecoratedPermutation()) {
                optimizer.costPermutation();
            }
        }
        if (this.wherePredicates != null) {
            Predicate predicate = null;
            for (n = this.wherePredicates.size() - 1; n >= 0; --n) {
                predicate = (Predicate)this.wherePredicates.getOptPredicate(n);
                if (!predicate.isScopedForPush()) continue;
                predicateList.addOptPredicate(predicate);
                this.wherePredicates.removeOptPredicate(predicate);
            }
        }
        this.costEstimate = optimizer.getOptimizedCost();
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            this.costEstimate.setEstimatedRowCount((long)d);
            this.costEstimate.setSingleScanRowCount(1.0);
        }
        this.selectSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        }
        return this;
    }

    public ResultSetNode modifyAccessPaths(PredicateList predicateList) throws StandardException {
        ((OptimizerImpl)this.optimizer).addScopedPredicatesToList(predicateList);
        return this.modifyAccessPaths();
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        int n = this.fromList.size();
        this.optimizer.modifyAccessPaths();
        this.costEstimate = this.optimizer.getFinalCost();
        this.selectSubquerys.modifyAccessPaths();
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.modifyAccessPaths();
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.modifyAccessPaths();
        }
        this.preJoinFL.removeAllElements();
        this.preJoinFL.nondestructiveAppend(this.fromList);
        while (this.fromList.size() > 1) {
            ResultSetNode resultSetNode = (ResultSetNode)this.fromList.elementAt(0);
            ResultColumnList resultColumnList = resultSetNode.getResultColumns();
            resultSetNode.setResultColumns(resultColumnList.copyListAndObjects());
            resultColumnList.genVirtualColumnNodes(resultSetNode, resultSetNode.resultColumns);
            ResultSetNode resultSetNode2 = (ResultSetNode)this.fromList.elementAt(1);
            ResultColumnList resultColumnList2 = resultSetNode2.getResultColumns();
            resultSetNode2.setResultColumns(resultColumnList2.copyListAndObjects());
            resultColumnList2.genVirtualColumnNodes(resultSetNode2, resultSetNode2.resultColumns);
            resultColumnList2.adjustVirtualColumnIds(resultColumnList.size());
            resultColumnList.nondestructiveAppend(resultColumnList2);
            this.fromList.setElementAt((JoinNode)this.getNodeFactory().getNode(139, resultSetNode, resultSetNode2, null, null, resultColumnList, null, this.fromList.properties, this.getContextManager()), 0);
            this.fromList.removeElementAt(1);
        }
        return this.genProjectRestrict(n);
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        return this.optimizer.getFinalCost();
    }

    boolean isUpdatableCursor(DataDictionary dataDictionary) throws StandardException {
        if (this.isDistinct) {
            return false;
        }
        if (this.selectAggregates == null || this.selectAggregates.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        if (this.fromList.size() != 1) {
            return false;
        }
        this.targetTable = (FromTable)this.fromList.elementAt(0);
        if (this.targetTable instanceof FromVTI) {
            return ((FromVTI)this.targetTable).isUpdatableCursor();
        }
        if (!(this.targetTable instanceof FromBaseTable)) {
            return false;
        }
        TableDescriptor tableDescriptor = this.getTableDescriptor(((FromBaseTable)this.targetTable).getBaseTableName(), this.getSchemaDescriptor(((FromBaseTable)this.targetTable).getTableNameField().getSchemaName()));
        if (tableDescriptor.getTableType() == 1) {
            return false;
        }
        if (tableDescriptor.getTableType() == 2) {
            return false;
        }
        if (this.getSelectSubquerys() != null && this.getSelectSubquerys().size() != 0) {
            return false;
        }
        return this.getWhereSubquerys() == null || this.getWhereSubquerys().size() == 0;
    }

    FromTable getCursorTargetTable() {
        return this.targetTable;
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.fromList.referencesTarget(string, bl) || this.selectSubquerys != null && this.selectSubquerys.referencesTarget(string, bl) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(string, bl);
    }

    boolean subqueryReferencesTarget(String string, boolean bl) throws StandardException {
        return this.selectSubquerys != null && this.selectSubquerys.referencesTarget(string, bl) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(string, bl);
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        this.fromList.bindUntypedNullsToResultColumns(resultColumnList);
    }

    void decrementLevel(int n) {
        this.fromList.decrementLevel(n);
        this.selectSubquerys.decrementLevel(n);
        this.whereSubquerys.decrementLevel(n);
        this.wherePredicates.decrementLevel(this.fromList, n);
    }

    boolean uniqueSubquery(boolean bl) throws StandardException {
        ColumnReference columnReference = null;
        ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(0);
        if (bl && resultColumn.getExpression() instanceof ColumnReference && (columnReference = (ColumnReference)resultColumn.getExpression()).getCorrelated()) {
            columnReference = null;
        }
        return this.fromList.returnsAtMostSingleRow(columnReference == null ? null : this.getResultColumns(), this.whereClause, this.wherePredicates, this.getDataDictionary());
    }

    public int updateTargetLockMode() {
        return this.fromList.updateTargetLockMode();
    }

    boolean returnsAtMostOneRow() {
        return this.groupByList == null && this.selectAggregates != null && this.selectAggregates.size() != 0;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.fromList.referencesSessionSchema() || this.selectSubquerys != null && this.selectSubquerys.referencesSessionSchema() || this.whereSubquerys != null && this.whereSubquerys.referencesSessionSchema();
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.fromList != null) {
            this.fromList = (FromList)this.fromList.accept(visitor);
        }
        if (this.whereClause != null) {
            this.whereClause = (ValueNode)this.whereClause.accept(visitor);
        }
        if (this.wherePredicates != null) {
            this.wherePredicates = (PredicateList)this.wherePredicates.accept(visitor);
        }
        if (this.havingClause != null) {
            this.havingClause = (ValueNode)this.havingClause.accept(visitor);
        }
    }

    public boolean hasAggregatesInSelectList() {
        return !this.selectAggregates.isEmpty();
    }

    public boolean hasWindows() {
        return this.windows != null;
    }

    public static void checkNoWindowFunctions(QueryTreeNode queryTreeNode, String string) throws StandardException {
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(WindowFunctionNode.class, SubqueryNode.class);
        queryTreeNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42ZC2", string);
        }
    }

    void replaceOrForbidDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, boolean bl) throws StandardException {
    }
}

