/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.PrintDetailsTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.ui.AbstractSearchResultsPanel;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class BasicAbstractResultsPanel
extends AbstractSearchResultsPanel {
    private static final String SHOW_DETAILS_ICON = "org/netbeans/modules/search/res/search.gif";
    private static final String FOLDER_VIEW_ICON = "org/netbeans/modules/search/res/logical_view.png";
    private static final String FLAT_VIEW_ICON = "org/netbeans/modules/search/res/file_view.png";
    private static final String MODE_FLAT = "flat";
    private static final String MODE_TREE = "tree";
    protected ResultModel resultModel;
    protected JToggleButton btnTreeView;
    protected JToggleButton btnFlatView;
    protected JButton showDetailsButton;
    protected boolean details;
    protected BasicComposition composition;
    protected final ResultsOutlineSupport resultsOutlineSupport;
    private NodeListener resultsNodeAdditionListener;
    protected static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    protected static final Color macBackground = UIManager.getColor("NbExplorerView.background");

    public BasicAbstractResultsPanel(ResultModel resultModel, BasicComposition basicComposition, boolean bl, ResultsOutlineSupport resultsOutlineSupport) {
        super(basicComposition, basicComposition.getSearchProviderPresenter());
        this.composition = basicComposition;
        this.details = bl;
        this.resultModel = resultModel;
        this.resultsOutlineSupport = resultsOutlineSupport;
        this.getExplorerManager().setRootContext(resultsOutlineSupport.getRootNode());
        this.initButtons();
        this.initResultNodeAdditionListener();
        if (MODE_TREE.equals(FindDialogMemory.getDefault().getResultsViewMode())) {
            resultsOutlineSupport.setFolderTreeMode();
        }
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"));
        this.initAccessibility();
    }

    public void update() {
        if (this.details && this.btnExpand.isVisible() && !this.btnExpand.isEnabled()) {
            this.btnExpand.setEnabled(this.resultModel.size() > 0);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicAbstractResultsPanel.this.updateShiftButtons();
            }
        });
        this.resultsOutlineSupport.update();
    }

    protected void initButtons() {
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        this.btnTreeView = new JToggleButton();
        this.btnTreeView.setEnabled(true);
        this.btnTreeView.setIcon(ImageUtilities.loadImageIcon((String)FOLDER_VIEW_ICON, (boolean)true));
        this.btnTreeView.setToolTipText(UiUtils.getText("TEXT_BUTTON_TREE_VIEW"));
        this.btnTreeView.setSelected(MODE_TREE.equals(findDialogMemory.getResultsViewMode()));
        this.btnTreeView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicAbstractResultsPanel.this.toggleView(!BasicAbstractResultsPanel.this.btnTreeView.isSelected());
            }
        });
        this.btnFlatView = new JToggleButton();
        this.btnFlatView.setEnabled(true);
        this.btnFlatView.setIcon(ImageUtilities.loadImageIcon((String)FLAT_VIEW_ICON, (boolean)true));
        this.btnFlatView.setToolTipText(UiUtils.getText("TEXT_BUTTON_FLAT_VIEW"));
        this.btnFlatView.setSelected(!this.btnTreeView.isSelected());
        this.btnFlatView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicAbstractResultsPanel.this.toggleView(BasicAbstractResultsPanel.this.btnFlatView.isSelected());
            }
        });
        this.addButton(this.btnTreeView);
        this.addButton(this.btnFlatView);
        if (!this.details) {
            this.btnPrev.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnExpand.setVisible(false);
            return;
        }
        this.btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicAbstractResultsPanel.this.toggleExpandNodeChildren(BasicAbstractResultsPanel.this.btnExpand.isSelected());
            }
        });
        this.showDetailsButton = new JButton();
        this.showDetailsButton.setEnabled(false);
        this.showDetailsButton.setIcon(ImageUtilities.loadImageIcon((String)SHOW_DETAILS_ICON, (boolean)true));
        this.showDetailsButton.setToolTipText(UiUtils.getText("TEXT_BUTTON_FILL"));
        this.showDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicAbstractResultsPanel.this.fillOutput();
            }
        });
        this.showDetailsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TEXT_BUTTON_FILL"));
        this.addButton(this.showDetailsButton);
    }

    private void toggleView(boolean bl) {
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (bl) {
            this.resultsOutlineSupport.setFlatMode();
            findDialogMemory.setResultsViewMode(MODE_FLAT);
        } else {
            this.resultsOutlineSupport.setFolderTreeMode();
            findDialogMemory.setResultsViewMode(MODE_TREE);
        }
        this.btnTreeView.setSelected(!bl);
        this.btnFlatView.setSelected(bl);
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{this.resultsOutlineSupport.getResultsNode()});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(ResultView.class);
        OutlineView outlineView = this.resultsOutlineSupport.getOutlineView();
        AccessibleContext accessibleContext = outlineView.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_HorizontalScrollbar"));
        accessibleContext = outlineView.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_VerticalScrollbar"));
        accessibleContext = outlineView.getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_ResultTree"));
        accessibleContext.setAccessibleDescription(resourceBundle.getString("ACSD_ResultTree"));
    }

    private void toggleExpandNodeChildren(boolean bl) {
        Node node = this.resultsOutlineSupport.getResultsNode();
        for (Node node2 : node.getChildren().getNodes()) {
            this.toggleExpand(node2, bl);
        }
    }

    @Override
    public void searchFinished() {
        super.searchFinished();
        if (this.details && this.resultModel.size() > 0 && this.showDetailsButton != null) {
            this.showDetailsButton.setEnabled(true);
        }
        this.setFinalRootNodeText();
    }

    public void fillOutput() {
        Manager.getInstance().schedulePrintTask(new PrintDetailsTask(this.resultModel.getMatchingObjects(), this.composition.getBasicSearchCriteria()));
    }

    public void addMatchingObject(MatchingObject matchingObject) {
        this.resultsOutlineSupport.addMatchingObject(matchingObject);
        this.updateRootNodeText();
        this.afterMatchingNodeAdded();
    }

    @Override
    public final OutlineView getOutlineView() {
        return this.resultsOutlineSupport.getOutlineView();
    }

    private void setFinalRootNodeText() {
        Object[] objectArray;
        String string;
        String string2;
        int n = this.resultModel.size();
        if (this.resultModel.wasLimitReached()) {
            this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES_LIMIT", (Object)n, (Object)this.resultModel.getTotalDetailsCount()) + ' ' + this.resultModel.getLimitDisplayName());
            return;
        }
        if (n == 0) {
            string2 = NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_NO_NODE_FOUND");
        } else {
            if (this.resultModel.isSearchAndReplace()) {
                string = "TEXT_MSG_FOUND_X_NODES_REPLACE";
                objectArray = new Object[4];
            } else if (this.resultModel.canHaveDetails()) {
                string = "TEXT_MSG_FOUND_X_NODES_FULLTEXT";
                objectArray = new Object[3];
            } else {
                string = "TEXT_MSG_FOUND_X_NODES";
                objectArray = new Object[]{new Integer(this.resultModel.size())};
            }
            if (objectArray.length > 1) {
                objectArray[1] = new Integer(this.resultModel.getTotalDetailsCount());
            }
            if (objectArray.length > 2) {
                BasicSearchCriteria basicSearchCriteria = this.composition.getBasicSearchCriteria();
                objectArray[2] = UiUtils.escapeHtml(basicSearchCriteria.getTextPatternExpr());
                if (objectArray.length > 3) {
                    objectArray[3] = UiUtils.escapeHtml(basicSearchCriteria.getReplaceExpr());
                }
            }
            string2 = NbBundle.getMessage(ResultView.class, (String)string, (Object[])objectArray);
        }
        string = this.resultModel.getExceptionMsg();
        objectArray = string == null ? string2 : string2 + " (" + string + ")";
        this.setRootDisplayName((String)objectArray);
    }

    private void setRootDisplayName(String string) {
        this.resultsOutlineSupport.setResultsNodeText(string);
    }

    protected void updateRootNodeText() {
        Integer n = this.resultModel.size();
        if (this.details) {
            Integer n2 = this.resultModel.getTotalDetailsCount();
            this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TXT_RootSearchedNodesFulltext", (Object)n, (Object)n2));
        } else {
            this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TXT_RootSearchedNodes", (Object)n));
        }
    }

    private void initResultNodeAdditionListener() {
        this.resultsNodeAdditionListener = new NodeAdapter(){

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                if (BasicAbstractResultsPanel.this.btnExpand != null) {
                    for (final Node node : nodeMemberEvent.getDelta()) {
                        if (BasicAbstractResultsPanel.this.btnExpand.isSelected()) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BasicAbstractResultsPanel.this.toggleExpand(node, true);
                                }
                            });
                        }
                        BasicAbstractResultsPanel.this.addChildAdditionListener(node);
                    }
                }
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
                if (BasicAbstractResultsPanel.this.btnExpand != null) {
                    for (Node node : nodeMemberEvent.getDelta()) {
                        BasicAbstractResultsPanel.this.removeChildAdditionListener(node);
                    }
                }
            }
        };
        this.resultsOutlineSupport.getResultsNode().getChildren().getNodes(true);
        this.resultsOutlineSupport.getResultsNode().addNodeListener(this.resultsNodeAdditionListener);
    }

    private void addChildAdditionListener(Node node) {
        for (Node node2 : node.getChildren().getNodes(true)) {
            this.addChildAdditionListener(node2);
        }
        node.addNodeListener(this.resultsNodeAdditionListener);
    }

    private void removeChildAdditionListener(Node node) {
        for (Node node2 : node.getChildren().getNodes(true)) {
            this.removeChildAdditionListener(node2);
        }
        node.removeNodeListener(this.resultsNodeAdditionListener);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.getOutlineView().requestFocusInWindow();
    }

    @Override
    protected boolean isDetailNode(Node node) {
        return node.getLookup().lookup(TextDetail.class) != null;
    }

    @Override
    protected void onDetailShift(Node node) {
        TextDetail textDetail = (TextDetail)node.getLookup().lookup(TextDetail.class);
        if (textDetail != null) {
            textDetail.showDetail(2);
        }
    }

    public void closed() {
        this.resultsOutlineSupport.closed();
    }
}

