/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class ListComboBoxModel
implements ComboBoxModel {
    private final List<? extends Object> elements;
    private final int maxIndex;
    private final boolean reverseOrder;
    private Object selectedItem;
    private Collection<ListDataListener> listeners;
    private ListDataEvent event = new ListDataEvent(this, 0, -1, -1);

    public ListComboBoxModel(List<? extends Object> list) {
        this(list, false);
    }

    public ListComboBoxModel(List<? extends Object> list, boolean bl) {
        if (list == null) {
            throw new IllegalArgumentException("the list of elements must not be null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("empty list of elements is not allowed");
        }
        this.elements = list;
        this.maxIndex = list.size() - 1;
        this.reverseOrder = bl;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.selectedItem != null && !this.selectedItem.equals(object) || this.selectedItem == null && object != null) {
            this.selectedItem = object;
            this.fireSelectionChange();
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.maxIndex + 1;
    }

    @Override
    public Object getElementAt(int n) {
        return this.elements.get(this.reverseOrder ? this.maxIndex - n : n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListDataListener>(3);
            this.event = new ListDataEvent(this, 0, -1, -1);
        }
        this.listeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        if (this.listeners != null && this.listeners.remove(listDataListener) && this.listeners.isEmpty()) {
            this.listeners = null;
            this.event = null;
        }
    }

    private void fireSelectionChange() {
        ListDataListener[] listDataListenerArray;
        if (this.listeners == null) {
            return;
        }
        for (ListDataListener listDataListener : listDataListenerArray = this.listeners.toArray(new ListDataListener[0])) {
            listDataListener.contentsChanged(this.event);
        }
    }
}

