/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.ui.ComponentController;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ui.PatternChangeListener;
import org.netbeans.modules.search.ui.ShorteningCellRenderer;
import org.netbeans.modules.search.ui.TextFieldFocusListener;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.util.Parameters;

public final class SearchPatternController
extends ComponentController<JComboBox> {
    private JTextComponent textToFindEditor;
    private final Map<Option, AbstractButton> bindings = new EnumMap<Option, AbstractButton>(Option.class);
    private final Map<Option, Boolean> options = new EnumMap<Option, Boolean>(Option.class);
    private final ItemListener listener;
    private boolean valid;
    private Color defaultTextColor = null;

    SearchPatternController(final JComboBox jComboBox) {
        super(jComboBox);
        jComboBox.setEditable(true);
        Component component = jComboBox.getEditor().getEditorComponent();
        jComboBox.setRenderer(new ShorteningCellRenderer());
        this.textToFindEditor = (JTextComponent)component;
        this.textToFindEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SearchPatternController.this.patternChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SearchPatternController.this.patternChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SearchPatternController.this.patternChanged();
            }
        });
        this.initHistory();
        this.valid = this.checkValid();
        this.updateTextPatternColor();
        this.textToFindEditor.addFocusListener(new TextFieldFocusListener());
        this.textToFindEditor.getDocument().addDocumentListener(new TextToFindChangeListener());
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = jComboBox.getSelectedItem();
                if (object instanceof ModelItem) {
                    SearchPattern searchPattern = ((ModelItem)object).sp;
                    for (Map.Entry entry : SearchPatternController.this.bindings.entrySet()) {
                        switch ((Option)((Object)entry.getKey())) {
                            case MATCH_CASE: {
                                ((AbstractButton)entry.getValue()).setSelected(searchPattern.isMatchCase());
                                break;
                            }
                            case WHOLE_WORDS: {
                                ((AbstractButton)entry.getValue()).setSelected(searchPattern.isWholeWords());
                                break;
                            }
                            case REGULAR_EXPRESSION: {
                                ((AbstractButton)entry.getValue()).setSelected(searchPattern.isRegExp());
                            }
                        }
                    }
                    SearchPatternController.this.options.put(Option.MATCH_CASE, searchPattern.isMatchCase());
                    SearchPatternController.this.options.put(Option.WHOLE_WORDS, searchPattern.isWholeWords());
                    SearchPatternController.this.options.put(Option.REGULAR_EXPRESSION, searchPattern.isRegExp());
                }
            }
        });
        this.listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                for (Map.Entry entry : SearchPatternController.this.bindings.entrySet()) {
                    if (entry.getValue() != itemEvent.getSource()) continue;
                    SearchPatternController.this.setOption((Option)((Object)entry.getKey()), itemEvent.getStateChange() == 1);
                    break;
                }
            }
        };
    }

    private void initHistory() {
        DefaultComboBoxModel<ModelItem> defaultComboBoxModel = new DefaultComboBoxModel<ModelItem>();
        List<SearchPattern> list = SearchHistory.getDefault().getSearchPatterns();
        for (SearchPattern searchPattern : list) {
            defaultComboBoxModel.addElement(new ModelItem(searchPattern));
        }
        ((JComboBox)this.component).setModel(defaultComboBoxModel);
        if (list.size() > 0) {
            this.setSearchPattern(list.get(0));
        }
        if (!FindDialogMemory.getDefault().isTextPatternSpecified()) {
            ((JComboBox)this.component).setSelectedItem("");
        }
    }

    @NonNull
    private String getText() {
        String string = this.textToFindEditor.getText();
        return string == null ? "" : string;
    }

    private void setText(@NullAllowed String string) {
        ((JComboBox)this.component).setSelectedItem(string == null ? "" : string);
    }

    private boolean getOption(@NonNull Option option) {
        Parameters.notNull((CharSequence)"option", (Object)((Object)option));
        Boolean bl = this.options.get((Object)option);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    private void setOption(@NonNull Option option, boolean bl) {
        Parameters.notNull((CharSequence)"option", (Object)((Object)option));
        this.options.put(option, bl);
        AbstractButton abstractButton = this.bindings.get((Object)option);
        if (abstractButton != null) {
            abstractButton.setSelected(bl);
        }
        if (option == Option.REGULAR_EXPRESSION) {
            this.updateValidity();
        }
        this.fireChange();
    }

    @NonNull
    public SearchPattern getSearchPattern() {
        return SearchPattern.create(this.getText(), this.getOption(Option.WHOLE_WORDS), this.getOption(Option.MATCH_CASE), this.getOption(Option.REGULAR_EXPRESSION));
    }

    public void setSearchPattern(@NonNull SearchPattern searchPattern) {
        Parameters.notNull((CharSequence)"searchPattern", (Object)searchPattern);
        this.setText(searchPattern.getSearchExpression());
        this.setOption(Option.WHOLE_WORDS, searchPattern.isWholeWords());
        this.setOption(Option.MATCH_CASE, searchPattern.isMatchCase());
        this.setOption(Option.REGULAR_EXPRESSION, searchPattern.isRegExp());
    }

    public void bind(final @NonNull Option option, final @NonNull AbstractButton abstractButton) {
        Parameters.notNull((CharSequence)"option", (Object)((Object)option));
        Parameters.notNull((CharSequence)"button", (Object)abstractButton);
        if (this.bindings.containsKey((Object)option)) {
            throw new IllegalStateException("Already binded with option " + (Object)((Object)option));
        }
        this.bindings.put(option, abstractButton);
        abstractButton.setSelected(this.getOption(option));
        abstractButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SearchPatternController.this.setOption(option, abstractButton.isSelected());
            }
        });
    }

    public void unbind(@NonNull Option option, @NonNull AbstractButton abstractButton) {
        Parameters.notNull((CharSequence)"option", (Object)((Object)option));
        Parameters.notNull((CharSequence)"button", (Object)abstractButton);
        this.bindings.remove((Object)option);
        abstractButton.removeItemListener(this.listener);
    }

    private void patternChanged() {
        this.updateValidity();
        this.fireChange();
    }

    private void updateValidity() {
        boolean bl = this.valid;
        this.valid = this.checkValid();
        if (this.valid != bl) {
            this.updateTextPatternColor();
        }
    }

    private boolean checkValid() {
        String string = this.getText();
        if (!this.getOption(Option.REGULAR_EXPRESSION) || string == null) {
            return true;
        }
        try {
            Pattern pattern = Pattern.compile(this.getText());
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    private void updateTextPatternColor() {
        Color color = this.getDefaultTextColor();
        this.textToFindEditor.setForeground(this.valid ? color : UiUtils.getErrorTextColor());
    }

    private Color getDefaultTextColor() {
        if (this.defaultTextColor == null) {
            this.defaultTextColor = ((JComboBox)this.component).getForeground();
        }
        return this.defaultTextColor;
    }

    private static class ModelItem {
        final SearchPattern sp;

        public ModelItem(SearchPattern searchPattern) {
            this.sp = searchPattern;
        }

        public String toString() {
            return this.sp.getSearchExpression();
        }
    }

    private class TextToFindChangeListener
    extends PatternChangeListener {
        private TextToFindChangeListener() {
        }

        @Override
        public void handleComboBoxChange(String string) {
            SearchPatternController.this.patternChanged();
        }
    }

    public static enum Option {
        MATCH_CASE,
        WHOLE_WORDS,
        REGULAR_EXPRESSION;

    }
}

