/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.taglets;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.taglets.BaseInlineTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.Tag;
import java.util.StringTokenizer;

public class ValueTaglet
extends BaseInlineTaglet {
    public ValueTaglet() {
        this.name = "value";
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    private FieldDoc getFieldDoc(Configuration config, Tag tag, String name) {
        if (name == null || name.length() == 0) {
            if (tag.holder() instanceof FieldDoc) {
                return (FieldDoc)tag.holder();
            }
            throw new DocletAbortException();
        }
        StringTokenizer st = new StringTokenizer(name, "#");
        String memberName = null;
        ClassDoc cd = null;
        if (st.countTokens() == 1) {
            Doc holder = tag.holder();
            if (holder instanceof MemberDoc) {
                cd = ((MemberDoc)holder).containingClass();
            } else if (holder instanceof ClassDoc) {
                cd = (ClassDoc)holder;
            }
            memberName = st.nextToken();
        } else {
            cd = config.root.classNamed(st.nextToken());
            memberName = st.nextToken();
        }
        if (cd == null) {
            return null;
        }
        FieldDoc[] fields = cd.fields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].name().equals(memberName)) continue;
            return fields[i];
        }
        return null;
    }

    public TagletOutput getTagletOutput(Tag tag, TagletWriter writer) {
        FieldDoc field = this.getFieldDoc(writer.configuration(), tag, tag.text());
        if (field == null) {
            writer.getMsgRetriever().warning(tag.holder().position(), "doclet.value_tag_invalid_reference", tag.text());
        } else {
            if (field.constantValue() != null) {
                return writer.valueTagOutput(field, Util.escapeHtmlChars(field.constantValueExpression()), !field.equals(tag.holder()));
            }
            writer.getMsgRetriever().warning(tag.holder().position(), "doclet.value_tag_invalid_constant", field.name());
        }
        return writer.getOutputInstance();
    }
}

