/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.AnnotationTypeRequiredMemberWriter;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTypeRequiredMemberBuilder
extends AbstractMemberBuilder {
    protected ClassDoc classDoc;
    protected VisibleMemberMap visibleMemberMap;
    protected AnnotationTypeRequiredMemberWriter writer;
    protected List<ProgramElementDoc> members;
    protected int currentMemberIndex;

    protected AnnotationTypeRequiredMemberBuilder(Configuration configuration) {
        super(configuration);
    }

    public static AnnotationTypeRequiredMemberBuilder getInstance(Configuration configuration, ClassDoc classDoc, AnnotationTypeRequiredMemberWriter writer) {
        AnnotationTypeRequiredMemberBuilder builder = new AnnotationTypeRequiredMemberBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 6, configuration.nodeprecated);
        builder.members = new ArrayList<ProgramElementDoc>(builder.visibleMemberMap.getMembersFor(classDoc));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.members, configuration.getMemberComparator());
        }
        return builder;
    }

    @Override
    public String getName() {
        return "AnnotationTypeRequiredMemberDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.members.size() > 0;
    }

    public void buildAnnotationTypeRequiredMember(XMLNode node, Content memberDetailsTree) {
        this.buildAnnotationTypeMember(node, memberDetailsTree);
    }

    public void buildAnnotationTypeMember(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.members.size();
        if (size > 0) {
            this.writer.addAnnotationDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentMemberIndex = 0;
            while (this.currentMemberIndex < size) {
                Content annotationDocTree = this.writer.getAnnotationDocTreeHeader((MemberDoc)this.members.get(this.currentMemberIndex), memberDetailsTree);
                this.buildChildren(node, annotationDocTree);
                memberDetailsTree.addContent(this.writer.getAnnotationDoc(annotationDocTree, this.currentMemberIndex == size - 1));
                ++this.currentMemberIndex;
            }
        }
    }

    public void buildSignature(XMLNode node, Content annotationDocTree) {
        annotationDocTree.addContent(this.writer.getSignature((MemberDoc)this.members.get(this.currentMemberIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content annotationDocTree) {
        this.writer.addDeprecated((MemberDoc)this.members.get(this.currentMemberIndex), annotationDocTree);
    }

    public void buildMemberComments(XMLNode node, Content annotationDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((MemberDoc)this.members.get(this.currentMemberIndex), annotationDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content annotationDocTree) {
        this.writer.addTags((MemberDoc)this.members.get(this.currentMemberIndex), annotationDocTree);
    }

    public AnnotationTypeRequiredMemberWriter getWriter() {
        return this.writer;
    }
}

