/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ClassWriterImpl;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.LinkFactoryImpl;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.LinkOutputImpl;
import com.javafx.tools.doclets.formats.html.MethodWriterImpl;
import com.javafx.tools.doclets.formats.html.SourceToHTMLConverter;
import com.javafx.tools.doclets.formats.html.TagletOutputImpl;
import com.javafx.tools.doclets.formats.html.TagletWriterImpl;
import com.javafx.tools.doclets.formats.html.markup.Comment;
import com.javafx.tools.doclets.formats.html.markup.DocType;
import com.javafx.tools.doclets.formats.html.markup.HtmlAttr;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlDocWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlDocument;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.javafx.tools.doclets.internal.toolkit.ClassWriter;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.javafx.tools.doclets.internal.toolkit.taglets.DocRootTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletConstants;
import com.javafx.tools.doclets.internal.toolkit.util.ImplementedMethods;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDocletWriter
extends HtmlDocWriter {
    public String relativePath = "";
    public String relativepathNoSlash = "";
    public String path = "";
    public String filename = "";
    public int displayLength = 0;
    public ConfigurationImpl configuration;
    protected boolean printedAnnotationHeading = false;

    public HtmlDocletWriter(ConfigurationImpl configuration, String filename) throws IOException {
        super(configuration, filename);
        this.configuration = configuration;
        this.filename = filename;
    }

    public HtmlDocletWriter(ConfigurationImpl configuration, String path, String filename, String relativePath) throws IOException {
        super(configuration, path, filename);
        this.configuration = configuration;
        this.path = path;
        this.relativePath = relativePath;
        this.relativepathNoSlash = DirectoryManager.getPathNoTrailingSlash(this.relativePath);
        this.filename = filename;
    }

    public String replaceDocRootDir(String htmlstr) {
        int index = htmlstr.indexOf("{@");
        if (index < 0) {
            return htmlstr;
        }
        String lowerHtml = htmlstr.toLowerCase();
        index = lowerHtml.indexOf("{@docroot}", index);
        if (index < 0) {
            return htmlstr;
        }
        StringBuilder buf = new StringBuilder();
        int previndex = 0;
        while (true) {
            if (this.configuration.docrootparent.length() > 0) {
                index = lowerHtml.indexOf("{@docroot}/..", previndex);
                if (index < 0) {
                    buf.append(htmlstr.substring(previndex));
                    break;
                }
                buf.append(htmlstr.substring(previndex, index));
                previndex = index + 13;
                buf.append(this.configuration.docrootparent);
                if (previndex >= htmlstr.length() || htmlstr.charAt(previndex) == '/') continue;
                buf.append("/");
                continue;
            }
            index = lowerHtml.indexOf("{@docroot}", previndex);
            if (index < 0) {
                buf.append(htmlstr.substring(previndex));
                break;
            }
            buf.append(htmlstr.substring(previndex, index));
            previndex = index + 10;
            buf.append(this.relativepathNoSlash);
            if (this.relativepathNoSlash.length() <= 0 || previndex >= htmlstr.length() || htmlstr.charAt(previndex) == '/') continue;
            buf.append("/");
        }
        return buf.toString();
    }

    public void printNoFramesTargetHyperLink(String link, String where, String target, String label, boolean strong) {
        this.script();
        this.println("  <!--");
        this.println("  if(window==top) {");
        this.println("    document.writeln('" + this.getHyperLinkString(link, where, label, strong, "", "", target) + "');");
        this.println("  }");
        this.println("  //-->");
        this.scriptEnd();
        this.noScript();
        this.println("  " + this.getHyperLinkString(link, where, label, strong, "", "", target));
        this.noScriptEnd();
        this.println(DocletConstants.NL);
    }

    public Content getAllClassesLinkScript(String id) {
        HtmlTree script = new HtmlTree(HtmlTag.SCRIPT);
        script.addAttr(HtmlAttr.TYPE, "text/javascript");
        String scriptCode = "<!--" + DocletConstants.NL + "  allClassesLink = document.getElementById(\"" + id + "\");" + DocletConstants.NL + "  if(window==top) {" + DocletConstants.NL + "    allClassesLink.style.display = \"block\";" + DocletConstants.NL + "  }" + DocletConstants.NL + "  else {" + DocletConstants.NL + "    allClassesLink.style.display = \"none\";" + DocletConstants.NL + "  }" + DocletConstants.NL + "  //-->" + DocletConstants.NL;
        RawHtml scriptContent = new RawHtml(scriptCode);
        script.addContent(scriptContent);
        HtmlTree div = HtmlTree.DIV(script);
        return div;
    }

    private void addMethodInfo(MethodDoc method, Content dl) {
        ClassDoc[] intfacs = method.containingClass().interfaces();
        MethodDoc overriddenMethod = method.overriddenMethod();
        if (intfacs.length > 0 && new ImplementedMethods(method, this.configuration).build().length > 0 || overriddenMethod != null) {
            MethodWriterImpl.addImplementsInfo(this, method, dl);
            if (overriddenMethod != null) {
                MethodWriterImpl.addOverridden(this, method.overriddenType(), overriddenMethod, dl);
            }
        }
    }

    protected void addTagsInfo(Doc doc, Content htmltree) {
        if (this.configuration.nocomment) {
            return;
        }
        HtmlTree dl = new HtmlTree(HtmlTag.DL);
        if (doc instanceof MethodDoc) {
            this.addMethodInfo((MethodDoc)doc, dl);
        }
        TagletOutputImpl output = new TagletOutputImpl("");
        TagletWriter.genTagOuput(this.configuration.tagletManager, doc, this.configuration.tagletManager.getCustomTags(doc), this.getTagletWriterInstance(false), output);
        String outputString = output.toString().trim();
        if (!outputString.isEmpty()) {
            RawHtml resultString = new RawHtml(outputString);
            ((Content)dl).addContent(resultString);
        }
        htmltree.addContent(dl);
    }

    protected boolean hasSerializationOverviewTags(FieldDoc field) {
        TagletOutputImpl output = new TagletOutputImpl("");
        TagletWriter.genTagOuput(this.configuration.tagletManager, (Doc)field, this.configuration.tagletManager.getCustomTags((Doc)field), this.getTagletWriterInstance(false), output);
        return !output.toString().trim().isEmpty();
    }

    public TagletWriter getTagletWriterInstance(boolean isFirstSentence) {
        return new TagletWriterImpl(this, isFirstSentence);
    }

    protected void printTagsInfoHeader() {
        this.dl();
    }

    protected void printTagsInfoFooter() {
        this.dlEnd();
    }

    public Content getTargetPackageLink(PackageDoc pd, String target, Content label) {
        return this.getHyperLink(this.pathString(pd, "package-summary.html"), "", label, "", target);
    }

    public void printHtmlHeader(String title, String[] metakeywords, boolean includeScript) {
        this.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        this.println("<!--NewPage-->");
        this.html();
        this.head();
        if (!this.configuration.notimestamp) {
            this.print("<!-- Generated by javadoc (build " + ConfigurationImpl.BUILD_DATE + ") on ");
            this.print(this.today());
            this.println(" -->");
        }
        if (this.configuration.charset.length() > 0) {
            this.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.configuration.charset + "\">");
        }
        if (this.configuration.windowtitle.length() > 0) {
            title = title + " (" + this.configuration.windowtitle + ")";
        }
        this.title(title);
        this.println(title);
        this.titleEnd();
        this.println("");
        if (!this.configuration.notimestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.println("<META NAME=\"date\" CONTENT=\"" + dateFormat.format(new Date()) + "\">");
        }
        if (metakeywords != null) {
            for (int i = 0; i < metakeywords.length; ++i) {
                this.println("<META NAME=\"keywords\" CONTENT=\"" + metakeywords[i] + "\">");
            }
        }
        this.println("");
        this.printStyleSheetProperties();
        this.println("");
        if (includeScript) {
            this.printWinTitleScript(title);
        }
        this.println("");
        this.headEnd();
        this.println("");
        this.body("white", includeScript);
    }

    public void printHtmlDocument(String[] metakeywords, boolean includeScript, Content body) {
        HtmlTree meta;
        DocType htmlDocType = DocType.Transitional();
        Comment htmlComment = new Comment(this.configuration.getText("doclet.New_Page"));
        HtmlTree head = new HtmlTree(HtmlTag.HEAD);
        if (!this.configuration.notimestamp) {
            Comment headComment = new Comment("Generated by javadoc (version " + ConfigurationImpl.BUILD_DATE + ") on " + this.today());
            ((Content)head).addContent(headComment);
        }
        if (this.configuration.charset.length() > 0) {
            HtmlTree meta2 = HtmlTree.META("Content-Type", "text/html", this.configuration.charset);
            ((Content)head).addContent(meta2);
        }
        ((Content)head).addContent(this.getTitle());
        if (!this.configuration.notimestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            meta = HtmlTree.META("date", dateFormat.format(new Date()));
            ((Content)head).addContent(meta);
        }
        if (metakeywords != null) {
            for (int i = 0; i < metakeywords.length; ++i) {
                meta = HtmlTree.META("keywords", metakeywords[i]);
                ((Content)head).addContent(meta);
            }
        }
        ((Content)head).addContent(this.getStyleSheetProperties());
        HtmlTree htmlTree = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), head, body);
        HtmlDocument htmlDocument = new HtmlDocument(htmlDocType, htmlComment, htmlTree);
        this.print(htmlDocument.toString());
    }

    public String getWindowTitle(String title) {
        if (this.configuration.windowtitle.length() > 0) {
            title = title + " (" + this.configuration.windowtitle + ")";
        }
        return title;
    }

    public void printUserHeaderFooter(boolean header) {
        this.em();
        if (header) {
            this.print(this.replaceDocRootDir(this.configuration.header));
        } else if (this.configuration.footer.length() != 0) {
            this.print(this.replaceDocRootDir(this.configuration.footer));
        } else {
            this.print(this.replaceDocRootDir(this.configuration.header));
        }
        this.emEnd();
    }

    public Content getUserHeaderFooter(boolean header) {
        String content = header ? this.replaceDocRootDir(this.configuration.header) : (this.configuration.footer.length() != 0 ? this.replaceDocRootDir(this.configuration.footer) : this.replaceDocRootDir(this.configuration.header));
        RawHtml rawContent = new RawHtml(content);
        HtmlTree em = HtmlTree.EM(rawContent);
        return em;
    }

    public void printTop() {
        this.print(this.replaceDocRootDir(this.configuration.top));
        this.hr();
    }

    public void addTop(Content body) {
        RawHtml top = new RawHtml(this.replaceDocRootDir(this.configuration.top));
        body.addContent(top);
    }

    public void printBottom() {
        this.hr();
        this.print(this.replaceDocRootDir(this.configuration.bottom));
    }

    public void addBottom(Content body) {
        RawHtml bottom = new RawHtml(this.replaceDocRootDir(this.configuration.bottom));
        HtmlTree small = HtmlTree.SMALL(bottom);
        HtmlTree p = HtmlTree.P(HtmlStyle.legalCopy, small);
        body.addContent(p);
    }

    protected void navLinks(boolean header) {
        this.println("");
        if (!this.configuration.nonavbar) {
            if (header) {
                this.println(DocletConstants.NL + "<!-- ========= START OF TOP NAVBAR ======= -->");
                this.anchor("navbar_top");
                this.println();
                this.print(this.getHyperLinkString("", "skip-navbar_top", "", false, "", this.configuration.getText("doclet.Skip_navigation_links"), ""));
            } else {
                this.println(DocletConstants.NL + "<!-- ======= START OF BOTTOM NAVBAR ====== -->");
                this.anchor("navbar_bottom");
                this.println();
                this.print(this.getHyperLinkString("", "skip-navbar_bottom", "", false, "", this.configuration.getText("doclet.Skip_navigation_links"), ""));
            }
            this.table(0, "100%", 1, 0);
            this.tr();
            this.tdColspanBgcolorStyle(2, "#EEEEFF", "NavBarCell1");
            this.println("");
            if (header) {
                this.anchor("navbar_top_firstrow");
            } else {
                this.anchor("navbar_bottom_firstrow");
            }
            this.table(0, 0, 3);
            this.print("  ");
            this.trAlignVAlign("center", "top");
            if (this.configuration.createoverview) {
                this.navLinkContents();
            }
            if (this.configuration.packages.length == 1) {
                this.navLinkPackage(this.configuration.packages[0]);
            } else if (this.configuration.packages.length > 1) {
                this.navLinkPackage();
            }
            this.navLinkClass();
            if (this.configuration.classuse) {
                this.navLinkClassUse();
            }
            if (this.configuration.createtree) {
                this.navLinkTree();
            }
            if (!this.configuration.nodeprecated && !this.configuration.nodeprecatedlist) {
                this.navLinkDeprecated();
            }
            if (this.configuration.createindex) {
                this.navLinkIndex();
            }
            if (!this.configuration.nohelp) {
                this.navLinkHelp();
            }
            this.print("  ");
            this.trEnd();
            this.tableEnd();
            this.tdEnd();
            this.tdAlignVAlignRowspan("right", "top", 3);
            this.printUserHeaderFooter(header);
            this.tdEnd();
            this.trEnd();
            this.println("");
            this.tr();
            this.tdBgcolorStyle("white", "NavBarCell2");
            this.font("-2");
            this.space();
            this.navLinkPrevious();
            this.space();
            this.println("");
            this.space();
            this.navLinkNext();
            this.fontEnd();
            this.tdEnd();
            this.tdBgcolorStyle("white", "NavBarCell2");
            this.font("-2");
            this.print("  ");
            this.navShowLists();
            this.print("  ");
            this.space();
            this.println("");
            this.space();
            this.navHideLists(this.filename);
            this.print("  ");
            this.space();
            this.println("");
            this.space();
            this.navLinkClassIndex();
            this.fontEnd();
            this.tdEnd();
            this.trEnd();
            this.printSummaryDetailLinks();
            this.tableEnd();
            if (header) {
                this.aName("skip-navbar_top");
                this.aEnd();
                this.println(DocletConstants.NL + "<!-- ========= END OF TOP NAVBAR ========= -->");
            } else {
                this.aName("skip-navbar_bottom");
                this.aEnd();
                this.println(DocletConstants.NL + "<!-- ======== END OF BOTTOM NAVBAR ======= -->");
            }
            this.println("");
        }
    }

    protected void addNavLinks(boolean header, Content body) {
        if (!this.configuration.nonavbar) {
            Content skipLinkContent;
            Content a;
            String allClassesId = "allclasses_";
            HtmlTree navDiv = new HtmlTree(HtmlTag.DIV);
            if (header) {
                body.addContent(HtmlConstants.START_OF_TOP_NAVBAR);
                navDiv.addStyle(HtmlStyle.topNav);
                allClassesId = allClassesId + "navbar_top";
                a = this.getMarkerAnchor("navbar_top");
                navDiv.addContent(a);
                skipLinkContent = this.getHyperLink("", "skip-navbar_top", HtmlTree.EMPTY, this.configuration.getText("doclet.Skip_navigation_links"), "");
                navDiv.addContent(skipLinkContent);
            } else {
                body.addContent(HtmlConstants.START_OF_BOTTOM_NAVBAR);
                navDiv.addStyle(HtmlStyle.bottomNav);
                allClassesId = allClassesId + "navbar_bottom";
                a = this.getMarkerAnchor("navbar_bottom");
                navDiv.addContent(a);
                skipLinkContent = this.getHyperLink("", "skip-navbar_bottom", HtmlTree.EMPTY, this.configuration.getText("doclet.Skip_navigation_links"), "");
                navDiv.addContent(skipLinkContent);
            }
            if (header) {
                navDiv.addContent(this.getMarkerAnchor("navbar_top_firstrow"));
            } else {
                navDiv.addContent(this.getMarkerAnchor("navbar_bottom_firstrow"));
            }
            HtmlTree navList = new HtmlTree(HtmlTag.UL);
            navList.addStyle(HtmlStyle.navList);
            navList.addAttr(HtmlAttr.TITLE, this.configuration.getText("doclet.Navigation"));
            if (this.configuration.createoverview) {
                navList.addContent(this.getNavLinkContents());
            }
            if (this.configuration.packages.length == 1) {
                navList.addContent(this.getNavLinkPackage(this.configuration.packages[0]));
            } else if (this.configuration.packages.length > 1) {
                navList.addContent(this.getNavLinkPackage());
            }
            navList.addContent(this.getNavLinkClass());
            if (this.configuration.classuse) {
                navList.addContent(this.getNavLinkClassUse());
            }
            if (this.configuration.createtree) {
                navList.addContent(this.getNavLinkTree());
            }
            if (!this.configuration.nodeprecated && !this.configuration.nodeprecatedlist) {
                navList.addContent(this.getNavLinkDeprecated());
            }
            if (this.configuration.createindex) {
                navList.addContent(this.getNavLinkIndex());
            }
            if (!this.configuration.nohelp) {
                navList.addContent(this.getNavLinkHelp());
            }
            navDiv.addContent(navList);
            HtmlTree aboutDiv = HtmlTree.DIV(HtmlStyle.aboutLanguage, this.getUserHeaderFooter(header));
            navDiv.addContent(aboutDiv);
            body.addContent(navDiv);
            HtmlTree ulNav = HtmlTree.UL(HtmlStyle.navList, this.getNavLinkPrevious());
            ((Content)ulNav).addContent(this.getNavLinkNext());
            HtmlTree subDiv = HtmlTree.DIV(HtmlStyle.subNav, ulNav);
            HtmlTree ulFrames = HtmlTree.UL(HtmlStyle.navList, this.getNavShowLists());
            ((Content)ulFrames).addContent(this.getNavHideLists(this.filename));
            ((Content)subDiv).addContent(ulFrames);
            HtmlTree ulAllClasses = HtmlTree.UL(HtmlStyle.navList, this.getNavLinkClassIndex());
            ulAllClasses.addAttr(HtmlAttr.ID, allClassesId.toString());
            ((Content)subDiv).addContent(ulAllClasses);
            ((Content)subDiv).addContent(this.getAllClassesLinkScript(allClassesId.toString()));
            this.addSummaryDetailLinks(subDiv);
            if (header) {
                ((Content)subDiv).addContent(this.getMarkerAnchor("skip-navbar_top"));
                body.addContent(subDiv);
                body.addContent(HtmlConstants.END_OF_TOP_NAVBAR);
            } else {
                ((Content)subDiv).addContent(this.getMarkerAnchor("skip-navbar_bottom"));
                body.addContent(subDiv);
                body.addContent(HtmlConstants.END_OF_BOTTOM_NAVBAR);
            }
        }
    }

    protected void navLinkNext() {
        this.navLinkNext(null);
    }

    protected Content getNavLinkNext() {
        return this.getNavLinkNext(null);
    }

    protected void navLinkPrevious() {
        this.navLinkPrevious(null);
    }

    protected Content getNavLinkPrevious() {
        return this.getNavLinkPrevious(null);
    }

    protected void printSummaryDetailLinks() {
    }

    protected void addSummaryDetailLinks(Content navDiv) {
    }

    protected void navLinkContents() {
        this.navCellStart();
        this.printHyperLink(this.relativePath + "overview-summary.html", "", this.configuration.getText("doclet.Overview"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected Content getNavLinkContents() {
        Content linkContent = this.getHyperLink(this.relativePath + "overview-summary.html", "", this.overviewLabel, "", "");
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected void navCellStart() {
        this.print("  ");
        this.tdBgcolorStyle("#EEEEFF", "NavBarCell1");
        this.print("    ");
    }

    protected void navCellRevStart() {
        this.print("  ");
        this.tdBgcolorStyle("#FFFFFF", "NavBarCell1Rev");
        this.print(" ");
        this.space();
    }

    protected void navCellEnd() {
        this.space();
        this.tdEnd();
    }

    protected void navLinkPackage(PackageDoc pkg) {
        this.navCellStart();
        this.printPackageLink(pkg, this.configuration.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected Content getNavLinkPackage(PackageDoc pkg) {
        Content linkContent = this.getPackageLink(pkg, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.fontStyle("NavBarFont1");
        this.printText("doclet.Package");
        this.fontEnd();
        this.navCellEnd();
    }

    protected Content getNavLinkPackage() {
        HtmlTree li = HtmlTree.LI(this.packageLabel);
        return li;
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.fontStyle("NavBarFont1");
        this.printText("doclet.navClassUse");
        this.fontEnd();
        this.navCellEnd();
    }

    protected Content getNavLinkClassUse() {
        HtmlTree li = HtmlTree.LI(this.useLabel);
        return li;
    }

    public void navLinkPrevious(String prev) {
        String tag = this.configuration.getText("doclet.Prev");
        if (prev != null) {
            this.printHyperLink(prev, "", tag, true);
        } else {
            this.print(tag);
        }
    }

    public Content getNavLinkPrevious(String prev) {
        HtmlTree li = prev != null ? HtmlTree.LI(this.getHyperLink(prev, "", this.prevLabel, "", "")) : HtmlTree.LI(this.prevLabel);
        return li;
    }

    public void navLinkNext(String next) {
        String tag = this.configuration.getText("doclet.Next");
        if (next != null) {
            this.printHyperLink(next, "", tag, true);
        } else {
            this.print(tag);
        }
    }

    public Content getNavLinkNext(String next) {
        HtmlTree li = next != null ? HtmlTree.LI(this.getHyperLink(next, "", this.nextLabel, "", "")) : HtmlTree.LI(this.nextLabel);
        return li;
    }

    protected void navShowLists(String link) {
        this.print(this.getHyperLinkString(link + "?" + this.path + this.filename, "", this.configuration.getText("doclet.FRAMES"), true, "", "", "_top"));
    }

    protected Content getNavShowLists(String link) {
        Content framesContent = this.getHyperLink(link + "?" + this.path + this.filename, "", this.framesLabel, "", "_top");
        HtmlTree li = HtmlTree.LI(framesContent);
        return li;
    }

    protected void navShowLists() {
        this.navShowLists(this.relativePath + "index.html");
    }

    protected Content getNavShowLists() {
        return this.getNavShowLists(this.relativePath + "index.html");
    }

    protected void navHideLists(String link) {
        this.print(this.getHyperLinkString(link, "", this.configuration.getText("doclet.NO_FRAMES"), true, "", "", "_top"));
    }

    protected Content getNavHideLists(String link) {
        Content noFramesContent = this.getHyperLink(link, "", this.noframesLabel, "", "_top");
        HtmlTree li = HtmlTree.LI(noFramesContent);
        return li;
    }

    protected void navLinkTree() {
        this.navCellStart();
        PackageDoc[] packages = this.configuration.root.specifiedPackages();
        if (packages.length == 1 && this.configuration.root.specifiedClasses().length == 0) {
            this.printHyperLink(this.pathString(packages[0], "package-tree.html"), "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink(this.relativePath + "overview-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }

    protected Content getNavLinkTree() {
        PackageDoc[] packages = this.configuration.root.specifiedPackages();
        Content treeLinkContent = packages.length == 1 && this.configuration.root.specifiedClasses().length == 0 ? this.getHyperLink(this.pathString(packages[0], "package-tree.html"), "", this.treeLabel, "", "") : this.getHyperLink(this.relativePath + "overview-tree.html", "", this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(treeLinkContent);
        return li;
    }

    protected Content getNavLinkMainTree(String label) {
        Content mainTreeContent = this.getHyperLink(this.relativePath + "overview-tree.html", new StringContent(label));
        HtmlTree li = HtmlTree.LI(mainTreeContent);
        return li;
    }

    protected void navLinkClass() {
        this.navCellStart();
        this.fontStyle("NavBarFont1");
        this.printText("doclet.Class");
        this.fontEnd();
        this.navCellEnd();
    }

    protected Content getNavLinkClass() {
        HtmlTree li = HtmlTree.LI(this.classLabel);
        return li;
    }

    protected void navLinkDeprecated() {
        this.navCellStart();
        this.printHyperLink(this.relativePath + "deprecated-list.html", "", this.configuration.getText("doclet.navDeprecated"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected Content getNavLinkDeprecated() {
        Content linkContent = this.getHyperLink(this.relativePath + "deprecated-list.html", "", this.deprecatedLabel, "", "");
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected void navLinkClassIndex() {
        this.printNoFramesTargetHyperLink(this.relativePath + "allclasses-noframe.html", "", "", this.configuration.getText("doclet.All_Classes"), true);
    }

    protected Content getNavLinkClassIndex() {
        Content allClassesContent = this.getHyperLink(this.relativePath + "allclasses-noframe.html", "", this.allclassesLabel, "", "");
        HtmlTree li = HtmlTree.LI(allClassesContent);
        return li;
    }

    protected void navLinkIndex() {
        this.navCellStart();
        this.printHyperLink(this.relativePath + (this.configuration.splitindex ? DirectoryManager.getPath("index-files") + "/" : "") + (this.configuration.splitindex ? "index-1.html" : "index-all.html"), "", this.configuration.getText("doclet.Index"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected Content getNavLinkIndex() {
        Content linkContent = this.getHyperLink(this.relativePath + (this.configuration.splitindex ? DirectoryManager.getPath("index-files") + "/" : "") + (this.configuration.splitindex ? "index-1.html" : "index-all.html"), "", this.indexLabel, "", "");
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected void navLinkHelp() {
        String helpfilenm = this.configuration.helpfile;
        if (helpfilenm.equals("")) {
            helpfilenm = "help-doc.html";
        } else {
            int lastsep = helpfilenm.lastIndexOf(File.separatorChar);
            if (lastsep != -1) {
                helpfilenm = helpfilenm.substring(lastsep + 1);
            }
        }
        this.navCellStart();
        this.printHyperLink(this.relativePath + helpfilenm, "", this.configuration.getText("doclet.Help"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected Content getNavLinkHelp() {
        String helpfilenm = this.configuration.helpfile;
        if (helpfilenm.equals("")) {
            helpfilenm = "help-doc.html";
        } else {
            int lastsep = helpfilenm.lastIndexOf(File.separatorChar);
            if (lastsep != -1) {
                helpfilenm = helpfilenm.substring(lastsep + 1);
            }
        }
        Content linkContent = this.getHyperLink(this.relativePath + helpfilenm, "", this.helpLabel, "", "");
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected void navDetail() {
        this.printText("doclet.Detail");
    }

    protected void navSummary() {
        this.printText("doclet.Summary");
    }

    public void tableIndexSummary() {
        this.table(1, "100%", 3, 0);
    }

    public void tableIndexSummary(String summary) {
        this.table(1, "100%", 3, 0, summary);
    }

    public void tableIndexDetail() {
        this.table(1, "100%", 3, 0);
    }

    public void tdIndex() {
        this.print("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\">");
    }

    public void tableCaptionStart() {
        this.captionStyle("TableCaption");
    }

    public void tableSubCaptionStart() {
        this.captionStyle("TableSubCaption");
    }

    public void tableCaptionEnd() {
        this.captionEnd();
    }

    public void summaryTableHeader(String[] header, String scope) {
        this.tr();
        for (int i = 0; i < header.length; ++i) {
            this.thScopeNoWrap("TableHeader", scope);
            this.print(header[i]);
            this.thEnd();
        }
        this.trEnd();
    }

    public Content getSummaryTableHeader(String[] header, String scope) {
        HtmlTree tr = new HtmlTree(HtmlTag.TR);
        int size = header.length;
        if (size == 1) {
            StringContent tableHeader = new StringContent(header[0]);
            ((Content)tr).addContent(HtmlTree.TH(HtmlStyle.colOne, scope, tableHeader));
            return tr;
        }
        for (int i = 0; i < size; ++i) {
            StringContent tableHeader = new StringContent(header[i]);
            if (i == 0) {
                ((Content)tr).addContent(HtmlTree.TH(HtmlStyle.colFirst, scope, tableHeader));
                continue;
            }
            if (i == size - 1) {
                ((Content)tr).addContent(HtmlTree.TH(HtmlStyle.colLast, scope, tableHeader));
                continue;
            }
            ((Content)tr).addContent(HtmlTree.TH(scope, tableHeader));
        }
        return tr;
    }

    public Content getTableCaption(String rawText) {
        RawHtml title = new RawHtml(rawText);
        HtmlTree captionSpan = HtmlTree.SPAN(title);
        Content space = this.getSpace();
        HtmlTree tabSpan = HtmlTree.SPAN(HtmlStyle.tabEnd, space);
        HtmlTree caption = HtmlTree.CAPTION(captionSpan);
        ((Content)caption).addContent(tabSpan);
        return caption;
    }

    public Content getMarkerAnchor(String anchorName) {
        return this.getMarkerAnchor(anchorName, null);
    }

    public Content getMarkerAnchor(String anchorName, Content anchorContent) {
        if (anchorContent == null) {
            anchorContent = new Comment(" ");
        }
        HtmlTree markerAnchor = HtmlTree.A_NAME(anchorName, anchorContent);
        return markerAnchor;
    }

    public Content getPackageName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? this.defaultPackageLabel : this.getPackageLabel(packageDoc.name());
    }

    public Content getPackageLabel(String packageName) {
        return new StringContent(packageName);
    }

    protected void addPackageDeprecatedAPI(List<Doc> deprPkgs, String headingKey, String tableSummary, String[] tableHeader, Content contentTree) {
        if (deprPkgs.size() > 0) {
            HtmlTree table = HtmlTree.TABLE(0, 3, 0, tableSummary, this.getTableCaption(this.configuration().getText(headingKey)));
            ((Content)table).addContent(this.getSummaryTableHeader(tableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            for (int i = 0; i < deprPkgs.size(); ++i) {
                PackageDoc pkg = (PackageDoc)deprPkgs.get(i);
                HtmlTree td = HtmlTree.TD(HtmlStyle.colOne, this.getPackageLink(pkg, this.getPackageName(pkg)));
                if (pkg.tags("deprecated").length > 0) {
                    this.addInlineDeprecatedComment((Doc)pkg, pkg.tags("deprecated")[0], td);
                }
                HtmlTree tr = HtmlTree.TR(td);
                if (i % 2 == 0) {
                    tr.addStyle(HtmlStyle.altColor);
                } else {
                    tr.addStyle(HtmlStyle.rowColor);
                }
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
            HtmlTree ul = HtmlTree.UL(HtmlStyle.blockList, li);
            contentTree.addContent(ul);
        }
    }

    public void tableHeaderStart(String color, int span) {
        this.trBgcolorStyle(color, "TableHeadingColor");
        this.thAlignColspan("left", span);
        this.font("+2");
    }

    public void tableInheritedHeaderStart(String color) {
        this.trBgcolorStyle(color, "TableSubHeadingColor");
        this.thAlign("left");
    }

    public void tableUseInfoHeaderStart(String color) {
        this.trBgcolorStyle(color, "TableSubHeadingColor");
        this.thAlignColspan("left", 2);
    }

    public void tableHeaderStart(String color) {
        this.tableHeaderStart(color, 2);
    }

    public void tableHeaderStart(int span) {
        this.tableHeaderStart("#CCCCFF", span);
    }

    public void tableHeaderStart() {
        this.tableHeaderStart(2);
    }

    public void tableHeaderEnd() {
        this.fontEnd();
        this.thEnd();
        this.trEnd();
    }

    public void tableInheritedHeaderEnd() {
        this.thEnd();
        this.trEnd();
    }

    public void summaryRow(int width) {
        if (width != 0) {
            this.tdWidth(width + "%");
        } else {
            this.td();
        }
    }

    public void summaryRowEnd() {
        this.tdEnd();
    }

    public void printIndexHeading(String str) {
        this.h2();
        this.print(str);
        this.h2End();
    }

    public void frameSet(String arg) {
        this.println("<FRAMESET " + arg + ">");
    }

    public void frameSetEnd() {
        this.println("</FRAMESET>");
    }

    public void frame(String arg) {
        this.println("<FRAME " + arg + ">");
    }

    public void frameEnd() {
        this.println("</FRAME>");
    }

    protected String pathToClass(ClassDoc cd) {
        return this.pathString(cd.containingPackage(), cd.name() + ".html");
    }

    protected String pathString(ClassDoc cd, String name) {
        return this.pathString(cd.containingPackage(), name);
    }

    protected String pathString(PackageDoc pd, String name) {
        StringBuffer buf = new StringBuffer(this.relativePath);
        buf.append(DirectoryManager.getPathToPackage(pd, name));
        return buf.toString();
    }

    public void printPackageLink(PackageDoc pkg, String label, boolean isStrong) {
        this.print(this.getPackageLinkString(pkg, label, isStrong));
    }

    public void printPackageLink(PackageDoc pkg, String label, boolean isStrong, String style) {
        this.print(this.getPackageLinkString(pkg, label, isStrong, style));
    }

    public String getPackageLinkString(PackageDoc pkg, String label, boolean isStrong) {
        return this.getPackageLinkString(pkg, label, isStrong, "");
    }

    public String getPackageLinkString(PackageDoc pkg, String label, boolean isStrong, String style) {
        boolean included;
        boolean bl = included = pkg != null && pkg.isIncluded();
        if (!included) {
            PackageDoc[] packages = this.configuration.packages;
            for (int i = 0; i < packages.length; ++i) {
                if (!packages[i].equals(pkg)) continue;
                included = true;
                break;
            }
        }
        if (included || pkg == null) {
            return this.getHyperLinkString(this.pathString(pkg, "package-summary.html"), "", label, isStrong, style);
        }
        String crossPkgLink = this.getCrossPackageLink(Util.getPackageName(pkg));
        if (crossPkgLink != null) {
            return this.getHyperLinkString(crossPkgLink, "", label, isStrong, style);
        }
        return label;
    }

    public Content getPackageLink(PackageDoc pkg, Content label) {
        boolean included;
        boolean bl = included = pkg != null && pkg.isIncluded();
        if (!included) {
            PackageDoc[] packages = this.configuration.packages;
            for (int i = 0; i < packages.length; ++i) {
                if (!packages[i].equals(pkg)) continue;
                included = true;
                break;
            }
        }
        if (included || pkg == null) {
            return this.getHyperLink(this.pathString(pkg, "package-summary.html"), "", label);
        }
        String crossPkgLink = this.getCrossPackageLink(Util.getPackageName(pkg));
        if (crossPkgLink != null) {
            return this.getHyperLink(crossPkgLink, "", label);
        }
        return label;
    }

    public String italicsClassName(ClassDoc cd, boolean qual) {
        String name = qual ? cd.qualifiedName() : cd.name();
        return cd.isInterface() ? this.italicsText(name) : name;
    }

    public void printSrcLink(ProgramElementDoc d, String label) {
        if (d == null) {
            return;
        }
        ClassDoc cd = d.containingClass();
        if (cd == null) {
            cd = (ClassDoc)d;
        }
        String href = this.relativePath + "src-html/" + DirectoryManager.getDirectoryPath(cd.containingPackage()) + cd.name() + ".html#" + SourceToHTMLConverter.getAnchorName((Doc)d);
        this.printHyperLink(href, "", label, true);
    }

    public void addSrcLink(ProgramElementDoc doc, Content label, Content htmltree) {
        if (doc == null) {
            return;
        }
        ClassDoc cd = doc.containingClass();
        if (cd == null) {
            cd = (ClassDoc)doc;
        }
        String href = this.relativePath + "src-html/" + DirectoryManager.getDirectoryPath(cd.containingPackage()) + cd.name() + ".html#" + SourceToHTMLConverter.getAnchorName((Doc)doc);
        Content linkContent = this.getHyperLink(href, "", label, "", "");
        htmltree.addContent(linkContent);
    }

    public String getLink(LinkInfoImpl linkInfo) {
        LinkFactoryImpl factory = new LinkFactoryImpl(this);
        String link = ((LinkOutputImpl)factory.getLinkOutput(linkInfo)).toString();
        this.displayLength += linkInfo.displayLength;
        return link;
    }

    public String getTypeParameterLinks(LinkInfoImpl linkInfo) {
        LinkFactoryImpl factory = new LinkFactoryImpl(this);
        return ((LinkOutputImpl)factory.getTypeParameterLinks(linkInfo, false)).toString();
    }

    public void printLink(LinkInfoImpl linkInfo) {
        this.print(this.getLink(linkInfo));
    }

    public String getCrossClassLink(String qualifiedClassName, String refMemName, String label, boolean strong, String style, boolean code) {
        int periodIndex;
        String packageName;
        String className = "";
        String string = packageName = qualifiedClassName == null ? "" : qualifiedClassName;
        while ((periodIndex = packageName.lastIndexOf(46)) != -1) {
            String defaultLabel;
            className = packageName.substring(periodIndex + 1, packageName.length()) + (className.length() > 0 ? "." + className : "");
            String string2 = defaultLabel = code ? this.getCode() + className + this.getCodeEnd() : className;
            if (this.getCrossPackageLink(packageName = packageName.substring(0, periodIndex)) == null) continue;
            return this.getHyperLinkString(this.configuration.extern.getExternalLink(packageName, this.relativePath, className + ".html?is-external=true"), refMemName == null ? "" : refMemName, label == null || label.length() == 0 ? defaultLabel : label, strong, style, this.configuration.getText("doclet.Href_Class_Or_Interface_Title", packageName), "");
        }
        return null;
    }

    public boolean isClassLinkable(ClassDoc cd) {
        if (cd.isIncluded()) {
            return this.configuration.isGeneratedDoc(cd);
        }
        return this.configuration.extern.isExternal((ProgramElementDoc)cd);
    }

    public String getCrossPackageLink(String pkgName) {
        return this.configuration.extern.getExternalLink(pkgName, this.relativePath, "package-summary.html?is-external=true");
    }

    public Content getQualifiedClassLink(int context, ClassDoc cd) {
        return new RawHtml(this.getLink(new LinkInfoImpl(context, cd, this.configuration.getClassName(cd), "")));
    }

    public void addPreQualifiedClassLink(int context, ClassDoc cd, Content contentTree) {
        this.addPreQualifiedClassLink(context, cd, false, contentTree);
    }

    public String getPreQualifiedClassLink(int context, ClassDoc cd, boolean isStrong) {
        String classlink = "";
        PackageDoc pd = cd.containingPackage();
        if (pd != null && !this.configuration.shouldExcludeQualifier(pd.name())) {
            classlink = this.getPkgName(cd);
        }
        classlink = classlink + this.getLink(new LinkInfoImpl(context, cd, cd.name(), isStrong));
        return classlink;
    }

    public void addPreQualifiedClassLink(int context, ClassDoc cd, boolean isStrong, Content contentTree) {
        PackageDoc pd = cd.containingPackage();
        if (pd != null && !this.configuration.shouldExcludeQualifier(pd.name())) {
            contentTree.addContent(this.getPkgName(cd));
        }
        contentTree.addContent(new RawHtml(this.getLink(new LinkInfoImpl(context, cd, cd.name(), isStrong))));
    }

    public void addPreQualifiedStrongClassLink(int context, ClassDoc cd, Content contentTree) {
        this.addPreQualifiedClassLink(context, cd, true, contentTree);
    }

    public void printText(String key) {
        this.print(this.configuration.getText(key));
    }

    public void printText(String key, String a1) {
        this.print(this.configuration.getText(key, a1));
    }

    public void printText(String key, String a1, String a2) {
        this.print(this.configuration.getText(key, a1, a2));
    }

    public void strongText(String key) {
        this.strong(this.configuration.getText(key));
    }

    public void strongText(String key, String a1) {
        this.strong(this.configuration.getText(key, a1));
    }

    public void strongText(String key, String a1, String a2) {
        this.strong(this.configuration.getText(key, a1, a2));
    }

    public Content getDocLink(int context, MemberDoc doc, String label) {
        return this.getDocLink(context, doc.containingClass(), doc, label);
    }

    public void printDocLink(int context, ClassDoc classDoc, MemberDoc doc, String label, boolean strong) {
        this.printDocLink(context, classDoc, doc, label, strong, false);
    }

    public void printDocLink(int context, ClassDoc classDoc, MemberDoc doc, String label, boolean strong, boolean isProperty) {
        this.print(this.getDocLink(context, classDoc, doc, label, strong, isProperty));
    }

    public String getDocLink(int context, MemberDoc doc, String label, boolean strong) {
        return this.getDocLink(context, doc.containingClass(), doc, label, strong);
    }

    public String getDocLink(int context, ClassDoc classDoc, MemberDoc doc, String label, boolean strong) {
        return this.getDocLink(context, classDoc, doc, label, strong, false);
    }

    public String getDocLink(int context, ClassDoc classDoc, MemberDoc doc, String label, boolean strong, boolean isProperty) {
        if (!doc.isIncluded() && !Util.isLinkable(classDoc, this.configuration())) {
            return label;
        }
        if (doc instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc emd = (ExecutableMemberDoc)doc;
            return this.getLink(new LinkInfoImpl(context, classDoc, this.getAnchor(emd, isProperty), label, strong));
        }
        if (doc instanceof MemberDoc) {
            return this.getLink(new LinkInfoImpl(context, classDoc, doc.name(), label, strong));
        }
        return label;
    }

    public Content getDocLink(int context, ClassDoc classDoc, MemberDoc doc, String label) {
        if (!doc.isIncluded() && !Util.isLinkable(classDoc, this.configuration())) {
            return new StringContent(label);
        }
        if (doc instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc emd = (ExecutableMemberDoc)doc;
            return new RawHtml(this.getLink(new LinkInfoImpl(context, classDoc, this.getAnchor(emd), label, false)));
        }
        if (doc instanceof MemberDoc) {
            return new RawHtml(this.getLink(new LinkInfoImpl(context, classDoc, doc.name(), label, false)));
        }
        return new StringContent(label);
    }

    public void anchor(ExecutableMemberDoc emd) {
        this.anchor(this.getAnchor(emd));
    }

    public String getAnchor(ExecutableMemberDoc emd) {
        return this.getAnchor(emd, false);
    }

    public String getAnchor(ExecutableMemberDoc emd, boolean isProperty) {
        if (isProperty) {
            return emd.name();
        }
        StringBuilder signature = new StringBuilder(emd.signature());
        StringBuilder signatureParsed = new StringBuilder();
        int counter = 0;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '<') {
                ++counter;
                continue;
            }
            if (c == '>') {
                --counter;
                continue;
            }
            if (counter != 0) continue;
            signatureParsed.append(c);
        }
        return emd.name() + signatureParsed.toString();
    }

    public String seeTagToString(SeeTag see) {
        String tagName = see.name();
        if (!tagName.startsWith("@link") && !tagName.equals("@see")) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        boolean isplaintext = tagName.toLowerCase().equals("@linkplain");
        String label = see.label();
        label = label.length() > 0 ? (isplaintext ? label : this.getCode() + label + this.getCodeEnd()) : "";
        String seetext = this.replaceDocRootDir(see.text());
        if (seetext.startsWith("<") || seetext.startsWith("\"")) {
            result.append(seetext);
            return result.toString();
        }
        String text = isplaintext ? seetext : this.getCode() + seetext + this.getCodeEnd();
        ClassDoc refClass = see.referencedClass();
        String refClassName = see.referencedClassName();
        MemberDoc refMem = see.referencedMember();
        String refMemName = see.referencedMemberName();
        if (refClass == null) {
            PackageDoc refPackage = see.referencedPackage();
            if (refPackage != null && refPackage.isIncluded()) {
                String packageName = isplaintext ? refPackage.name() : this.getCode() + refPackage.name() + this.getCodeEnd();
                result.append(this.getPackageLinkString(refPackage, label.length() == 0 ? packageName : label, false));
            } else {
                String packageCrossLink = this.getCrossPackageLink(refClassName);
                if (packageCrossLink != null) {
                    result.append(this.getHyperLinkString(packageCrossLink, "", label.length() == 0 ? text : label, false));
                } else {
                    String classCrossLink = this.getCrossClassLink(refClassName, refMemName, label, false, "", !isplaintext);
                    if (classCrossLink != null) {
                        result.append(classCrossLink);
                    } else {
                        this.configuration.getDocletSpecificMsg().warning(see.position(), "doclet.see.class_or_package_not_found", tagName, seetext);
                        result.append(label.length() == 0 ? text : label);
                    }
                }
            }
        } else if (refMemName == null) {
            if (label.length() == 0) {
                label = isplaintext ? refClass.name() : this.getCode() + refClass.name() + this.getCodeEnd();
                result.append(this.getLink(new LinkInfoImpl(refClass, label)));
            } else {
                result.append(this.getLink(new LinkInfoImpl(refClass, label)));
            }
        } else if (refMem == null) {
            result.append(label.length() == 0 ? text : label);
        } else {
            int index;
            ClassDoc containing = refMem.containingClass();
            if (see.text().trim().startsWith("#") && !containing.isPublic() && !Util.isLinkable(containing, this.configuration())) {
                if (this instanceof ClassWriterImpl) {
                    containing = ((ClassWriterImpl)this).getClassDoc();
                } else if (!containing.isPublic()) {
                    this.configuration.getDocletSpecificMsg().warning(see.position(), "doclet.see.class_or_package_not_accessible", tagName, containing.qualifiedName());
                } else {
                    this.configuration.getDocletSpecificMsg().warning(see.position(), "doclet.see.class_or_package_not_found", tagName, seetext);
                }
            }
            if (this.configuration.currentcd != containing) {
                refMemName = containing.name() + "." + refMemName;
            }
            if (refMem instanceof ExecutableMemberDoc && refMemName.indexOf(40) < 0) {
                refMemName = refMemName + ((ExecutableMemberDoc)refMem).signature();
            }
            if (Configuration.javafxJavadoc && (index = refMemName.indexOf("<")) != -1) {
                refMemName = refMemName.substring(0, index) + ")";
            }
            text = isplaintext ? refMemName : this.getCode() + Util.escapeHtmlChars(refMemName) + this.getCodeEnd();
            result.append(this.getDocLink(10, containing, refMem, label.length() == 0 ? text : label, false));
        }
        return result.toString();
    }

    public void printInlineComment(Doc doc, Tag tag) {
        this.printCommentTags(doc, tag.inlineTags(), false, false);
    }

    public void addInlineComment(Doc doc, Tag tag, Content htmltree) {
        this.addCommentTags(doc, tag.inlineTags(), false, false, htmltree);
    }

    public void printInlineDeprecatedComment(Doc doc, Tag tag) {
        this.printCommentTags(doc, tag.inlineTags(), true, false);
    }

    public void addInlineDeprecatedComment(Doc doc, Tag tag, Content htmltree) {
        this.addCommentTags(doc, tag.inlineTags(), true, false, htmltree);
    }

    public void printSummaryComment(Doc doc) {
        this.printSummaryComment(doc, doc.firstSentenceTags());
    }

    public void addSummaryComment(Doc doc, Content htmltree) {
        this.addSummaryComment(doc, doc.firstSentenceTags(), htmltree);
    }

    public void printSummaryComment(Doc doc, Tag[] firstSentenceTags) {
        this.printCommentTags(doc, firstSentenceTags, false, true);
    }

    public void addSummaryComment(Doc doc, Tag[] firstSentenceTags, Content htmltree) {
        this.addCommentTags(doc, firstSentenceTags, false, true, htmltree);
    }

    public void printSummaryDeprecatedComment(Doc doc) {
        this.printCommentTags(doc, doc.firstSentenceTags(), true, true);
    }

    public void printSummaryDeprecatedComment(Doc doc, Tag tag) {
        this.printCommentTags(doc, tag.firstSentenceTags(), true, true);
    }

    public void addSummaryDeprecatedComment(Doc doc, Tag tag, Content htmltree) {
        this.addCommentTags(doc, tag.firstSentenceTags(), true, true, htmltree);
    }

    public void printInlineComment(Doc doc) {
        this.printCommentTags(doc, doc.inlineTags(), false, false);
        this.p();
    }

    public void addInlineComment(Doc doc, Content htmltree) {
        this.addCommentTags(doc, doc.inlineTags(), false, false, htmltree);
    }

    public void printInlineDeprecatedComment(Doc doc) {
        this.printCommentTags(doc, doc.inlineTags(), true, false);
    }

    private void printCommentTags(Doc doc, Tag[] tags, boolean depr, boolean first) {
        if (this.configuration.nocomment) {
            return;
        }
        if (depr) {
            this.italic();
        }
        String result = this.commentTagsToString(null, doc, tags, first);
        this.print(result);
        if (depr) {
            this.italicEnd();
        }
        if (tags.length == 0) {
            this.space();
        }
    }

    private void addCommentTags(Doc doc, Tag[] tags, boolean depr, boolean first, Content htmltree) {
        if (this.configuration.nocomment) {
            return;
        }
        RawHtml result = new RawHtml(this.commentTagsToString(null, doc, tags, first));
        if (depr) {
            HtmlTree italic = HtmlTree.I(result);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, italic);
            htmltree.addContent(div);
        } else {
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, result);
            htmltree.addContent(div);
        }
        if (tags.length == 0) {
            htmltree.addContent(this.getSpace());
        }
    }

    public String commentTagsToString(Tag holderTag, Doc doc, Tag[] tags, boolean isFirstSentence) {
        StringBuilder result = new StringBuilder();
        boolean textTagChange = false;
        this.configuration.tagletManager.checkTags(doc, tags, true);
        for (int i = 0; i < tags.length; ++i) {
            Tag tagelem = tags[i];
            String tagName = tagelem.name();
            if (tagelem instanceof SeeTag) {
                result.append(this.seeTagToString((SeeTag)tagelem));
                continue;
            }
            if (!tagName.equals("Text")) {
                int originalLength = result.length();
                TagletOutput output = TagletWriter.getInlineTagOuput(this.configuration.tagletManager, holderTag, tagelem, this.getTagletWriterInstance(isFirstSentence));
                result.append(output == null ? "" : output.toString());
                if (originalLength == 0 && isFirstSentence && tagelem.name().equals("@inheritDoc") && result.length() > 0) break;
                if (this.configuration.docrootparent.length() <= 0 || !tagelem.name().equals("@docRoot") || !tags[i + 1].text().startsWith("/..")) continue;
                textTagChange = true;
                continue;
            }
            String text = tagelem.text();
            if (textTagChange) {
                text = text.replaceFirst("/..", "");
                textTagChange = false;
            }
            text = this.redirectRelativeLinks(tagelem.holder(), text);
            text = this.replaceDocRootDir(text);
            if (isFirstSentence) {
                text = this.removeNonInlineHtmlTags(text);
            }
            StringTokenizer lines = new StringTokenizer(text, "\r\n", true);
            StringBuffer textBuff = new StringBuffer();
            while (lines.hasMoreTokens()) {
                StringBuilder line = new StringBuilder(lines.nextToken());
                Util.replaceTabs(this.configuration.sourcetab, line);
                textBuff.append(line.toString());
            }
            result.append(textBuff);
        }
        return result.toString();
    }

    private boolean shouldNotRedirectRelativeLinks() {
        return this instanceof AnnotationTypeWriter || this instanceof ClassWriter || this instanceof PackageSummaryWriter;
    }

    private String redirectRelativeLinks(Doc doc, String text) {
        int begin;
        String redirectPathFromRoot;
        if (doc == null || this.shouldNotRedirectRelativeLinks()) {
            return text;
        }
        if (doc instanceof ClassDoc) {
            redirectPathFromRoot = DirectoryManager.getDirectoryPath(((ClassDoc)doc).containingPackage());
        } else if (doc instanceof MemberDoc) {
            redirectPathFromRoot = DirectoryManager.getDirectoryPath(((MemberDoc)doc).containingPackage());
        } else if (doc instanceof PackageDoc) {
            redirectPathFromRoot = DirectoryManager.getDirectoryPath((PackageDoc)doc);
        } else {
            return text;
        }
        if (!redirectPathFromRoot.endsWith("/")) {
            redirectPathFromRoot = redirectPathFromRoot + "/";
        }
        if ((begin = text.toLowerCase().indexOf("<a")) >= 0) {
            StringBuffer textBuff = new StringBuffer(text);
            while (begin >= 0) {
                String relativeLink;
                if (textBuff.length() > begin + 2 && !Character.isWhitespace(textBuff.charAt(begin + 2))) {
                    begin = textBuff.toString().toLowerCase().indexOf("<a", begin + 1);
                    continue;
                }
                begin = textBuff.indexOf("=", begin) + 1;
                int end = textBuff.indexOf(">", begin + 1);
                if (begin == 0) {
                    this.configuration.root.printWarning(doc.position(), this.configuration.getText("doclet.malformed_html_link_tag", text));
                    break;
                }
                if (end == -1) break;
                if (textBuff.substring(begin, end).indexOf("\"") != -1) {
                    begin = textBuff.indexOf("\"", begin) + 1;
                    end = textBuff.indexOf("\"", begin + 1);
                    if (begin == 0 || end == -1) break;
                }
                if (!((relativeLink = textBuff.substring(begin, end)).toLowerCase().startsWith("mailto:") || relativeLink.toLowerCase().startsWith("http:") || relativeLink.toLowerCase().startsWith("https:") || relativeLink.toLowerCase().startsWith("file:"))) {
                    relativeLink = "{@" + new DocRootTaglet().getName() + "}" + redirectPathFromRoot + relativeLink;
                    textBuff.replace(begin, end, relativeLink);
                }
                begin = textBuff.toString().toLowerCase().indexOf("<a", begin + 1);
            }
            return textBuff.toString();
        }
        return text;
    }

    public String removeNonInlineHtmlTags(String text) {
        if (text.indexOf(60) < 0) {
            return text;
        }
        String[] noninlinetags = new String[]{"<ul>", "</ul>", "<ol>", "</ol>", "<dl>", "</dl>", "<table>", "</table>", "<tr>", "</tr>", "<td>", "</td>", "<th>", "</th>", "<p>", "</p>", "<li>", "</li>", "<dd>", "</dd>", "<dir>", "</dir>", "<dt>", "</dt>", "<h1>", "</h1>", "<h2>", "</h2>", "<h3>", "</h3>", "<h4>", "</h4>", "<h5>", "</h5>", "<h6>", "</h6>", "<pre>", "</pre>", "<menu>", "</menu>", "<listing>", "</listing>", "<hr>", "<blockquote>", "</blockquote>", "<center>", "</center>", "<UL>", "</UL>", "<OL>", "</OL>", "<DL>", "</DL>", "<TABLE>", "</TABLE>", "<TR>", "</TR>", "<TD>", "</TD>", "<TH>", "</TH>", "<P>", "</P>", "<LI>", "</LI>", "<DD>", "</DD>", "<DIR>", "</DIR>", "<DT>", "</DT>", "<H1>", "</H1>", "<H2>", "</H2>", "<H3>", "</H3>", "<H4>", "</H4>", "<H5>", "</H5>", "<H6>", "</H6>", "<PRE>", "</PRE>", "<MENU>", "</MENU>", "<LISTING>", "</LISTING>", "<HR>", "<BLOCKQUOTE>", "</BLOCKQUOTE>", "<CENTER>", "</CENTER>"};
        for (int i = 0; i < noninlinetags.length; ++i) {
            text = this.replace(text, noninlinetags[i], "");
        }
        return text;
    }

    public String replace(String text, String tobe, String by) {
        int startindex;
        while ((startindex = text.indexOf(tobe)) >= 0) {
            int endindex = startindex + tobe.length();
            StringBuilder replaced = new StringBuilder();
            if (startindex > 0) {
                replaced.append(text.substring(0, startindex));
            }
            replaced.append(by);
            if (text.length() > endindex) {
                replaced.append(text.substring(endindex));
            }
            text = replaced.toString();
        }
        return text;
    }

    public void printStyleSheetProperties() {
        File stylefile;
        String parent;
        String filename = this.configuration.stylesheetfile;
        filename = filename.length() > 0 ? ((parent = (stylefile = new File(filename)).getParent()) == null ? filename : filename.substring(parent.length() + 1)) : "stylesheet.css";
        filename = this.relativePath + filename;
        this.link("REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"" + filename + "\" " + "TITLE=\"Style\"");
    }

    public HtmlTree getStyleSheetProperties() {
        File stylefile;
        String parent;
        String filename = this.configuration.stylesheetfile;
        filename = filename.length() > 0 ? ((parent = (stylefile = new File(filename)).getParent()) == null ? filename : filename.substring(parent.length() + 1)) : "stylesheet.css";
        filename = this.relativePath + filename;
        HtmlTree link = HtmlTree.LINK("stylesheet", "text/css", filename, "Style");
        return link;
    }

    public boolean isCoreClass(ClassDoc cd) {
        return cd.containingClass() == null || cd.isStatic();
    }

    public void writeAnnotationInfo(PackageDoc packageDoc) {
        this.writeAnnotationInfo((Doc)packageDoc, packageDoc.annotations());
    }

    public void addAnnotationInfo(PackageDoc packageDoc, Content htmltree) {
        this.addAnnotationInfo((Doc)packageDoc, packageDoc.annotations(), htmltree);
    }

    public void writeAnnotationInfo(ProgramElementDoc doc) {
        this.writeAnnotationInfo((Doc)doc, doc.annotations());
    }

    public void addAnnotationInfo(ProgramElementDoc doc, Content htmltree) {
        this.addAnnotationInfo((Doc)doc, doc.annotations(), htmltree);
    }

    public boolean writeAnnotationInfo(int indent, Doc doc, Parameter param) {
        return this.writeAnnotationInfo(indent, doc, param.annotations(), false);
    }

    public boolean addAnnotationInfo(int indent, Doc doc, Parameter param, Content tree) {
        return this.addAnnotationInfo(indent, doc, param.annotations(), false, tree);
    }

    private void writeAnnotationInfo(Doc doc, AnnotationDesc[] descList) {
        this.writeAnnotationInfo(0, doc, descList, true);
    }

    private void addAnnotationInfo(Doc doc, AnnotationDesc[] descList, Content htmltree) {
        this.addAnnotationInfo(0, doc, descList, true, htmltree);
    }

    private boolean writeAnnotationInfo(int indent, Doc doc, AnnotationDesc[] descList, boolean lineBreak) {
        List<String> annotations = this.getAnnotations(indent, descList, lineBreak);
        if (annotations.size() == 0) {
            return false;
        }
        this.fontNoNewLine("-1");
        Iterator<String> iter = annotations.iterator();
        while (iter.hasNext()) {
            this.print(iter.next());
        }
        this.fontEnd();
        return true;
    }

    private boolean addAnnotationInfo(int indent, Doc doc, AnnotationDesc[] descList, boolean lineBreak, Content htmltree) {
        List<String> annotations = this.getAnnotations(indent, descList, lineBreak);
        if (annotations.size() == 0) {
            return false;
        }
        Iterator<String> iter = annotations.iterator();
        while (iter.hasNext()) {
            RawHtml annotationContent = new RawHtml(iter.next());
            htmltree.addContent(annotationContent);
        }
        return true;
    }

    private List<String> getAnnotations(int indent, AnnotationDesc[] descList, boolean linkBreak) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < descList.length; ++i) {
            AnnotationTypeDoc annotationDoc = descList[i].annotationType();
            if (!Util.isDocumentedAnnotation(annotationDoc)) continue;
            StringBuffer annotation = new StringBuffer();
            LinkInfoImpl linkInfo = new LinkInfoImpl(29, (Type)annotationDoc);
            linkInfo.label = "@" + annotationDoc.name();
            annotation.append(this.getLink(linkInfo));
            AnnotationDesc.ElementValuePair[] pairs = descList[i].elementValues();
            if (pairs.length > 0) {
                annotation.append('(');
                for (int j = 0; j < pairs.length; ++j) {
                    if (j > 0) {
                        annotation.append(",");
                        if (linkBreak) {
                            annotation.append(DocletConstants.NL);
                            int spaces = annotationDoc.name().length() + 2;
                            for (int k = 0; k < spaces + indent; ++k) {
                                annotation.append(' ');
                            }
                        }
                    }
                    annotation.append(this.getDocLink(29, (MemberDoc)pairs[j].element(), pairs[j].element().name(), false));
                    annotation.append('=');
                    AnnotationValue annotationValue = pairs[j].value();
                    ArrayList<AnnotationValue> annotationTypeValues = new ArrayList<AnnotationValue>();
                    if (annotationValue.value() instanceof AnnotationValue[]) {
                        AnnotationValue[] annotationArray = (AnnotationValue[])annotationValue.value();
                        for (int k = 0; k < annotationArray.length; ++k) {
                            annotationTypeValues.add(annotationArray[k]);
                        }
                    } else {
                        annotationTypeValues.add(annotationValue);
                    }
                    annotation.append(annotationTypeValues.size() == 1 ? "" : "{");
                    Iterator iter = annotationTypeValues.iterator();
                    while (iter.hasNext()) {
                        annotation.append(this.annotationValueToString((AnnotationValue)iter.next()));
                        annotation.append(iter.hasNext() ? "," : "");
                    }
                    annotation.append(annotationTypeValues.size() == 1 ? "" : "}");
                }
                annotation.append(")");
            }
            annotation.append(linkBreak ? DocletConstants.NL : "");
            results.add(annotation.toString());
        }
        return results;
    }

    private String annotationValueToString(AnnotationValue annotationValue) {
        if (annotationValue.value() instanceof Type) {
            Type type = (Type)annotationValue.value();
            if (type.asClassDoc() != null) {
                LinkInfoImpl linkInfo = new LinkInfoImpl(29, type);
                linkInfo.label = (type.asClassDoc().isIncluded() ? type.typeName() : type.qualifiedTypeName()) + type.dimension() + ".class";
                return this.getLink(linkInfo);
            }
            return type.typeName() + type.dimension() + ".class";
        }
        if (annotationValue.value() instanceof AnnotationDesc) {
            List<String> list = this.getAnnotations(0, new AnnotationDesc[]{(AnnotationDesc)annotationValue.value()}, false);
            StringBuffer buf = new StringBuffer();
            Iterator<String> iter = list.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
            }
            return buf.toString();
        }
        if (annotationValue.value() instanceof MemberDoc) {
            return this.getDocLink(29, (MemberDoc)annotationValue.value(), ((MemberDoc)annotationValue.value()).name(), false);
        }
        return annotationValue.toString();
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }
}

