/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractMemberWriter;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.ClassWriter;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.builders.MemberSummaryBuilder;
import com.javafx.tools.doclets.internal.toolkit.taglets.ParamTaglet;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.javafx.tools.doclets.internal.toolkit.util.ClassTree;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.DocletConstants;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassWriterImpl
extends SubWriterHolderWriter
implements ClassWriter {
    protected ClassDoc classDoc;
    protected ClassTree classtree;
    protected ClassDoc prev;
    protected ClassDoc next;

    public ClassWriterImpl(ClassDoc classDoc, ClassDoc prevClass, ClassDoc nextClass, ClassTree classTree) throws Exception {
        super(ConfigurationImpl.getInstance(), DirectoryManager.getDirectoryPath(classDoc.containingPackage()), classDoc.name() + ".html", DirectoryManager.getRelativePath(classDoc.containingPackage().name()));
        this.classDoc = classDoc;
        this.configuration.currentcd = classDoc;
        this.classtree = classTree;
        this.prev = prevClass;
        this.next = nextClass;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink("package-summary.html", "", this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClass() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.classLabel);
        return li;
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content linkContent = this.getHyperLink("class-use/" + this.filename, "", this.useLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev != null) {
            RawHtml prevLink = new RawHtml(this.getLink(new LinkInfoImpl(2, this.prev, "", this.configuration.getText("doclet.Prev_Class"), true)));
            li = HtmlTree.LI(prevLink);
        } else {
            li = HtmlTree.LI(this.prevclassLabel);
        }
        return li;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next != null) {
            RawHtml nextLink = new RawHtml(this.getLink(new LinkInfoImpl(2, this.next, "", this.configuration.getText("doclet.Next_Class"), true)));
            li = HtmlTree.LI(nextLink);
        } else {
            li = HtmlTree.LI(this.nextclassLabel);
        }
        return li;
    }

    @Override
    public Content getHeader(String header) {
        String pkgname = this.classDoc.containingPackage() != null ? this.classDoc.containingPackage().name() : "";
        String clname = this.classDoc.name();
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(clname));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        ((Content)bodyTree).addContent(HtmlConstants.START_OF_CLASS_DATA);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        if (pkgname.length() > 0) {
            StringContent pkgNameContent = new StringContent(pkgname);
            HtmlTree pkgNameDiv = HtmlTree.DIV(HtmlStyle.subTitle, pkgNameContent);
            div.addContent(pkgNameDiv);
        }
        LinkInfoImpl linkInfo = new LinkInfoImpl(14, this.classDoc, false);
        linkInfo.linkToSelf = false;
        StringContent headerContent = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, headerContent);
        ((Content)heading).addContent(new RawHtml(this.getTypeParameterLinks(linkInfo)));
        div.addContent(heading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    @Override
    public Content getClassContentHeader() {
        return this.getContentHeader();
    }

    @Override
    public void addFooter(Content contentTree) {
        contentTree.addContent(HtmlConstants.END_OF_CLASS_DATA);
        this.addNavLinks(false, contentTree);
        this.addBottom(contentTree);
    }

    @Override
    public void printDocument(Content contentTree) {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.classDoc), true, contentTree);
    }

    @Override
    public Content getClassInfoTreeHeader() {
        return this.getMemberTreeHeader();
    }

    @Override
    public Content getClassInfo(Content classInfoTree) {
        return this.getMemberTree(HtmlStyle.description, classInfoTree);
    }

    @Override
    public void addClassSignature(String modifiers, Content classInfoTree) {
        Type[] implIntfacs;
        Type superclass;
        boolean isInterface = this.classDoc.isInterface();
        classInfoTree.addContent(new HtmlTree(HtmlTag.BR));
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.addAnnotationInfo((ProgramElementDoc)this.classDoc, (Content)pre);
        ((Content)pre).addContent(modifiers);
        LinkInfoImpl linkInfo = new LinkInfoImpl(15, this.classDoc, false);
        linkInfo.linkToSelf = false;
        StringContent className = new StringContent(this.classDoc.name());
        RawHtml parameterLinks = new RawHtml(this.getTypeParameterLinks(linkInfo));
        if (this.configuration().linksource) {
            this.addSrcLink((ProgramElementDoc)this.classDoc, className, pre);
            ((Content)pre).addContent(parameterLinks);
        } else {
            HtmlTree span = HtmlTree.SPAN(HtmlStyle.strong, className);
            ((Content)span).addContent(parameterLinks);
            ((Content)pre).addContent(span);
        }
        if (!isInterface && (superclass = Util.getFirstVisibleSuperClass(this.classDoc, this.configuration())) != null) {
            ((Content)pre).addContent(DocletConstants.NL);
            ((Content)pre).addContent("extends ");
            RawHtml link = new RawHtml(this.getLink(new LinkInfoImpl(24, superclass)));
            ((Content)pre).addContent(link);
        }
        if ((implIntfacs = this.classDoc.interfaceTypes()) != null && implIntfacs.length > 0) {
            int counter = 0;
            for (int i = 0; i < implIntfacs.length; ++i) {
                ClassDoc classDoc = implIntfacs[i].asClassDoc();
                if (!classDoc.isPublic() && !Util.isLinkable(classDoc, this.configuration())) continue;
                if (counter == 0) {
                    ((Content)pre).addContent(DocletConstants.NL);
                    ((Content)pre).addContent(isInterface ? "extends " : "implements ");
                } else {
                    ((Content)pre).addContent(", ");
                }
                RawHtml link = new RawHtml(this.getLink(new LinkInfoImpl(24, implIntfacs[i])));
                ((Content)pre).addContent(link);
                ++counter;
            }
        }
        classInfoTree.addContent(pre);
    }

    @Override
    public void addClassDescription(Content classInfoTree) {
        if (!this.configuration.nocomment && this.classDoc.inlineTags().length > 0) {
            this.addInlineComment((Doc)this.classDoc, classInfoTree);
        }
    }

    @Override
    public void addClassTagInfo(Content classInfoTree) {
        if (!this.configuration.nocomment) {
            this.addTagsInfo((Doc)this.classDoc, classInfoTree);
        }
    }

    private Content getClassInheritenceTree(Type type) {
        Type sup;
        HtmlTree classTreeUl = new HtmlTree(HtmlTag.UL);
        classTreeUl.addStyle(HtmlStyle.inheritance);
        HtmlTree liTree = null;
        do {
            if ((sup = Util.getFirstVisibleSuperClass(type instanceof ClassDoc ? (ClassDoc)type : type.asClassDoc(), this.configuration())) != null) {
                HtmlTree li;
                HtmlTree ul = new HtmlTree(HtmlTag.UL);
                ul.addStyle(HtmlStyle.inheritance);
                ul.addContent(this.getTreeForClassHelper(type));
                if (liTree != null) {
                    ul.addContent(liTree);
                }
                liTree = li = HtmlTree.LI(ul);
                type = sup;
                continue;
            }
            classTreeUl.addContent(this.getTreeForClassHelper(type));
        } while (sup != null);
        if (liTree != null) {
            classTreeUl.addContent(liTree);
        }
        return classTreeUl;
    }

    private Content getTreeForClassHelper(Type type) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        if (type.equals(this.classDoc)) {
            String typeParameters = this.getTypeParameterLinks(new LinkInfoImpl(12, this.classDoc, false));
            if (this.configuration.shouldExcludeQualifier(this.classDoc.containingPackage().name())) {
                ((Content)li).addContent(type.asClassDoc().name());
                ((Content)li).addContent(new RawHtml(typeParameters));
            } else {
                ((Content)li).addContent(type.asClassDoc().qualifiedName());
                ((Content)li).addContent(new RawHtml(typeParameters));
            }
        } else {
            RawHtml link = new RawHtml(this.getLink(new LinkInfoImpl(31, (Type)(type instanceof ClassDoc ? (ClassDoc)type : type), this.configuration.getClassName(type.asClassDoc()), false)));
            ((Content)li).addContent(link);
        }
        return li;
    }

    @Override
    public void addClassTree(Content classContentTree) {
        if (!this.classDoc.isClass()) {
            return;
        }
        classContentTree.addContent(this.getClassInheritenceTree((Type)this.classDoc));
    }

    @Override
    public void addTypeParamInfo(Content classInfoTree) {
        if (this.classDoc.typeParamTags().length > 0) {
            TagletOutput output = new ParamTaglet().getTagletOutput((Doc)this.classDoc, this.getTagletWriterInstance(false));
            RawHtml typeParam = new RawHtml(output.toString());
            HtmlTree dl = HtmlTree.DL(typeParam);
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addSubClassInfo(Content classInfoTree) {
        if (this.classDoc.isClass()) {
            if (this.classDoc.qualifiedName().equals("java.lang.Object") || this.classDoc.qualifiedName().equals("org.omg.CORBA.Object")) {
                return;
            }
            List<ClassDoc> subclasses = this.classtree.subs(this.classDoc, false);
            if (subclasses.size() > 0) {
                Content label = this.getResource("doclet.Subclasses");
                HtmlTree dt = HtmlTree.DT(label);
                HtmlTree dl = HtmlTree.DL(dt);
                ((Content)dl).addContent(this.getClassLinks(23, subclasses));
                classInfoTree.addContent(dl);
            }
        }
    }

    @Override
    public void addSubInterfacesInfo(Content classInfoTree) {
        List<ClassDoc> subInterfaces;
        if (this.classDoc.isInterface() && (subInterfaces = this.classtree.allSubs(this.classDoc, false)).size() > 0) {
            Content label = this.getResource("doclet.Subinterfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(22, subInterfaces));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addInterfaceUsageInfo(Content classInfoTree) {
        if (!this.classDoc.isInterface()) {
            return;
        }
        if (this.classDoc.qualifiedName().equals("java.lang.Cloneable") || this.classDoc.qualifiedName().equals("java.io.Serializable")) {
            return;
        }
        List<ClassDoc> implcl = this.classtree.implementingclasses(this.classDoc);
        if (implcl.size() > 0) {
            Content label = this.getResource("doclet.Implementing_Classes");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(21, implcl));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addImplementedInterfacesInfo(Content classInfoTree) {
        List<Type> interfaceArray = Util.getAllInterfaces((Type)this.classDoc, this.configuration);
        if (this.classDoc.isClass() && interfaceArray.size() > 0) {
            Content label = this.getResource("doclet.All_Implemented_Interfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(20, interfaceArray));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addSuperInterfacesInfo(Content classInfoTree) {
        List<Type> interfaceArray = Util.getAllInterfaces((Type)this.classDoc, this.configuration);
        if (this.classDoc.isInterface() && interfaceArray.size() > 0) {
            Content label = this.getResource("doclet.All_Superinterfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(19, interfaceArray));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addNestedClassInfo(Content classInfoTree) {
        ClassDoc outerClass = this.classDoc.containingClass();
        if (outerClass != null) {
            Content label = outerClass.isInterface() ? this.getResource("doclet.Enclosing_Interface") : this.getResource("doclet.Enclosing_Class");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            HtmlTree dd = new HtmlTree(HtmlTag.DD);
            ((Content)dd).addContent(new RawHtml(this.getLink(new LinkInfoImpl(2, outerClass, false))));
            ((Content)dl).addContent(dd);
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addClassDeprecationInfo(Content classInfoTree) {
        HtmlTree hr = new HtmlTree(HtmlTag.HR);
        classInfoTree.addContent(hr);
        Tag[] deprs = this.classDoc.tags("deprecated");
        if (Util.isDeprecated((Doc)this.classDoc)) {
            Tag[] commentTags;
            HtmlTree strong = HtmlTree.STRONG(this.deprecatedPhrase);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, strong);
            if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                ((Content)div).addContent(this.getSpace());
                this.addInlineDeprecatedComment((Doc)this.classDoc, deprs[0], div);
            }
            classInfoTree.addContent(div);
        }
    }

    private Content getClassLinks(int context, List<?> list) {
        Object[] typeList = list.toArray();
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        for (int i = 0; i < list.size(); ++i) {
            RawHtml link;
            if (i > 0) {
                StringContent separator = new StringContent(", ");
                ((Content)dd).addContent(separator);
            }
            if (typeList[i] instanceof ClassDoc) {
                link = new RawHtml(this.getLink(new LinkInfoImpl(context, (Type)((ClassDoc)typeList[i]))));
                ((Content)dd).addContent(link);
                continue;
            }
            link = new RawHtml(this.getLink(new LinkInfoImpl(context, (Type)typeList[i])));
            ((Content)dd).addContent(link);
        }
        return dd;
    }

    @Override
    protected Content getNavLinkTree() {
        Content treeLinkContent = this.getHyperLink("package-tree.html", "", this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(treeLinkContent);
        return li;
    }

    @Override
    protected void addSummaryDetailLinks(Content subDiv) {
        try {
            HtmlTree div = HtmlTree.DIV(this.getNavSummaryLinks());
            ((Content)div).addContent(this.getNavDetailLinks());
            subDiv.addContent(div);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocletAbortException();
        }
    }

    protected Content getNavSummaryLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.summaryLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        String[] navLinkLabels = new String[]{"doclet.navNested", "doclet.navEnum", "doclet.navField", "doclet.navConstructor", "doclet.navMethod"};
        for (int i = 0; i < navLinkLabels.length; ++i) {
            HtmlTree liNav = new HtmlTree(HtmlTag.LI);
            if (i == 1 && !this.classDoc.isEnum() || i == 3 && this.classDoc.isEnum()) continue;
            AbstractMemberWriter writer = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(i));
            if (writer == null) {
                ((Content)liNav).addContent(this.getResource(navLinkLabels[i]));
            } else {
                writer.addNavSummaryLink(memberSummaryBuilder.members(i), memberSummaryBuilder.getVisibleMemberMap(i), liNav);
            }
            if (i < navLinkLabels.length - 1) {
                this.addNavGap(liNav);
            }
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected Content getNavDetailLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.detailLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        String[] navLinkLabels = new String[]{"doclet.navNested", "doclet.navEnum", "doclet.navField", "doclet.navConstructor", "doclet.navMethod"};
        for (int i = 1; i < navLinkLabels.length; ++i) {
            HtmlTree liNav = new HtmlTree(HtmlTag.LI);
            AbstractMemberWriter writer = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(i));
            if (i == 1 && !this.classDoc.isEnum() || i == 3 && this.classDoc.isEnum()) continue;
            if (writer == null) {
                ((Content)liNav).addContent(this.getResource(navLinkLabels[i]));
            } else {
                writer.addNavDetailLink(memberSummaryBuilder.members(i), (Content)liNav);
            }
            if (i < navLinkLabels.length - 1) {
                this.addNavGap(liNav);
            }
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected void addNavGap(Content liNav) {
        liNav.addContent(this.getSpace());
        liNav.addContent("|");
        liNav.addContent(this.getSpace());
    }

    @Override
    public ClassDoc getClassDoc() {
        return this.classDoc;
    }
}

