/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.operations;

import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.rjmx.ui.attributes.AttributeTreeBuilder;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.rjmx.ui.operations.InvocatorBuilderForm;
import com.jrockit.mc.rjmx.ui.operations.Messages;
import com.jrockit.mc.rjmx.ui.operations.OperationsLabelProvider;
import com.jrockit.mc.rjmx.util.internal.DefaultAttribute;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExecuteOperationForm
extends SashForm {
    private final FormToolkit formToolkit;
    private final IDialogSettings settings;
    private final Text commandText;
    private final CTabFolder results;
    private Button helpButton;
    private final Button invokeButton;
    private final InvocatorBuilderForm invocatorForm;
    private Callable<?> invocator;
    private Callable<?> helpInvocator;
    private final Composite buttonContainer;

    public ExecuteOperationForm(Composite parent, IManagedForm form, FormToolkit formToolkit, String sectionId, boolean showOperationReturnType, boolean showDescriptionBeforeValue, IDialogSettings settings) {
        this(parent, form, formToolkit, sectionId, showOperationReturnType, showDescriptionBeforeValue, settings, null);
    }

    public ExecuteOperationForm(Composite parent, IManagedForm form, FormToolkit formToolkit, String sectionId, boolean showOperationReturnType, boolean showDescriptionBeforeValue, IDialogSettings settings, final HelpProvider helpProvider) {
        super(parent, 512);
        this.formToolkit = formToolkit;
        this.settings = settings;
        this.setBackground(formToolkit.getColors().getBackground());
        Composite upperContainer = formToolkit.createComposite((Composite)this);
        upperContainer.setLayout((Layout)new GridLayout());
        IDialogSettings invocatorFormSettings = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"invocator_builder");
        this.invocatorForm = new InvocatorBuilderForm(upperContainer, formToolkit, showOperationReturnType, showDescriptionBeforeValue, invocatorFormSettings, new InvocatorBuilderForm.InvocatorUpdateListener(){

            @Override
            public void onInvocatorUpdated(IOperation operation, Callable<?> invocator) {
                ExecuteOperationForm.this.invocator = invocator;
                if (helpProvider != null && operation != null) {
                    ExecuteOperationForm.this.helpInvocator = helpProvider.getHelpInvocator(operation);
                    ExecuteOperationForm.this.helpButton.setVisible(operation != null);
                    ExecuteOperationForm.this.invokeButton.setEnabled(ExecuteOperationForm.this.helpInvocator != null);
                }
                ExecuteOperationForm.this.invokeButton.setVisible(operation != null);
                ExecuteOperationForm.this.invokeButton.setEnabled(invocator != null);
                ExecuteOperationForm.this.commandText.setText(invocator == null ? "" : invocator.toString());
                ExecuteOperationForm.this.invokeButton.setImage(OperationsLabelProvider.getOperationIcon(operation));
                ExecuteOperationForm.this.buttonContainer.layout(true);
            }
        });
        this.buttonContainer = formToolkit.createComposite(upperContainer);
        this.buttonContainer.setLayoutData((Object)new GridData(768));
        if (helpProvider != null) {
            this.buttonContainer.setLayout((Layout)new GridLayout(3, false));
            this.helpButton = formToolkit.createButton(this.buttonContainer, Messages.ExecuteOperationForm_HELP_LABEL, 8);
            this.helpButton.setImage(UIPlugin.getDefault().getImage("help.gif"));
            this.helpButton.setVisible(false);
            this.helpButton.setLayoutData((Object)new GridData());
        } else {
            this.buttonContainer.setLayout((Layout)new GridLayout(2, false));
        }
        this.invokeButton = formToolkit.createButton(this.buttonContainer, Messages.ExecuteOperationForm_EXECUTE_BUTTON_TEXT, 8);
        this.invokeButton.setVisible(false);
        this.invokeButton.setLayoutData((Object)new GridData());
        this.commandText = new Text(this.buttonContainer, 72);
        this.commandText.setBackground(formToolkit.getColors().getBackground());
        this.commandText.setLayoutData((Object)new GridData(768));
        this.results = new CTabFolder((Composite)this, 262208);
        this.results.setBackground(formToolkit.getColors().getBackground());
        this.results.setVisible(false);
        this.results.setData("name", (Object)"operation.result");
        this.results.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (ExecuteOperationForm.this.results.getItemCount() <= 1) {
                    ExecuteOperationForm.this.results.setVisible(false);
                    ExecuteOperationForm.this.layout();
                }
            }
        });
        this.addResultsContextMenu();
        this.setWeights(new int[]{2, 1});
        this.invokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecuteOperationForm.this.invokeAsync(ExecuteOperationForm.this.invocator);
            }
        });
        if (helpProvider != null) {
            this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecuteOperationForm.this.invokeAsync(ExecuteOperationForm.this.helpInvocator);
                }
            });
        }
    }

    private void invokeAsync(final Callable<?> job) {
        final String resultTitle = NLS.bind((String)Messages.ExecuteOperationForm_RESULT_MSG, (Object)DateFormat.getDateTimeInstance(3, 2).format(new Date()), this.invocator);
        new Job(job.toString()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final Object result = job.call();
                    if (!monitor.isCanceled()) {
                        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!ExecuteOperationForm.this.isDisposed()) {
                                    ExecuteOperationForm.this.createInvocationResult(resultTitle, result);
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    return new Status(4, "com.jrockit.mc.rjmx.ui", NLS.bind((String)Messages.ExecuteOperationForm_FAILED_TO_EXECUTE_MSG, (Object)job), (Throwable)e);
                }
            }
        }.schedule();
    }

    private void createInvocationResult(String resultTitle, Object result) {
        final CTabItem tab = new CTabItem(this.results, 0);
        tab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control c = tab.getControl();
                if (c != null && !c.isDisposed()) {
                    c.dispose();
                }
            }
        });
        tab.setText(resultTitle);
        Object[] val = new DefaultAttribute(null, result).getChildren().toArray();
        if (val.length > 0) {
            TreeColumnComposite structuredResult = AttributeTreeBuilder.buildDefault((Composite)this.results, this.settings);
            structuredResult.getViewer().setInput((Object)val);
            tab.setControl((Control)structuredResult);
        } else {
            String resultValue = result == null ? "" : result.toString();
            Text textResult = this.formToolkit.createText((Composite)this.results, resultValue, 584);
            tab.setControl((Control)textResult);
        }
        this.results.setVisible(true);
        this.results.setSelection(tab);
        this.layout();
    }

    private void addResultsContextMenu() {
        MenuManager mm = new MenuManager();
        mm.add((IAction)new Action(Messages.ExecuteOperationForm_CLOSE_ALL_LABEL){

            public void runWithEvent(Event event) {
                while (ExecuteOperationForm.this.results.getItemCount() != 0) {
                    ExecuteOperationForm.this.results.getItem(0).dispose();
                }
                ExecuteOperationForm.this.results.setVisible(false);
                ExecuteOperationForm.this.layout();
            }
        });
        Menu menu = mm.createContextMenu((Control)this.results);
        this.results.setMenu(menu);
    }

    public void setOperations(Collection<? extends IOperation> input) {
        this.invocatorForm.setOperations(input);
        this.layout(true);
    }

    public static interface HelpProvider {
        public Callable<?> getHelpInvocator(IOperation var1);
    }
}

