/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.celleditors;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.services.IUpdateInterval;
import com.jrockit.mc.rjmx.ui.celleditors.ArrayLengthCellEditor;
import com.jrockit.mc.rjmx.ui.celleditors.CharacterEditor;
import com.jrockit.mc.rjmx.ui.celleditors.NullableTextCellEditor;
import com.jrockit.mc.rjmx.ui.celleditors.NumberCellEditor;
import com.jrockit.mc.rjmx.ui.celleditors.StringConstructorCellEditor;
import com.jrockit.mc.rjmx.ui.celleditors.TogglingCellEditor;
import com.jrockit.mc.rjmx.ui.celleditors.UpdateIntervalCellEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

public class CellEditorStore {
    private static List<CellEditorFactory> FACTORIES = new ArrayList<CellEditorFactory>();
    private final Map<Class<?>, CellEditor> editorsCache = new HashMap();
    private final Composite parent;

    static {
        FACTORIES.add(new CellEditorFactory(){

            @Override
            public CellEditor createCellEditor(Composite parent, Class<?> forType) {
                Object[] objectArray = new Object[3];
                objectArray[1] = true;
                objectArray[2] = false;
                return new TogglingCellEditor(parent, objectArray);
            }

            @Override
            public boolean editorFor(Class<?> forType) {
                return Boolean.class.isAssignableFrom(forType);
            }
        });
        FACTORIES.add(new CellEditorFactory(){

            @Override
            public CellEditor createCellEditor(Composite parent, Class<?> forType) {
                return new TogglingCellEditor(parent, new Object[]{true, false});
            }

            @Override
            public boolean editorFor(Class<?> forType) {
                return Boolean.TYPE.isAssignableFrom(forType);
            }
        });
        FACTORIES.add(new CellEditorFactory(){

            @Override
            public CellEditor createCellEditor(Composite parent, Class<?> forType) {
                return new NullableTextCellEditor(parent);
            }

            @Override
            public boolean editorFor(Class<?> forType) {
                return String.class.isAssignableFrom(forType);
            }
        });
        FACTORIES.add(new CellEditorFactory(){

            @Override
            public CellEditor createCellEditor(Composite parent, Class<?> forType) {
                Class<Number> klass = TypeHandling.toNonPrimitiveClass(forType).asSubclass(Number.class);
                return new NumberCellEditor<Number>(parent, klass, !forType.isPrimitive(), true);
            }

            @Override
            public boolean editorFor(Class<?> forType) {
                Class klass = TypeHandling.toNonPrimitiveClass(forType);
                return Number.class.isAssignableFrom(klass) && StringConstructorCellEditor.checkContructor(klass);
            }
        });
        FACTORIES.add(new CellEditorFactory(){

            @Override
            public CellEditor createCellEditor(Composite parent, Class<?> forType) {
                return new CharacterEditor(parent, !forType.isPrimitive());
            }

            @Override
            public boolean editorFor(Class<?> forType) {
                return TypeHandling.toNonPrimitiveClass(forType) == Character.class;
            }
        });
        FACTORIES.add(new CellEditorFactory(){

            @Override
            public CellEditor createCellEditor(Composite parent, Class<?> forType) {
                return new StringConstructorCellEditor(parent, forType);
            }

            @Override
            public boolean editorFor(Class<?> forType) {
                return StringConstructorCellEditor.checkContructor(forType);
            }
        });
        FACTORIES.add(new CellEditorFactory(){

            @Override
            public CellEditor createCellEditor(Composite parent, Class<?> forType) {
                return new ArrayLengthCellEditor(parent, forType);
            }

            @Override
            public boolean editorFor(Class<?> forType) {
                return forType.isArray();
            }
        });
        FACTORIES.add(new CellEditorFactory(){

            @Override
            public CellEditor createCellEditor(Composite parent, Class<?> forType) throws Exception {
                return new UpdateIntervalCellEditor(parent);
            }

            @Override
            public boolean editorFor(Class<?> forType) {
                return IUpdateInterval.class.isAssignableFrom(forType);
            }
        });
    }

    public CellEditorStore(Composite parent) {
        this.parent = parent;
    }

    public boolean canProvideEditor(String type) {
        try {
            return this.canProvideEditor(TypeHandling.getClassWithName((String)type));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean canProvideEditor(Class<?> klass) {
        for (CellEditorFactory f : FACTORIES) {
            if (!f.editorFor(klass)) continue;
            return true;
        }
        return false;
    }

    public CellEditor getCellEditor(String type) {
        try {
            return this.getCellEditor(TypeHandling.getClassWithName((String)type));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public CellEditor getCellEditor(Class<?> klass) {
        CellEditor editor = this.editorsCache.get(klass);
        if (editor == null) {
            editor = this.createAndStoreEditor(klass);
        }
        return editor;
    }

    private CellEditor createAndStoreEditor(Class<?> klass) {
        for (CellEditorFactory factory : FACTORIES) {
            try {
                if (!factory.editorFor(klass)) continue;
                CellEditor editor = factory.createCellEditor(this.parent, klass);
                this.editorsCache.put(klass, editor);
                return editor;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Editor not found");
    }

    private static interface CellEditorFactory {
        public CellEditor createCellEditor(Composite var1, Class<?> var2) throws Exception;

        public boolean editorFor(Class<?> var1);
    }
}

