/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.system;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.system.SystemPropertiesSectionPart;
import com.jrockit.mc.console.ui.tabs.system.TableInformationSectionPart;
import com.jrockit.mc.rjmx.ui.internal.AttributeSectionPart;
import com.jrockit.mc.ui.misc.MCActionContributionItem;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SystemTab
extends ConsoleTab {
    private static final String SYSTEM_TAB_JVMSTATISTICS_SECTION_ID = "com.jrockit.mc.console.ui.JVMStatisticsSectionPart";
    private static final String TABLE_ID = "JVMStatistics";
    private AttributeSectionPart systemPart;

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        Composite container = managedForm.getForm().getBody();
        container.setLayout((Layout)new VerticalSectionLayout());
        form.getToolBarManager().prependToGroup("MC_TB_GROUP", (IContributionItem)new MCActionContributionItem((IAction)new ResetToDefaultsAction(){

            @Override
            protected void reset() {
                SystemTab.this.systemPart.restoreState(SystemTab.this.getDefaultConfig().getChild(SystemTab.TABLE_ID));
            }
        }));
        form.getToolBarManager().update(true);
        managedForm.addPart((IFormPart)new TableInformationSectionPart(container, this.getToolkit()));
        this.systemPart = new AttributeSectionPart(this.getEditor().getSectionPartManagers().get(0), container, this.getToolkit(), 322, SYSTEM_TAB_JVMSTATISTICS_SECTION_ID, this.getConnectionHandle(), ConsolePlugin.getDefault().getMCDialogSettings());
        managedForm.addPart((IFormPart)this.systemPart);
        this.systemPart.restoreState(this.loadState().getChild(TABLE_ID));
        this.systemPart.getSection().setText(Messages.SystemTab_SECTION_SYSTEM_STATISTICS_TEXT);
        managedForm.addPart((IFormPart)new SystemPropertiesSectionPart(container, managedForm.getToolkit()));
    }

    @Override
    protected boolean saveState(IMemento state) {
        this.systemPart.saveState(state.createChild(TABLE_ID));
        return true;
    }

    protected String getHelpContextID() {
        return "com.jrockit.mc.console.ui.SystemTab";
    }
}

