/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.system;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.system.SystemPropertiesProvider;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.sections.FieldTableViewerSectionPart;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SystemPropertiesSectionPart
extends FieldTableViewerSectionPart {
    private static Field[] FIELD_PROTOTYPES = new Field[]{SystemPropertiesProvider.FIELD_PROPERTY_KEY, SystemPropertiesProvider.FIELD_PROPERTY_VALUE};

    public SystemPropertiesSectionPart(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, 322, "system.properties", FIELD_PROTOTYPES, ConsolePlugin.getDefault().getMCDialogSettings());
        this.setHelpContextID("com.jrockit.mc.console.ui.SystemPropertiesSectionPart");
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getInput();
    }

    protected void initializePart() {
        super.initializePart();
        if (this.getConnectionHandle().isConnected()) {
            this.initializeConnectionData();
        }
    }

    private void initializeConnectionData() {
        this.getTableViewer().setContentProvider((IContentProvider)new SystemPropertiesProvider());
        this.addSubscription();
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.SystemTab_SECTION_SYSTEM_PROPERTIES_TEXT);
    }

    private void addSubscription() {
        ISubscriptionService attributeSubscriptionService = (ISubscriptionService)this.getConnectionHandle().getServiceOrDummy(ISubscriptionService.class);
        MRI attributeDescriptor = new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "SystemProperties");
        attributeSubscriptionService.addMRIValueListener(attributeDescriptor, new IMRIValueListener(){

            public void valueChanged(final MRIValueEvent event) {
                DisplayToolkit.safeAsyncExec((Widget)SystemPropertiesSectionPart.this.getSection(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!SystemPropertiesSectionPart.this.getTableViewer().getTable().isDisposed()) {
                            SystemPropertiesSectionPart.this.setInputAndSort(event);
                        }
                    }
                });
            }
        });
        MRIValueEvent e = attributeSubscriptionService.getLastMRIValueEvent(attributeDescriptor);
        if (e != null) {
            this.setInputAndSort(e);
        }
    }

    private void setInputAndSort(MRIValueEvent event) {
        this.getTableViewer().setInput(event.getValue());
        this.setSortColumn(SystemPropertiesProvider.FIELD_PROPERTY_KEY, true);
    }
}

