/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.memory;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.memory.GcTableSectionPart;
import com.jrockit.mc.console.ui.tabs.memory.HeapHistogram;
import com.jrockit.mc.console.ui.tabs.memory.MemoryPoolModel;
import com.jrockit.mc.console.ui.tabs.memory.MemoryPoolTableSectionPart;
import com.jrockit.mc.rjmx.services.IVirtualMachineService;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.MCActionContributionItem;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import com.jrockit.mc.ui.polling.PollManager;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MemoryTab
extends ConsoleTab {
    private static final String PREFIX = "com.jrockit.mc.console.ui.help_";
    private static final String MEMORY_TAB_GETTING_HEAP_HISTOGRAM_HELP_CONTEXT = "com.jrockit.mc.console.ui.help_HeapHistogram";
    private static final String MEMORY_TAB_GARBAGE_COLLECTOR_HELP_CONTEXT = "com.jrockit.mc.console.ui.help_GarbageCollector";

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        Composite container = managedForm.getForm().getBody();
        container.setLayout((Layout)new VerticalSectionLayout());
        form.getToolBarManager().prependToGroup("MC_TB_GROUP", (IContributionItem)new MCActionContributionItem((IAction)new GCAction()));
        form.getToolBarManager().update(true);
        HeapHistogram histogram = HeapHistogram.create(container, this.getToolkit(), 322, MEMORY_TAB_GETTING_HEAP_HISTOGRAM_HELP_CONTEXT, this.getConnectionHandle());
        if (histogram != null) {
            managedForm.addPart((IFormPart)histogram);
        }
        GcTableSectionPart gcTableSectionPart = new GcTableSectionPart(this.getEditor().getSectionPartManagers().get(0), container, this.getToolkit(), 322, MEMORY_TAB_GARBAGE_COLLECTOR_HELP_CONTEXT, this.getConnectionHandle());
        managedForm.addPart((IFormPart)gcTableSectionPart);
        MemoryPoolModel model = new MemoryPoolModel(this.getConnectionHandle());
        MemoryPoolTableSectionPart poolTable = new MemoryPoolTableSectionPart(container, this.getToolkit(), model, "console.memorypools");
        this.getManagedForm().addPart((IFormPart)poolTable);
        model.getPollManager().addPollee((PollManager.Pollable)poolTable);
    }

    protected String getHelpContextID() {
        return "com.jrockit.mc.console.ui.MemoryTab";
    }

    class GCAction
    extends Action {
        public GCAction() {
            super(null, 1);
            this.setText(Messages.MemoryTab_RUN_GC_ACTION_DESCRIPTION_TEXT);
            this.setToolTipText(Messages.MemoryTab_RUN_GC_ACTION_DESCRIPTION_TEXT);
            this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("trash.png"));
            this.setId("gc");
        }

        public void run() {
            try {
                ((IVirtualMachineService)MemoryTab.this.getConnectionHandle().getServiceOrDummy(IVirtualMachineService.class)).gc();
            }
            catch (UnsupportedOperationException o) {
                ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, o);
                DialogToolkit.showException((Shell)MemoryTab.this.getEditorSite().getShell(), (String)Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, (String)Messages.MemoryTab_MESSAGE_COULD_NOT_RUN_GC, (Throwable)o);
            }
            catch (IOException o) {
                ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, o);
                DialogToolkit.showException((Shell)MemoryTab.this.getEditorSite().getShell(), (String)Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, (Throwable)o);
            }
        }
    }
}

