/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.memory;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.memory.AllPoolsContentProvider;
import com.jrockit.mc.console.ui.tabs.memory.MemoryPoolModel;
import com.jrockit.mc.console.ui.tabs.memory.UsageBackgroundTablePainter;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.polling.PollManager;
import com.jrockit.mc.ui.polling.RefreshPollAction;
import com.jrockit.mc.ui.sections.FieldTableViewerSectionPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MemoryPoolTableSectionPart
extends FieldTableViewerSectionPart
implements PollManager.Pollable {
    private static Field[] FIELDPROTOTYPES = new Field[]{AllPoolsContentProvider.FIELD_POOL_NAME, AllPoolsContentProvider.FIELD_POOL_TYPE, AllPoolsContentProvider.FIELD_POOL_CUR_USED, AllPoolsContentProvider.FIELD_POOL_CUR_MAX, AllPoolsContentProvider.FIELD_POOL_CUR_USAGE, AllPoolsContentProvider.FIELD_POOL_PEAK_USED, AllPoolsContentProvider.FIELD_POOL_PEAK_MAX};
    private final MemoryPoolModel m_poolModel;
    private RefreshPollAction m_pollAction;

    public MemoryPoolTableSectionPart(Composite parent, FormToolkit toolkit, MemoryPoolModel poolModel, String sectionIdetifier) {
        super(parent, toolkit, 450, sectionIdetifier, FIELDPROTOTYPES, ConsolePlugin.getDefault().getMCDialogSettings());
        this.setHelpContextID("com.jrockit.mc.console.ui.MemoryPoolTableSectionPart");
        this.m_poolModel = poolModel;
    }

    protected MemoryPoolModel getModel() {
        return this.m_poolModel;
    }

    public void initialize(IManagedForm form) {
        this.m_pollAction = new RefreshPollAction(Messages.PoolTableSectionPart_ACTION_REFRESH_POOLS_TEXT, this.m_poolModel.getPollManager(), (PollManager.Pollable)this);
        this.getMCToolBarManager().add((IAction)this.m_pollAction);
        super.initialize(form);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.PoolTableSectionPart_SECTION_TEXT);
        section.setDescription(Messages.PoolTableSectionPart_DESCRIPTION_TEXT);
        section.setData("name", (Object)"threads.ThreadsTab.AllPoolsTable");
    }

    protected void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new AllPoolsContentProvider());
        this.getTableViewer().setInput((Object)this.getModel());
        this.getTableViewer().getTable().addListener(40, (Listener)new UsageBackgroundTablePainter(this.getFields()));
    }

    public boolean poll() {
        Control control = this.getTableViewer().getControl();
        if (control == null || control.isDisposed()) {
            return false;
        }
        Display display = control.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        if (!this.m_poolModel.isConnected()) {
            return false;
        }
        this.m_poolModel.update();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!MemoryPoolTableSectionPart.this.m_poolModel.isConnected()) {
                    MemoryPoolTableSectionPart.this.m_poolModel.getPollManager().stop();
                }
                MemoryPoolTableSectionPart.this.getTableViewer().refresh();
            }
        });
        return true;
    }
}

