/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.preferences;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.core.security.PersistentCredentials;
import com.jrockit.mc.core.security.SecurityException;
import com.jrockit.mc.core.security.SecurityManagerFactory;
import com.jrockit.mc.ui.misc.IntFieldEditor;
import java.util.logging.Level;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CommunicationPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private IntFieldEditor mailServerPort;
    private Text userField;
    private Text passwordField;

    public CommunicationPage() {
        super(1);
        this.setPreferenceStore(ConsolePlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.CommunicationPage_DESCRIPTION);
    }

    public void createFieldEditors() {
        IntegerFieldEditor updateInterval = new IntegerFieldEditor("console.ui.communication.update.interval", Messages.CommunicationPage_CAPTION_DEFAULT_UPDATE_INTERVAL, this.getFieldEditorParent());
        this.addField((FieldEditor)updateInterval);
        IntFieldEditor profilerUpdateInterval = new IntFieldEditor("console.ui.profiling.update.interval.", Messages.CommunicationPage_UPDATE_INTERVAL_THREAD_STACKUPDATE_INTERVAL_PROFILING_INFORMATION, this.getFieldEditorParent());
        profilerUpdateInterval.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)profilerUpdateInterval);
        IntFieldEditor threadUpdateInterval = new IntFieldEditor("console.ui.threaddump.update.interval.", Messages.CommunicationPage_UPDATE_INTERVAL_THREAD_STACK0, this.getFieldEditorParent());
        threadUpdateInterval.setValidRange(50, Integer.MAX_VALUE);
        this.addField((FieldEditor)threadUpdateInterval);
        StringFieldEditor mailServer = new StringFieldEditor("smtp_server", Messages.CommunicationPage_CAPTION_MAIL_SERVER, this.getFieldEditorParent());
        this.addField((FieldEditor)mailServer);
        this.mailServerPort = new IntFieldEditor("smtp_server_port", Messages.CommunicationPage_CAPTION_MAIL_SERVER_PORT, this.getFieldEditorParent());
        this.addField((FieldEditor)this.mailServerPort);
        BooleanFieldEditor mailServerSecure = new BooleanFieldEditor("smtp_server_secure", Messages.CommunicationPage_CAPTION_SECURE_MAIL_SERVER, this.getFieldEditorParent());
        this.addField((FieldEditor)mailServerSecure);
        this.createCredentialFields();
        this.loadCredentials();
    }

    private void createCredentialFields() {
        Label userLabel = new Label(this.getFieldEditorParent(), 0);
        userLabel.setText(Messages.CommunicationPage_CAPTION_MAIL_SERVER_USER);
        userLabel.setLayoutData((Object)new GridData(768));
        this.userField = new Text(this.getFieldEditorParent(), 2052);
        this.userField.setLayoutData((Object)new GridData(768));
        Label passLabel = new Label(this.getFieldEditorParent(), 0);
        passLabel.setText(Messages.CommunicationPage_CAPTION_MAIL_SERVER_PASSWORD);
        passLabel.setLayoutData((Object)new GridData(768));
        this.passwordField = new Text(this.getFieldEditorParent(), 0x400804);
        this.passwordField.setLayoutData((Object)new GridData(768));
    }

    private void loadCredentials() {
        String key = this.getPreferenceStore().getString("smtp_server_credentials");
        if (key != null && !"".equals(key)) {
            try {
                PersistentCredentials credentials = new PersistentCredentials(key);
                this.userField.setText(credentials.getUsername());
                this.passwordField.setText(credentials.getPassword());
                return;
            }
            catch (SecurityException e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not load stored SMTP credentials!", e);
                e.printStackTrace();
            }
        }
        this.userField.setText("email@example.com");
        this.passwordField.setText("");
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        super.performOk();
        System.setProperty("com.jrockit.console.preferences.updateinterval", this.getPreferenceStore().getString("console.ui.communication.update.interval"));
        this.storeCredentials();
        return true;
    }

    private void storeCredentials() {
        String oldCredentialsKey = this.getPreferenceStore().getString("smtp_server_credentials");
        String oldPasswordKey = this.getPreferenceStore().getString("smtp_server_password");
        if (this.userField.getText().equals("email@example.com") && this.passwordField.getText().equals("")) {
            this.getPreferenceStore().setValue("smtp_server_user", "email@example.com");
            this.getPreferenceStore().setValue("smtp_server_password", "");
            this.getPreferenceStore().setValue("smtp_server_credentials", "");
            this.pruneOldPassword(oldPasswordKey);
            this.pruneOldCredentials(oldCredentialsKey);
            return;
        }
        this.getPreferenceStore().setValue("smtp_server_user", this.userField.getText());
        try {
            String passwordKey = SecurityManagerFactory.getSecurityManager().store(new String[]{this.passwordField.getText()});
            this.getPreferenceStore().setValue("smtp_server_password", passwordKey);
            this.pruneOldPassword(oldPasswordKey);
        }
        catch (SecurityException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not store SMTP password!", e);
        }
        try {
            PersistentCredentials credentials = new PersistentCredentials(this.userField.getText(), this.passwordField.getText());
            this.getPreferenceStore().setValue("smtp_server_credentials", credentials.getExportedId());
            this.pruneOldCredentials(oldCredentialsKey);
        }
        catch (SecurityException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not store SMTP credentials!", e);
        }
    }

    private void pruneOldPassword(String oldPasswordKey) {
        this.pruneSecurityManager(oldPasswordKey, "", "mail server password");
    }

    private void pruneOldCredentials(String oldCredentialsKey) {
        this.pruneSecurityManager(oldCredentialsKey, "", "mail server credentials");
    }

    private void pruneSecurityManager(String oldKey, String defaultKey, String description) {
        if (oldKey != null && !oldKey.equals(defaultKey)) {
            try {
                SecurityManagerFactory.getSecurityManager().withdraw(oldKey);
            }
            catch (SecurityException e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not remove old " + description + '!', e);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor editor;
        Object src;
        if (event.getProperty().equals("field_editor_value") && (src = event.getSource()) instanceof FieldEditor && "smtp_server_secure".equals((editor = (FieldEditor)src).getPreferenceName())) {
            boolean secure = ((BooleanFieldEditor)editor).getBooleanValue();
            int port = this.mailServerPort.getIntValue();
            if (secure && port == 25) {
                this.mailServerPort.setStringValue(String.valueOf(465));
            } else if (port == 465) {
                this.mailServerPort.setStringValue(String.valueOf(25));
            }
            return;
        }
        super.propertyChange(event);
    }
}

