/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.fallback;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.keyring.impl.Utils;
import org.netbeans.modules.keyring.spi.EncryptionProvider;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FallbackProvider
implements KeyringProvider,
Callable<Void> {
    private static final Logger LOG = Logger.getLogger(FallbackProvider.class.getName());
    private static final String DESCRIPTION = ".description";
    private static final String SAMPLE_KEY = "__sample__";
    private EncryptionProvider encryption;

    public boolean enabled() {
        for (EncryptionProvider encryptionProvider : Lookup.getDefault().lookupAll(EncryptionProvider.class)) {
            if (!encryptionProvider.enabled()) continue;
            this.encryption = encryptionProvider;
            Preferences preferences = this.prefs();
            Utils.goMinusR(preferences);
            encryptionProvider.encryptionChangingCallback(this);
            if (!this.testSampleKey(preferences)) continue;
            LOG.log(Level.FINE, "Using provider: {0}", encryptionProvider);
            return true;
        }
        LOG.fine("No provider");
        return false;
    }

    private boolean testSampleKey(Preferences preferences) {
        byte[] byArray = preferences.getByteArray(SAMPLE_KEY, null);
        if (byArray == null) {
            this.encryption.freshKeyring(true);
            byte[] byArray2 = new byte[36];
            new SecureRandom().nextBytes(byArray2);
            if (this._save(SAMPLE_KEY, (SAMPLE_KEY + new String(byArray2)).toCharArray(), NbBundle.getMessage(FallbackProvider.class, (String)"FallbackProvider.sample_key.description"))) {
                LOG.fine("saved sample key");
                return true;
            }
            LOG.fine("could not save sample key");
            return false;
        }
        this.encryption.freshKeyring(false);
        while (true) {
            try {
                if (new String(this.encryption.decrypt(byArray)).startsWith(SAMPLE_KEY)) {
                    LOG.fine("succeeded in decrypting sample key");
                    return true;
                }
                LOG.fine("wrong result decrypting sample key");
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "failed to decrypt sample key", exception);
            }
            if (!this.encryption.decryptionFailed()) {
                LOG.fine("sample key decryption failed");
                return this.promptToDelete(preferences);
            }
            LOG.fine("will retry decryption of sample key");
        }
    }

    private boolean promptToDelete(Preferences preferences) {
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(FallbackProvider.class, (String)"FallbackProvider.msg_clear_keys"), NbBundle.getMessage(FallbackProvider.class, (String)"FallbackProvider.title_clear_keys"), 2));
        if (object == NotifyDescriptor.OK_OPTION) {
            try {
                LOG.log(Level.FINE, "agreed to delete stored passwords: {0}", Arrays.asList(preferences.keys()));
                preferences.clear();
                return this.testSampleKey(preferences);
            }
            catch (BackingStoreException backingStoreException) {
                LOG.log(Level.INFO, null, backingStoreException);
            }
        } else {
            LOG.fine("refused to delete stored passwords");
        }
        return false;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(Keyring.class).node(this.encryption.id());
    }

    public char[] read(String string) {
        byte[] byArray = this.prefs().getByteArray(string, null);
        if (byArray == null) {
            return null;
        }
        try {
            return this.encryption.decrypt(byArray);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "failed to decrypt password for " + string, exception);
            return null;
        }
    }

    public void save(String string, char[] cArray, String string2) {
        this._save(string, cArray, string2);
    }

    private boolean _save(String string, char[] cArray, String string2) {
        Preferences preferences = this.prefs();
        try {
            preferences.putByteArray(string, this.encryption.encrypt(cArray));
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "failed to encrypt password for " + string, exception);
            return false;
        }
        if (string2 != null) {
            preferences.put(string + DESCRIPTION, string2);
        }
        return true;
    }

    public void delete(String string) {
        Preferences preferences = this.prefs();
        preferences.remove(string);
        preferences.remove(string + DESCRIPTION);
    }

    @Override
    public Void call() throws Exception {
        LOG.fine("encryption changing");
        HashMap<String, char[]> hashMap = new HashMap<String, char[]>();
        Preferences preferences = this.prefs();
        for (String string : preferences.keys()) {
            byte[] byArray;
            if (string.endsWith(DESCRIPTION) || (byArray = preferences.getByteArray(string, null)) == null) continue;
            hashMap.put(string, this.encryption.decrypt(byArray));
        }
        LOG.log(Level.FINE, "reencrypting keys: {0}", hashMap.keySet());
        this.encryption.encryptionChanged();
        for (Map.Entry entry : hashMap.entrySet()) {
            preferences.putByteArray((String)entry.getKey(), this.encryption.encrypt((char[])entry.getValue()));
        }
        LOG.fine("encryption changing finished");
        return null;
    }
}

