/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.quicksearch.AbstractQuickSearchComboBar;
import org.netbeans.modules.quicksearch.CommandEvaluator;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.QuickSearchComboBar;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.netbeans.modules.quicksearch.SearchResultRender;
import org.netbeans.modules.quicksearch.recent.RecentSearches;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class QuickSearchPopup
extends JPanel
implements ListDataListener,
ActionListener,
TaskListener,
Runnable {
    private static final String CUSTOM_WIDTH = "customWidth";
    private static final int RESIZE_AREA_WIDTH = 5;
    private AbstractQuickSearchComboBar comboBar;
    private ResultsModel rModel;
    private Rectangle popupBounds = new Rectangle();
    private Timer updateTimer;
    private static final int COALESCE_TIME = 300;
    private String searchedText;
    private int catWidth;
    private int resultWidth;
    private int customWidth = -1;
    private boolean canResize = false;
    private Task evalTask;
    private Task saveTask;
    private static final RequestProcessor RP = new RequestProcessor(QuickSearchPopup.class);
    private static final RequestProcessor evaluatorRP = new RequestProcessor(QuickSearchPopup.class + ".evaluator");
    private static final Logger LOG = Logger.getLogger(QuickSearchPopup.class.getName());
    private JLabel hintLabel;
    private JSeparator hintSep;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JLabel noResultsLabel;
    private JLabel searchingLabel;
    private JSeparator searchingSep;
    private JPanel statusPanel;
    private boolean explicitlyInvoked = false;

    public QuickSearchPopup(AbstractQuickSearchComboBar abstractQuickSearchComboBar) {
        this.comboBar = abstractQuickSearchComboBar;
        this.initComponents();
        this.loadSettings();
        this.makeResizable();
        this.rModel = ResultsModel.getInstance();
        this.jList1.setModel(this.rModel);
        this.jList1.setCellRenderer(new SearchResultRender(this));
        this.rModel.addListDataListener(this);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.jList1.setBackground(QuickSearchComboBar.getResultBackground());
        }
        this.updateStatusPanel(this.evalTask != null);
        this.setVisible(false);
    }

    void invoke() {
        ResultsModel.ItemResult itemResult = (ResultsModel.ItemResult)this.jList1.getModel().getElementAt(this.jList1.getSelectedIndex());
        if (itemResult != null) {
            RecentSearches.getDefault().add(itemResult);
            itemResult.getAction().run();
            this.clearModel();
        }
    }

    void selectNext() {
        int n = this.jList1.getSelectedIndex();
        if (n >= 0 && n < this.jList1.getModel().getSize() - 1) {
            this.jList1.setSelectedIndex(n + 1);
        }
        if (this.jList1.getModel().getSize() > 0) {
            this.setVisible(true);
        }
    }

    void selectPrev() {
        int n = this.jList1.getSelectedIndex();
        if (n > 0) {
            this.jList1.setSelectedIndex(n - 1);
        }
        if (this.jList1.getModel().getSize() > 0) {
            this.setVisible(true);
        }
    }

    public JList getList() {
        return this.jList1;
    }

    public void clearModel() {
        this.rModel.setContent(null);
    }

    public void maybeEvaluate(String string) {
        this.searchedText = string;
        if (string.length() > 0) {
            this.updateStatusPanel(true);
            this.updatePopup(true);
        }
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(300, this);
        }
        if (!this.updateTimer.isRunning()) {
            this.updateTimer.start();
        } else {
            this.updateTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateTimer.stop();
        if (this.comboBar.getCommand().isFocusOwner()) {
            evaluatorRP.post(new Runnable(){

                @Override
                public void run() {
                    if (QuickSearchPopup.this.evalTask != null) {
                        QuickSearchPopup.this.evalTask.removeTaskListener((TaskListener)QuickSearchPopup.this);
                    }
                    QuickSearchPopup.this.evalTask = CommandEvaluator.evaluate(QuickSearchPopup.this.searchedText, QuickSearchPopup.this.rModel);
                    QuickSearchPopup.this.evalTask.addTaskListener((TaskListener)QuickSearchPopup.this);
                    RP.post((Runnable)QuickSearchPopup.this.evalTask);
                }
            });
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.statusPanel = new JPanel();
        this.searchingSep = new JSeparator();
        this.searchingLabel = new JLabel();
        this.noResultsLabel = new JLabel();
        this.hintSep = new JSeparator();
        this.hintLabel = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(QuickSearchComboBar.getPopupBorderColor()));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jList1.setFocusable(false);
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                QuickSearchPopup.this.jList1MouseClicked(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                QuickSearchPopup.this.jList1MousePressed(mouseEvent);
            }
        });
        this.jList1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                QuickSearchPopup.this.jList1MouseDragged(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                QuickSearchPopup.this.jList1MouseMoved(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusPanel.setBackground(QuickSearchComboBar.getResultBackground());
        this.statusPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.searchingSep, gridBagConstraints);
        this.searchingLabel.setText(NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.searchingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.statusPanel.add((Component)this.searchingLabel, gridBagConstraints);
        this.noResultsLabel.setForeground(Color.red);
        this.noResultsLabel.setHorizontalAlignment(0);
        this.noResultsLabel.setText(NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.noResultsLabel.text"));
        this.noResultsLabel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.noResultsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.hintSep, gridBagConstraints);
        this.hintLabel.setBackground(QuickSearchComboBar.getResultBackground());
        this.hintLabel.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.statusPanel.add((Component)this.hintLabel, gridBagConstraints);
        this.add((Component)this.statusPanel, "Last");
    }

    private void jList1MouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getX() < 5) {
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        Point point = mouseEvent.getPoint();
        int n = this.jList1.locationToIndex(point);
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.jList1.getCellBounds(n, n);
        if (rectangle != null && rectangle.contains(point)) {
            this.jList1.setSelectedIndex(n);
        }
    }

    private void jList1MouseClicked(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.comboBar.invokeSelectedItem();
    }

    private void jList1MouseDragged(MouseEvent mouseEvent) {
        this.processMouseMotionEvent(mouseEvent);
    }

    private void jList1MousePressed(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updatePopup(this.evalTask != null);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updatePopup(this.evalTask != null);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updatePopup(this.evalTask != null);
    }

    public void updatePopup(boolean bl) {
        this.updatePopup(bl, true);
    }

    private void updatePopup(boolean bl, boolean bl2) {
        JLayeredPane jLayeredPane;
        int n = this.rModel.getSize();
        if (n > 0 && this.jList1.getSelectedIndex() < 0) {
            this.jList1.setSelectedIndex(0);
        }
        if ((jLayeredPane = JLayeredPane.getLayeredPaneAbove(this.comboBar)) == null) {
            return;
        }
        if (!this.isDisplayable()) {
            jLayeredPane.add((Component)this, new Integer(JLayeredPane.POPUP_LAYER + 1));
        }
        boolean bl3 = this.updateStatusPanel(bl);
        try {
            this.computePopupBounds(this.popupBounds, jLayeredPane, n);
        }
        catch (Exception exception) {
            LOG.log(bl2 ? Level.INFO : Level.SEVERE, null, exception);
            this.retryUpdatePopup(bl2, bl);
            return;
        }
        this.setBounds(this.popupBounds);
        if ((n > 0 || bl3) && this.comboBar.getCommand().isFocusOwner()) {
            if (n > 0 && !this.isVisible()) {
                this.jList1.setSelectedIndex(0);
            }
            if (this.jList1.getSelectedIndex() >= n) {
                this.jList1.setSelectedIndex(n - 1);
            }
            if (this.explicitlyInvoked || !this.searchedText.isEmpty()) {
                this.setVisible(true);
            }
        } else {
            this.setVisible(false);
        }
        this.explicitlyInvoked = false;
        this.revalidate();
    }

    private void retryUpdatePopup(boolean bl, final boolean bl2) {
        if (bl) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QuickSearchPopup.this.updatePopup(bl2, false);
                }
            });
        }
    }

    void explicitlyInvoked() {
        this.explicitlyInvoked = true;
    }

    public int getCategoryWidth() {
        if (this.catWidth <= 0) {
            this.catWidth = QuickSearchPopup.computeWidth(this.jList1, 20, 30);
        }
        return this.catWidth;
    }

    public int getResultWidth() {
        if (this.resultWidth <= 0) {
            this.resultWidth = QuickSearchPopup.computeWidth(this.jList1, 42, 50);
        }
        if (this.customWidth > 0) {
            return Math.max(this.resultWidth, this.customWidth);
        }
        return this.resultWidth;
    }

    public int getPopupWidth() {
        int n = this.getParent() == null ? Integer.MAX_VALUE : this.getParent().getWidth() - 10;
        return Math.min(this.getCategoryWidth() + this.getResultWidth() + 3, n);
    }

    public void taskFinished(Task task) {
        this.evalTask = null;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.updatePopup(this.evalTask != null);
    }

    private void computePopupBounds(Rectangle rectangle, JLayeredPane jLayeredPane, int n) {
        Dimension dimension = this.comboBar.getSize();
        int n2 = this.getPopupWidth();
        Point point = new Point(dimension.width - n2 - 1, this.comboBar.getBottomLineY() - 1);
        if (SwingUtilities.getWindowAncestor(this.comboBar) != null) {
            point = SwingUtilities.convertPoint(this.comboBar, point, jLayeredPane);
        }
        rectangle.setLocation(point);
        this.jList1.setFixedCellHeight(15);
        this.jList1.setFixedCellHeight(-1);
        this.jList1.setVisibleRowCount(n);
        Dimension dimension2 = this.jList1.getPreferredSize();
        dimension2.width = n2;
        dimension2.height += this.statusPanel.getPreferredSize().height + 3;
        rectangle.setSize(dimension2);
    }

    private static int computeWidth(JComponent jComponent, int n, int n2) {
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        int n3 = fontMetrics.charWidth('X');
        int n4 = n3 * n;
        Window window = SwingUtilities.windowForComponent(jComponent);
        if (window != null) {
            n4 = Math.min(n4, window.getWidth() * n2 / 100);
        }
        return n4;
    }

    private boolean updateStatusPanel(boolean bl) {
        boolean bl2 = false;
        this.searchingSep.setVisible(bl);
        this.searchingLabel.setVisible(bl);
        if (this.comboBar instanceof QuickSearchComboBar) {
            if (bl) {
                ((QuickSearchComboBar)this.comboBar).startProgressAnimation();
            } else {
                ((QuickSearchComboBar)this.comboBar).stopProgressAnimation();
            }
        }
        bl2 = bl2 || bl;
        boolean bl3 = this.searchedText != null && this.searchedText.trim().length() > 0;
        boolean bl4 = this.rModel.getSize() <= 0 && bl3 && !bl;
        this.noResultsLabel.setVisible(bl4);
        this.comboBar.setNoResults(bl4);
        bl2 = bl2 || bl4;
        this.hintLabel.setText(this.getHintText());
        boolean bl5 = CommandEvaluator.getEvalCat() != null && bl3;
        this.hintSep.setVisible(bl5);
        this.hintLabel.setVisible(bl5);
        bl2 = bl2 || bl5;
        return bl2;
    }

    private String getHintText() {
        ProviderModel.Category category = CommandEvaluator.getEvalCat();
        if (category == null) {
            return null;
        }
        return NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.hintLabel.text", (Object)category.getDisplayName(), (Object)SearchResultRender.getKeyStrokeAsText(this.comboBar.getKeyStroke()));
    }

    private void makeResizable() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (QuickSearchPopup.this.canResize) {
                    QuickSearchPopup.this.customWidth = QuickSearchPopup.this.getResultWidth() - mouseEvent.getX();
                    QuickSearchPopup.this.run();
                    QuickSearchPopup.this.saveSettings();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                QuickSearchPopup.this.canResize = mouseEvent.getX() < 5;
            }
        });
    }

    private void loadSettings() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Preferences preferences = NbPreferences.forModule(QuickSearchPopup.class);
                QuickSearchPopup.this.customWidth = preferences.getInt(QuickSearchPopup.CUSTOM_WIDTH, -1);
            }
        });
    }

    private synchronized void saveSettings() {
        if (this.saveTask == null) {
            this.saveTask = RP.create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Preferences preferences = NbPreferences.forModule(QuickSearchPopup.class);
                    preferences.putInt(QuickSearchPopup.CUSTOM_WIDTH, QuickSearchPopup.this.customWidth);
                    QuickSearchPopup quickSearchPopup = QuickSearchPopup.this;
                    synchronized (quickSearchPopup) {
                        QuickSearchPopup.this.saveTask = null;
                    }
                }
            });
            RP.post((Runnable)this.saveTask, 1000);
        }
    }
}

