/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.xml.internal;

import com.jrockit.mc.common.xml.ClassFactory;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.common.xml.internal.AbstractCodec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class UnmodifiableMapCodec
extends AbstractCodec {
    private static final Class<?> UNMODIFIABLE_CLASS = Collections.unmodifiableMap(Collections.EMPTY_MAP).getClass();
    private static final String ELEMENT_MAP_ENTRY = "mapEntry";

    @Override
    public Map<?, ?> decode(Element element, ClassFactory factory) throws Exception {
        HashMap map = new HashMap();
        int size = Integer.parseInt(element.getAttribute("size"));
        int i = 0;
        while (i < size) {
            Map.Entry entry = (Map.Entry)XmlToolkit.getNameTypeValue(element, ELEMENT_MAP_ENTRY + Integer.toString(i), factory);
            if (entry != null && entry.getKey() != null && entry.getValue() != null) {
                map.put(entry.getKey(), entry.getValue());
            }
            ++i;
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void encode(Object o, Element parentNode) {
        Map map = (Map)o;
        parentNode.setAttribute("size", Integer.toString(map.size()));
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            XmlToolkit.setNameTypeValue(parentNode, ELEMENT_MAP_ENTRY + Integer.toString(index++), entry);
        }
    }

    @Override
    public Class<?> getType() {
        return UNMODIFIABLE_CLASS;
    }
}

