/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.Messages;
import com.jrockit.mc.common.util.Toolkit;
import java.text.ParseException;

public final class SizeToolkit
extends Toolkit {
    private static final String PROTOTYPE_DEFAULT;
    private static final long BYTES = 1L;
    private static final long KILOBYTES = 1024L;
    private static final long MEGABYTES = 0x100000L;
    private static final long GIGABYTES = 0x40000000L;
    private static final long TERABYTES = 0x10000000000L;
    private static final long[] VALUE_ARRAY;
    private static final String[][] UNIT_ARRAY;
    private static final int DEFAULT_UNIT_INDEX = 0;

    static {
        VALUE_ARRAY = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L};
        String[][] unitKeys = new String[][]{{"SizeToolkit_BYTES", "B", "SizeToolkit_BYTES_LONG", "bytes"}, {"SizeToolkit_KILOBYTES", "kB", "SizeToolkit_KILOBYTES_SHORT", "SizeToolkit_KILOBYTES_LONG", "k", "kilobytes"}, {"SizeToolkit_MEGABYTES", "MB", "SizeToolkit_MEGABYTES_SHORT", "SizeToolkit_MEGABYTES_LONG", "M", "megabytes"}, {"SizeToolkit_GIGABYTES", "GB", "SizeToolkit_GIGABYTES_SHORT", "SizeToolkit_GIGABYTES_LONG", "G", "gigabytes"}, {"SizeToolkit_TERABYTES", "TB", "SizeToolkit_TERABYTES_SHORT", "SizeToolkit_TERABYTES_LONG", "T", "terabytes"}};
        UNIT_ARRAY = new String[unitKeys.length][];
        int i = 0;
        while (i < UNIT_ARRAY.length) {
            String[] keys = unitKeys[i];
            String[] units = new String[keys.length];
            int j = 0;
            while (j < units.length) {
                units[j] = Messages.getString(keys[j], keys[j]);
                ++j;
            }
            SizeToolkit.UNIT_ARRAY[i] = units;
            ++i;
        }
        PROTOTYPE_DEFAULT = SizeToolkit.toPrototype(1);
    }

    private static String toPrototype(Number value) {
        return value + " kB";
    }

    public static String convertBytesToString(long bytes, Format format) {
        int i = VALUE_ARRAY.length - 1;
        while (i >= 0) {
            if (bytes % VALUE_ARRAY[i] == 0L) {
                return String.valueOf(bytes / VALUE_ARRAY[i]) + " " + UNIT_ARRAY[i][format.uIdx];
            }
            --i;
        }
        return String.valueOf(bytes) + " " + UNIT_ARRAY[0][format.uIdx];
    }

    public static long parseBytes(String size) throws QuantityConversionException {
        Toolkit.Holder holder = null;
        try {
            holder = new Toolkit.Holder(size);
        }
        catch (NumberFormatException e) {
            throw QuantityConversionException.unparsable(size, PROTOTYPE_DEFAULT);
        }
        catch (ParseException e) {
            throw QuantityConversionException.unparsable(size, PROTOTYPE_DEFAULT);
        }
        if (holder.unit == null || "".equals(holder.unit)) {
            throw QuantityConversionException.noUnit(size, SizeToolkit.toPrototype(holder.value));
        }
        int i = 0;
        while (i < VALUE_ARRAY.length) {
            if (SizeToolkit.isCompatibleUnit(holder, UNIT_ARRAY[i])) {
                return SizeToolkit.multiply(holder.value, VALUE_ARRAY[i]);
            }
            ++i;
        }
        throw QuantityConversionException.unknownUnit(holder.unit, SizeToolkit.toPrototype(holder.value));
    }

    public static enum Format {
        LOCALIZED(0),
        SI(1);

        private final int uIdx;

        private Format(int unitIndex) {
            this.uIdx = unitIndex;
        }
    }
}

