/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.BinaryPrefix;
import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.CustomUnitSelector;
import com.jrockit.mc.common.unit.DecimalPrefix;
import com.jrockit.mc.common.unit.DecimalUnitSelector;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.FixedUnitFormatter;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.Timestamp;
import com.jrockit.mc.common.unit.TimestampKind;
import com.jrockit.mc.common.unit.UnitDescriptor;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UnitLookup {
    private static final String UNIT_ID_SEPARATOR = ":";
    public static final LinearKindOfQuantity MEMORY = UnitLookup.createMemory();
    public static final LinearKindOfQuantity TIMESPAN = UnitLookup.createTimespan();
    public static final ContentType<Number> COUNT = UnitLookup.createCount();
    public static final ContentType<Number> INDEX = UnitLookup.createIndex();
    public static final ContentType<Number> IDENTIFIER = UnitLookup.createIdentifier();
    public static final KindOfQuantity<Timestamp> TIMESTAMP = UnitLookup.createTimeStamp(TIMESPAN);
    public static final LinearKindOfQuantity PERCENTAGE = UnitLookup.createPercentage();
    public static final LinearKindOfQuantity NUMBER = UnitLookup.createNumber();
    public static final ContentType<Object> UNKNOWN = UnitLookup.createSyntheticContentType("unknown", Object.class);
    public static final ContentType<String> PLAIN_TEXT = UnitLookup.createSyntheticContentType("text", String.class);
    public static final ContentType<Object> METHOD = UnitLookup.createSyntheticContentType("method", Object.class);
    public static final ContentType<Object> CLASS = UnitLookup.createSyntheticContentType("class", Object.class);
    public static final ContentType<String> PACKAGE = UnitLookup.createSyntheticContentType("package", String.class);
    public static final ContentType<Object> THREAD = UnitLookup.createSyntheticContentType("thread", Object.class);
    public static final ContentType<Object> ADDRESS = UnitLookup.createSyntheticContentType("address", Object.class);
    public static final ContentType<Boolean> FLAG = UnitLookup.createSyntheticContentType("boolean", Boolean.class);
    public static final IUnit<?> EPOCHMILLIS = TIMESTAMP.getUnit("epochms");
    public static final IUnit<?> EPOCHNANOS = TIMESTAMP.getUnit("epochns");
    public static final LinearUnit PERCENT_UNITY = PERCENTAGE.getUnit("");
    public static final LinearUnit BYTES = MEMORY.getUnit(BinaryPrefix.NOBI);
    private static final List<ContentType<?>> s_types = Collections.unmodifiableList(UnitLookup.createContentTypes());

    private static List<ContentType<?>> createContentTypes() {
        ArrayList types = new ArrayList();
        types.add(MEMORY);
        types.add(TIMESPAN);
        types.add(COUNT);
        types.add(INDEX);
        types.add(IDENTIFIER);
        types.add(TIMESTAMP);
        types.add(PERCENTAGE);
        types.add(NUMBER);
        types.add(UNKNOWN);
        types.add(PLAIN_TEXT);
        types.add(METHOD);
        types.add(CLASS);
        types.add(PACKAGE);
        types.add(THREAD);
        types.add(ADDRESS);
        types.add(FLAG);
        return types;
    }

    public static List<KindOfQuantity<?>> getKindsOfQuantity() {
        return Arrays.asList(MEMORY, TIMESPAN, TIMESTAMP, NUMBER, PERCENTAGE);
    }

    public static List<ContentType<?>> getAllContentTypes() {
        return s_types;
    }

    public static Map<String, String> createContentTypeMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (ContentType<?> contenType : UnitLookup.getAllContentTypes()) {
            map.put(contenType.getIdentifier(), contenType.getName());
        }
        return map;
    }

    static Logger getLogger() {
        return Logger.getLogger("com.jrockit.mc.common.unit");
    }

    private static <T> ContentType<T> createSyntheticContentType(String id, Class<T> repClass) {
        ContentType contentType = new ContentType(id);
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Default"));
        return contentType;
    }

    private static LinearKindOfQuantity createNumber() {
        LinearKindOfQuantity number = new LinearKindOfQuantity("number", DecimalPrefix.NONE, "", EnumSet.range(DecimalPrefix.NONE, DecimalPrefix.NONE));
        number.addDisplayUnit(new LinearKindOfQuantity.AutoFormatter(number, "Dynamic", 0.001, 1000000.0));
        number.addDisplayUnit(new KindOfQuantity.ExactFormatter<LinearQuantity>(number));
        number.addDisplayUnit(new KindOfQuantity.VerboseFormatter<LinearQuantity>(number));
        number.addDisplayUnit(new LinearKindOfQuantity.AutoFormatter(number, "scientificNotation", "Scientific Notation", 1.0, 10.0, 3));
        number.addDisplayUnit(new LinearKindOfQuantity.AutoFormatter(number, "engineeringNotation", "Engineering Notation", 1.0, 1000.0, 3));
        return number;
    }

    private static LinearKindOfQuantity createMemory() {
        LinearKindOfQuantity memory = new LinearKindOfQuantity("memory", BinaryPrefix.NOBI, "B", EnumSet.range(BinaryPrefix.NOBI, BinaryPrefix.PEBI), EnumSet.range(BinaryPrefix.NOBI, BinaryPrefix.YOBI));
        memory.addDisplayUnit(new LinearKindOfQuantity.AutoFormatter(memory, "Dynamic", 1.0, 1024.0));
        memory.addDisplayUnit(new KindOfQuantity.ExactFormatter<LinearQuantity>(memory));
        memory.addDisplayUnit(new KindOfQuantity.VerboseFormatter<LinearQuantity>(memory));
        UnitLookup.addFixed(memory.getUnit(BinaryPrefix.NOBI));
        UnitLookup.addFixed(memory.getUnit(BinaryPrefix.KIBI));
        UnitLookup.addFixed(memory.getUnit(BinaryPrefix.MEBI));
        UnitLookup.addFixed(memory.getUnit(BinaryPrefix.GIBI));
        UnitLookup.addFixed(memory.getUnit(BinaryPrefix.TEBI));
        return memory;
    }

    private static void addFixed(LinearUnit unit) {
        FixedUnitFormatter fdu = new FixedUnitFormatter(unit);
        unit.getContentType().addDisplayUnit(fdu);
    }

    private static LinearKindOfQuantity createTimespan() {
        LinearUnit[] units;
        EnumSet<DecimalPrefix> commonPrefixes = EnumSet.range(DecimalPrefix.PICO, DecimalPrefix.MILLI);
        commonPrefixes.add(DecimalPrefix.NONE);
        LinearKindOfQuantity timeSpan = new LinearKindOfQuantity("timespan", DecimalPrefix.NANO, "s", commonPrefixes, EnumSet.range(DecimalPrefix.YOCTO, DecimalPrefix.YOTTA));
        LinearUnit second = timeSpan.atomUnit;
        LinearUnit minute = timeSpan.makeUnit("min", second.quantity(60L));
        LinearUnit hour = timeSpan.makeUnit("h", minute.quantity(60L));
        LinearUnit day = timeSpan.makeUnit("d", hour.quantity(24L));
        LinearUnit week = timeSpan.makeUnit("wk", day.quantity(7L));
        LinearUnit year = timeSpan.makeUnit("a", hour.quantity(8766L));
        LinearUnit[] linearUnitArray = units = new LinearUnit[]{minute, hour, day, week, year};
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            LinearUnit unit = linearUnitArray[n2];
            timeSpan.addUnit(unit);
            ++n2;
        }
        DecimalUnitSelector yearSelector = new DecimalUnitSelector(timeSpan, year);
        CustomUnitSelector selector = new CustomUnitSelector(timeSpan, timeSpan.unitSelector, Arrays.asList(units), yearSelector);
        timeSpan.setDefaultSelector(selector);
        timeSpan.addDisplayUnit(new LinearKindOfQuantity.DualUnitFormatter(timeSpan, "auto", "Human readable"));
        timeSpan.addDisplayUnit(new LinearKindOfQuantity.AutoFormatter(timeSpan, "Dynamic"));
        timeSpan.addDisplayUnit(new KindOfQuantity.ExactFormatter<LinearQuantity>(timeSpan));
        timeSpan.addDisplayUnit(new KindOfQuantity.VerboseFormatter<LinearQuantity>(timeSpan));
        UnitLookup.addFixed(timeSpan.getUnit(DecimalPrefix.NANO));
        UnitLookup.addFixed(timeSpan.getUnit(DecimalPrefix.MICRO));
        UnitLookup.addFixed(timeSpan.getUnit(DecimalPrefix.MILLI));
        UnitLookup.addFixed(timeSpan.getUnit(DecimalPrefix.NONE));
        return timeSpan;
    }

    private static KindOfQuantity<Timestamp> createTimeStamp(LinearKindOfQuantity timespan) {
        KindOfQuantity<Timestamp> timestampContentType = TimestampKind.buildContentType(timespan);
        timestampContentType.addDisplayUnit(new DisplayUnit<Timestamp>(timestampContentType, "auto", "Dynamic"){

            @Override
            public String format(Timestamp quantity) {
                return DateFormat.getDateTimeInstance(3, 2).format(quantity.getDate());
            }
        });
        timestampContentType.addDisplayUnit(new KindOfQuantity.ExactFormatter<Timestamp>(timestampContentType));
        timestampContentType.addDisplayUnit(new KindOfQuantity.VerboseFormatter<Timestamp>(timestampContentType));
        return timestampContentType;
    }

    private static LinearKindOfQuantity createPercentage() {
        LinearKindOfQuantity percentage = new LinearKindOfQuantity("percentage", DecimalPrefix.HECTO, "%", EnumSet.range(DecimalPrefix.NONE, DecimalPrefix.NONE));
        LinearUnit percentUnit = percentage.atomUnit;
        LinearUnit unity = percentage.makeUnit("", percentUnit.quantity(100L));
        percentage.addUnit(unity);
        percentage.setLegacyImplicitUnit(unity);
        percentage.addDisplayUnit(new LinearKindOfQuantity.AutoFormatter(percentage, "Dynamic", 0.001, 1000000.0));
        percentage.addDisplayUnit(new KindOfQuantity.ExactFormatter<LinearQuantity>(percentage));
        percentage.addDisplayUnit(new KindOfQuantity.VerboseFormatter<LinearQuantity>(percentage));
        percentage.addDisplayUnit(new DisplayUnit<LinearQuantity>(percentage, "accuracy2digits", "Accuraccy 2 digits)"));
        percentage.addDisplayUnit(new DisplayUnit<LinearQuantity>(percentage, "accuracy0digits", "Accuraccy 0 digits)"));
        percentage.addDisplayUnit(new DisplayUnit<LinearQuantity>(percentage, "accuracy1digit", "Accuraccy 1 digit)"));
        percentage.addDisplayUnit(new DisplayUnit<LinearQuantity>(percentage, "accuracy3digits", "Accuraccy 3 digits)"));
        return percentage;
    }

    private static ContentType<Number> createCount() {
        ContentType<Number> contentType = new ContentType<Number>("count");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Value"));
        return contentType;
    }

    private static ContentType<Number> createIdentifier() {
        ContentType<Number> contentType = new ContentType<Number>("identifier");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Value"));
        return contentType;
    }

    private static ContentType<Number> createIndex() {
        ContentType<Number> contentType = new ContentType<Number>("index");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Value"));
        return contentType;
    }

    public static String getUnitIdentifier(IUnit<?> unit) {
        if (unit.getIdentifier() == null) {
            throw new IllegalArgumentException("Cannot get identifier for impersistable unit :" + unit);
        }
        KindOfQuantity<?> ct = unit.getContentType();
        return String.valueOf(ct.getIdentifier()) + UNIT_ID_SEPARATOR + unit.getIdentifier();
    }

    public static IUnit<?> getUnitOrDefault(String unitIdentifier) {
        LinearUnit unit = UnitLookup.getUnitOrNull(unitIdentifier);
        return unit == null ? NUMBER.getUnit(DecimalPrefix.NONE) : unit;
    }

    public static IUnit<?> getUnitOrNull(String unitIdentifier) {
        ContentType<?> ct;
        String[] parts;
        if (unitIdentifier != null && (parts = unitIdentifier.split(UNIT_ID_SEPARATOR, 2)).length == 2 && (ct = UnitLookup.getContentType(parts[0])) instanceof KindOfQuantity) {
            IUnit unit = ((KindOfQuantity)ct).getUnit(parts[1]);
            if (unit != null) {
                return unit;
            }
            if (ct instanceof LinearKindOfQuantity) {
                LinearKindOfQuantity kindOfQuantity = (LinearKindOfQuantity)ct;
                String id = parts[1];
                LinearUnit linUnit = kindOfQuantity.getCachedUnit(id);
                if (linUnit != null) {
                    return linUnit;
                }
                try {
                    LinearQuantity quantity = kindOfQuantity.parsePersisted(id);
                    return kindOfQuantity.makeCustomUnit(quantity);
                }
                catch (QuantityConversionException e) {
                    UnitLookup.getLogger().log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    public static ContentType<?> getContentType(String identifier) {
        String[] parts = identifier.split(UNIT_ID_SEPARATOR, 2);
        if (parts.length > 2) {
            return UNKNOWN;
        }
        if (parts.length == 2) {
            identifier = parts[0];
        }
        for (ContentType<?> type : s_types) {
            if (!identifier.equals(type.getIdentifier())) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static UnitDescriptor getUnitDescriptor(String contentTypeIdentifier) {
        UnitDescriptor ud = new UnitDescriptor();
        ContentType<?> ct = UnitLookup.getContentType(contentTypeIdentifier);
        ud.setDisplayUnit(ct.getDisplayUnit("auto"));
        return ud;
    }
}

