/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.io;

import com.jrockit.mc.common.io.IOResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class JarFileResource
implements IOResource {
    private final JarEntry m_jarEntry;
    private final JarFile m_file;

    public JarFileResource(JarFile file, JarEntry jarEntry) {
        this.m_file = file;
        this.m_jarEntry = jarEntry;
    }

    @Override
    public InputStream open() throws IOException {
        return this.m_file.getInputStream(this.m_jarEntry);
    }

    @Override
    public void close() {
        if (this.m_file != null) {
            try {
                this.m_file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        String name = this.m_jarEntry.getName();
        int index = name.lastIndexOf("/");
        return name.substring(index + 1);
    }

    public String toString() {
        return this.getName();
    }
}

