/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.preferences;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.LinkedList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench m_workbench;
    public static final String P_OPEN_CONTROL_PANEL_ON_RECORDING_START = "flightRecorder.openControlPanelOnRecordingStart";
    public static final String P_CLOSE_CONTROL_PANEL_ON_RECORDING_END = "flightRecorder.closeControlPanelOnRecordingEnd";
    public static final String P_REMOVE_FINISHED_RECORDING = "flightRecorder.removeFinishedRecording";
    public static final String P_CONFIRM_REMOVE_TEMPLATE = "flightRecorder.confirmRemoveTemplate";
    public static final String P_SHOW_MONITORING_WARNING = "flightrecorder.controlpanel.show.monitoring.warning";
    public static final String P_LAST_PART_TO_DUMP_SETTING = "flightrecorder.controlpanel.ui.last.part.to.dump.setting";
    public static final String P_LAST_PART_TO_DUMP_MS = "flightrecorder.controlpanel.ui.last.part.to.dump.timespan";
    public static final long DUMP_WHOLE_TIMESPAN = -1L;
    public static final long DUMP_NO_DEFAULT_TIMESPAN = 0L;
    private Button noDefaultRadio;
    private Button wholeRadio;
    private Button timespanRadio;
    private final LinkedList<CheckBox> checkBoxes = new LinkedList();
    protected Text timespanValue;
    protected String previousValidTimespanValueString;

    public GeneralPage() {
        this.setPreferenceStore(FlightRecorderUI.getDefault().getPreferenceStore());
        this.setDescription(Messages.PREFERENCES_GENERAL_SETTINGS_TEXT);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Button button = this.createClearButton(container);
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        Button removeRecordingsCheckbox = this.createRemoveRecordingsCheckBox(container);
        removeRecordingsCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button confirmRemoveTemplateCheckbox = this.createConfirmRemoveTemplateCheckBox(container);
        confirmRemoveTemplateCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button showMonitoringWarningCheckbox = this.createShowMonitoringWarningCheckBox(container);
        showMonitoringWarningCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createDumpDefaultControls(container);
        return container;
    }

    private void createDumpDefaultControls(Composite container) {
        Composite dumpDefaultComposite = new Composite(container, 2048);
        dumpDefaultComposite.setLayout((Layout)new FillLayout(512));
        Label radioLabel = new Label(dumpDefaultComposite, 0);
        radioLabel.setText(Messages.DUMP_RECORDING_DEFAULT_TIMESPAN_TO_DUMP);
        Composite radioButtons = new Composite(dumpDefaultComposite, 0);
        radioButtons.setLayout((Layout)new FillLayout(256));
        this.noDefaultRadio = new Button(radioButtons, 16);
        this.noDefaultRadio.setText(Messages.DUMP_RECORDING_NO_DEFAULT);
        this.noDefaultRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.timespanValue.setEnabled(false);
            }
        });
        this.wholeRadio = new Button(radioButtons, 16);
        this.wholeRadio.setText(Messages.DUMP_RECORDING_WHOLE);
        this.wholeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.timespanValue.setEnabled(false);
            }
        });
        this.timespanRadio = new Button(radioButtons, 16);
        this.timespanRadio.setText(Messages.DUMP_RECORDING_TIMESPAN);
        this.timespanRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.timespanValue.setEnabled(true);
                if (GeneralPage.this.previousValidTimespanValueString == null) {
                    GeneralPage.this.timespanValue.setText("");
                } else {
                    GeneralPage.this.timespanValue.setText(GeneralPage.this.previousValidTimespanValueString);
                }
            }
        });
        Composite timespanComposite = new Composite(dumpDefaultComposite, 0);
        timespanComposite.setLayout((Layout)new FillLayout(256));
        Label timespanLabel = new Label(timespanComposite, 0);
        timespanLabel.setText(Messages.DUMP_RECORDING_TIMESPAN_VALUE);
        this.timespanValue = new Text(timespanComposite, 2048);
        this.timespanValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralPage.this.timespanValue.getEnabled() && GeneralPage.this.getValidatedTimespan() != null) {
                    GeneralPage.this.previousValidTimespanValueString = GeneralPage.this.timespanValue.getText();
                }
            }
        });
        this.initializeTimespanControls(this.getPreferenceStore().getLong(P_LAST_PART_TO_DUMP_MS));
    }

    private void initializeTimespanControls(long timespan) {
        this.timespanValue.setEnabled(timespan > 0L);
        this.timespanRadio.setSelection(timespan > 0L);
        this.noDefaultRadio.setSelection(timespan == 0L);
        this.wholeRadio.setSelection(timespan == -1L);
        if (this.timespanRadio.getSelection()) {
            this.timespanValue.setText(TimeRangeToolkit.convertMillisToString((long)timespan));
        }
    }

    private Long getValidatedTimespan() {
        if (this.timespanRadio.getSelection()) {
            String text = this.timespanValue.getText();
            try {
                long timespan = TimeRangeToolkit.parseMillis((String)text);
                if (timespan > 0L) {
                    this.setErrorMessage(null);
                    this.setValid(true);
                    return timespan;
                }
                this.setErrorMessage(Messages.DUMP_RECORDING_TIMESPAN_LESS_THAN_ZERO);
                this.setValid(false);
            }
            catch (QuantityConversionException qce) {
                this.setErrorMessage(NLS.bind((String)Messages.DUMP_RECORDING_TIMESPAN_UNPARSABLE, (Object)qce.getLocalizedMessage()));
                this.setValid(false);
            }
        } else {
            if (this.noDefaultRadio.getSelection()) {
                this.setErrorMessage(null);
                this.setValid(true);
                return 0L;
            }
            if (this.wholeRadio.getSelection()) {
                this.setErrorMessage(null);
                this.setValid(true);
                return -1L;
            }
        }
        return null;
    }

    private void setDumpTimespan(long dumpTimespan) {
        this.getPreferenceStore().setValue(P_LAST_PART_TO_DUMP_MS, dumpTimespan);
    }

    private Button createClearButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.PREFERENCES_CLEAR_USER_SETTINGS_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralPage.this.ensureAllEditorsClosed()) {
                    GeneralPage.this.showConfirmUserSettingReset();
                }
            }
        });
        return button;
    }

    private boolean ensureAllEditorsClosed() {
        IEditorReference[] iEditorReferenceArray = this.m_workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            if ("com.jrockit.mc.flightrecorder.ui.FlightRecordingEditor".equals(ref.getId())) {
                this.showMustCloseEditor();
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void showMustCloseEditor() {
        MessageBox messageBox = new MessageBox(this.getShell(), 2);
        messageBox.setMessage(Messages.PREFERENCES_OPEN_FLIGHT_RECORDING_DIALOG_TEXT);
        messageBox.setText(Messages.PREFERENCES_OPEN_FLIGHT_RECORDING_DIALOG_TITLE);
        messageBox.open();
    }

    private void showConfirmUserSettingReset() {
        MessageBox messageBox = new MessageBox(this.getShell(), 200);
        messageBox.setMessage(Messages.PREFERENCES_RESET_USER_SETTINGS_DIALOG_TEXT);
        messageBox.setText(Messages.PREFERENCES_RESET_USER_SETTINGS_DIALOG_TITLE);
        if (messageBox.open() == 64) {
            ComponentsPlugin.getDefault().getUserInterfaceRepository().clearUserSettings("com.jrockit.mc.flightrecorder.ui.FlightRecordingEditor");
        }
    }

    private Button createRemoveRecordingsCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_REMOVE_FINISHED_RECORDING_TEXT, P_REMOVE_FINISHED_RECORDING);
    }

    private Button createConfirmRemoveTemplateCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_CONFIRM_REMOVE_TEMPLATE_TEXT, P_CONFIRM_REMOVE_TEMPLATE);
    }

    private Button createShowMonitoringWarningCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_SHOW_MONITORING_WARNING_TEXT, P_SHOW_MONITORING_WARNING);
    }

    protected void performDefaults() {
        for (CheckBox checkBox : this.checkBoxes) {
            checkBox.setToDefault();
        }
        this.initializeTimespanControls(this.getPreferenceStore().getDefaultLong(P_LAST_PART_TO_DUMP_MS));
        super.performDefaults();
    }

    private Button createCheckBox(Composite parent, String text, String name) {
        Button checkBox = new Button(parent, 32);
        checkBox.setSelection(this.getPreferenceStore().getBoolean(name));
        checkBox.setText(text);
        this.checkBoxes.add(new CheckBox(checkBox, name));
        return checkBox;
    }

    public boolean performOk() {
        this.setDumpTimespan(this.getValidatedTimespan());
        for (CheckBox checkBox : this.checkBoxes) {
            this.getPreferenceStore().setValue(checkBox.m_preference, checkBox.m_button.getSelection());
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.m_workbench = workbench;
    }

    private class CheckBox {
        private final Button m_button;
        private final String m_preference;

        public CheckBox(Button button, String preference) {
            this.m_button = button;
            this.m_preference = preference;
        }

        public void setToDefault() {
            GeneralPage.this.getPreferenceStore().setToDefault(this.m_preference);
            this.m_button.setSelection(GeneralPage.this.getPreferenceStore().getBoolean(this.m_preference));
        }
    }
}

