/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Image;
import java.io.CharConversionException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.ColorHighlighter;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

public class UnitDetails
extends DetailsPanel {
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitDetails");
    private RequestProcessor.Task unitDetailsTask = null;
    static final RequestProcessor UNIT_DETAILS_PROCESSOR = new RequestProcessor("unit-details-processor", 1, true);

    public UnitDetails() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UnitDetails"));
    }

    public void setUnit(Unit unit) {
        this.setUnit(unit, null);
    }

    public void setUnit(final Unit unit, Action action) {
        if (this.unitDetailsTask != null && !this.unitDetailsTask.isFinished()) {
            this.unitDetailsTask.cancel();
        }
        if (unit == null) {
            this.getDetails().setText("<i>" + UnitDetails.getBundle("UnitDetails_Category_NoDescription") + "</i>");
            this.setTitle(null);
        } else {
            try {
                this.setTitle(XMLUtil.toElementContent((String)unit.getDisplayName()));
            }
            catch (CharConversionException charConversionException) {
                err.log(Level.INFO, null, charConversionException);
                return;
            }
            this.setActionListener(action);
            this.setUnitText(unit, this.getUnitText(unit, false));
            if (unit instanceof Unit.Update) {
                this.unitDetailsTask = UNIT_DETAILS_PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final StringBuilder stringBuilder = UnitDetails.this.getUnitText(unit, true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UnitDetails.this.setUnitText(unit, stringBuilder);
                            }
                        });
                    }
                });
            }
        }
    }

    private void buildUnitText(Unit unit, StringBuilder stringBuilder, boolean bl) {
        Object object;
        Object object2;
        if (unit instanceof Unit.Available) {
            object2 = (Unit.Available)unit;
            object = ((Unit.Available)object2).getSourceIcon();
            Object object3 = ((Image)object).getProperty("url", null);
            String string = ((Unit.Available)object2).getSourceDescription();
            stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
            if (object3 instanceof URL) {
                stringBuilder.append("<td><img src=\"").append(object3).append("\"></img></td>");
            }
            stringBuilder.append("<td></td>");
            stringBuilder.append("<td>&nbsp;&nbsp;</td>");
            stringBuilder.append("<td><b>").append(string).append("</b></td>");
            stringBuilder.append("</tr></table><br>");
        }
        if (Utilities.modulesOnly() || Utilities.showExtendedDescription()) {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_CodeName")).append("</b>").append(unit.updateUnit.getCodeName());
            stringBuilder.append("<br>");
        }
        object2 = null;
        if (unit instanceof Unit.Update) {
            object = (Unit.Update)unit;
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_InstalledVersion")).append("</b>").append(((Unit.Update)object).getInstalledVersion()).append("<br>");
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_AvailableVersion")).append("</b>").append(((Unit.Update)object).getAvailableVersion()).append("<br>");
            object2 = this.getDependencies((Unit.Update)object, bl);
        } else {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Version")).append("</b>").append(unit.getDisplayVersion()).append("<br>");
        }
        if (unit.getAuthor() != null && unit.getAuthor().length() > 0) {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Author")).append("</b>").append(unit.getAuthor()).append("<br>");
        }
        if (unit.getDisplayDate() != null && unit.getDisplayDate().length() > 0) {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Date")).append("</b>").append(unit.getDisplayDate()).append("<br>");
        }
        stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Source")).append("</b>").append(unit.getSource()).append("<br>");
        if (unit.getHomepage() != null && unit.getHomepage().length() > 0) {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Homepage")).append("</b><a href=\"").append(unit.getHomepage()).append("\">").append(unit.getHomepage()).append("</a><br>");
        }
        if (unit.getNotification() != null && unit.getNotification().length() > 0) {
            stringBuilder.append("<br><h3>").append(UnitDetails.getBundle("UnitDetails_Plugin_Notification")).append("</h3>");
            stringBuilder.append("<font color=\"red\">");
            stringBuilder.append(unit.getNotification());
            stringBuilder.append("</font><br>");
        }
        if (unit.getDescription() != null && unit.getDescription().length() > 0) {
            stringBuilder.append("<br><h3>").append(UnitDetails.getBundle("UnitDetails_Plugin_Description")).append("</h3>");
            object = unit.getDescription();
            if (((String)object).toLowerCase().startsWith("<html>")) {
                stringBuilder.append(((String)object).substring(6));
            } else {
                stringBuilder.append((String)object);
            }
        }
        if (object2 != null && ((String)object2).length() > 0) {
            stringBuilder.append("<br><br><h4>").append(UnitDetails.getBundle("Unit_InternalUpdates_Title")).append("</h4>");
            stringBuilder.append((String)object2);
        }
    }

    private void setUnitText(Unit unit, StringBuilder stringBuilder) {
        this.getDetails().setText(stringBuilder.toString());
        this.setUnitHighlighing(unit);
    }

    private StringBuilder getUnitText(Unit unit, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            try {
                this.buildUnitText(unit, stringBuilder, bl);
            }
            catch (IllegalStateException illegalStateException) {
                if (n > 100) {
                    throw illegalStateException;
                }
                Unit.log.log(Level.INFO, "Can't compute getUnitText for " + unit, illegalStateException);
                ++n;
                continue;
            }
            break;
        }
        return stringBuilder;
    }

    private void setUnitHighlighing(Unit unit) {
        Color color = Color.YELLOW;
        ColorHighlighter colorHighlighter = new ColorHighlighter(this.getDetails(), color);
        int n = colorHighlighter.highlight(unit.getFilter());
        this.getDetails().setCaretPosition(n > 0 ? n : 0);
    }

    private String getDependencies(Unit.Update update, boolean bl) {
        if (!bl) {
            return "<i>" + UnitDetails.getBundle("UnitDetails_Plugin_Collecting_Dependencies") + "</i><br>";
        }
        Unit.Update update2 = update;
        if (update2 instanceof Unit.CompoundUpdate) {
            Unit.CompoundUpdate compoundUpdate = (Unit.CompoundUpdate)update2;
            StringBuilder stringBuilder = new StringBuilder();
            for (UpdateUnit updateUnit : compoundUpdate.getUpdateUnits()) {
                this.appendInternalUpdates(stringBuilder, (UpdateElement)updateUnit.getAvailableUpdates().get(0));
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private void appendInternalUpdates(StringBuilder stringBuilder, UpdateElement updateElement) {
        stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
        stringBuilder.append(updateElement.getDisplayName());
        if (updateElement.getUpdateUnit().getInstalled() != null) {
            stringBuilder.append(" [").append(updateElement.getUpdateUnit().getInstalled().getSpecificationVersion()).append("->");
        } else {
            stringBuilder.append(" <span color=\"red\">").append(UnitDetails.getBundle("UnitDetails_New_Internal_Update_Mark")).append("</span> [");
        }
        stringBuilder.append(((UpdateElement)updateElement.getUpdateUnit().getAvailableUpdates().get(0)).getSpecificationVersion());
        stringBuilder.append("]<br>");
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(UnitDetails.class, (String)string);
    }
}

