/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.actions.Savable;
import org.netbeans.modules.openide.loaders.DataObjectAccessor;
import org.netbeans.modules.openide.loaders.DataObjectEncodingQueryImplementation;
import org.netbeans.modules.openide.loaders.Unmodify;
import org.netbeans.spi.actions.AbstractSavable;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObjectAccessorImpl;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.FolderList;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public abstract class DataObject
implements Node.Cookie,
Serializable,
HelpCtx.Provider,
Lookup.Provider {
    private static final long serialVersionUID = 3328227388376142699L;
    public static final String PROP_TEMPLATE = "template";
    public static final String PROP_NAME = "name";
    public static final String PROP_HELP = "helpCtx";
    public static final String PROP_MODIFIED = "modified";
    public static final String PROP_COOKIE = "cookie";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PRIMARY_FILE = "primaryFile";
    public static final String PROP_FILES = "files";
    static final String EA_ASSIGNED_LOADER = "NetBeansAttrAssignedLoader";
    static final String EA_ASSIGNED_LOADER_MODULE = "NetBeansAttrAssignedLoaderModule";
    private static final Logger OBJ_LOG = Logger.getLogger(DataObject.class.getName());
    private static final ModifiedRegistry modified = new ModifiedRegistry();
    private static final Set<DataObject> syncModified = Collections.synchronizedSet(modified);
    private boolean modif = false;
    private transient Node nodeDelegate;
    private transient DataObjectPool.Item item;
    private DataLoader loader;
    private PropertyChangeSupport changeSupport;
    private VetoableChangeSupport vetoableChangeSupport;
    private static final Object listenersMethodLock = new Object();
    private final Object nodeCreationLock = new Object();
    private static Object synchObject = new Object();
    static final Logger LOG = Logger.getLogger("org.openide.loaders");
    private static Registry REGISTRY_INSTANCE;
    private static final Set<Class<?>> warnedClasses;

    public DataObject(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        this(fileObject, DataObjectPool.getPOOL().register(fileObject, dataLoader), dataLoader);
    }

    private DataObject(FileObject fileObject, DataObjectPool.Item item, DataLoader dataLoader) {
        OBJ_LOG.log(Level.FINE, "created {0}", fileObject);
        this.item = item;
        this.loader = dataLoader;
        item.setDataObject(this);
    }

    protected void dispose() {
        DataObjectPool.Item item = this.item();
        if (item != null) {
            DataObjectPool.getPOOL().countRegistration(item.primaryFile);
            item.deregister(true);
            item.setDataObject(null);
            this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        }
    }

    final DataObjectPool.Item item() {
        return this.item;
    }

    private void changeItem(DataObjectPool.Item item) {
        this.item = item;
    }

    final void changeItemByFolder(DataObjectPool.Item item) {
        assert (this instanceof DataFolder);
        this.changeItem(item);
    }

    public void setValid(boolean bl) throws PropertyVetoException {
        if (!bl && this.isValid()) {
            this.markInvalid0();
        }
    }

    final void markInvalid0() throws PropertyVetoException {
        this.fireVetoableChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        this.dispose();
        this.setModified(false);
    }

    public final boolean isValid() {
        return this.item().isValid();
    }

    public final DataLoader getLoader() {
        return this.loader;
    }

    protected final void markFiles() throws IOException {
        for (FileObject fileObject : this.files()) {
            this.loader.markFile(fileObject);
        }
    }

    public Set<FileObject> files() {
        return Collections.singleton(this.getPrimaryFile());
    }

    public final Node getNodeDelegate() {
        if (!this.isValid()) {
            String string = "this=" + this + " id=" + System.identityHashCode(this) + " primaryFileId=" + System.identityHashCode(this.getPrimaryFile()) + " valid=" + this.getPrimaryFile().isValid() + "\n";
            DataObject dataObject = DataObjectPool.getPOOL().find(this.getPrimaryFile());
            string = string + "pool=" + dataObject;
            if (dataObject != null) {
                string = string + " id=" + System.identityHashCode(dataObject);
                if (dataObject.getPrimaryFile() != null) {
                    string = string + " primaryFileId=" + System.identityHashCode(dataObject.getPrimaryFile()) + " valid=" + dataObject.getPrimaryFile().isValid();
                }
            }
            IllegalStateException illegalStateException = new IllegalStateException("The data object " + this.getPrimaryFile() + " is invalid; you may not call getNodeDelegate on it any more; see #17020 and please fix your code.\n" + string);
            Logger.getLogger(DataObject.class.getName()).log(Level.INFO, null, illegalStateException);
        }
        return this.getNodeDelegateImpl();
    }

    private final Node getNodeDelegateImpl() {
        if (this.nodeDelegate == null) {
            Children.MUTEX.readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = DataObject.this.nodeCreationLock;
                    synchronized (object) {
                        if (DataObject.this.nodeDelegate == null) {
                            DataObject.this.nodeDelegate = DataObject.this.createNodeDelegate();
                        }
                    }
                }
            });
            if (this.nodeDelegate == null) {
                throw new IllegalStateException("DataObject " + this + " has null node delegate");
            }
        }
        return this.nodeDelegate;
    }

    Node getClonedNodeDelegate(DataFilter dataFilter) {
        return this.getNodeDelegate().cloneNode();
    }

    final Node getNodeDelegateOrNull() {
        return this.nodeDelegate;
    }

    final void setNodeDelegate(Node node) {
        this.nodeDelegate = node;
    }

    protected Node createNodeDelegate() {
        return new DataNode(this, Children.LEAF);
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryFile().lock();
    }

    static boolean setTemplate(FileObject fileObject, boolean bl) throws IOException {
        boolean bl2 = false;
        Object object = fileObject.getAttribute(PROP_TEMPLATE);
        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            bl2 = true;
        }
        if (bl2 == bl) {
            return false;
        }
        fileObject.setAttribute(PROP_TEMPLATE, (Object)(bl ? Boolean.TRUE : null));
        return true;
    }

    public final void setTemplate(boolean bl) throws IOException {
        if (!DataObject.setTemplate(this.getPrimaryFile(), bl)) {
            return;
        }
        this.firePropertyChange(PROP_TEMPLATE, !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isTemplate() {
        Object object = this.getPrimaryFile().getAttribute(PROP_TEMPLATE);
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        return bl;
    }

    public abstract boolean isDeleteAllowed();

    public abstract boolean isCopyAllowed();

    public abstract boolean isMoveAllowed();

    public boolean isShadowAllowed() {
        return true;
    }

    public abstract boolean isRenameAllowed();

    public boolean isModified() {
        return this.modif;
    }

    public void setModified(boolean bl) {
        Object object;
        boolean bl2 = OBJ_LOG.isLoggable(Level.FINE);
        if (bl2) {
            object = "setModified(): modif=" + bl + ", original-modif=" + this.modif;
            if (OBJ_LOG.isLoggable(Level.FINEST)) {
                OBJ_LOG.log(Level.FINEST, (String)object, new Exception());
            } else {
                OBJ_LOG.log(Level.FINE, (String)object);
            }
        }
        if (this.modif != bl) {
            this.modif = bl;
            object = (Savable)this.getLookup().lookup(AbstractSavable.class);
            if (bl2) {
                OBJ_LOG.log(Level.FINE, "setModified(): present={0}", new Object[]{object});
            }
            if (bl) {
                syncModified.add(this);
                if (object == null) {
                    new DOSavable(this).add();
                }
            } else {
                Unmodify unmodify;
                syncModified.remove(this);
                if (object == null) {
                    new DOSavable(this).remove();
                }
                if ((unmodify = (Unmodify)this.getLookup().lookup(Unmodify.class)) != null) {
                    unmodify.unmodify();
                }
            }
            this.firePropertyChange(PROP_MODIFIED, !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public abstract HelpCtx getHelpCtx();

    public final FileObject getPrimaryFile() {
        return this.item().primaryFile;
    }

    public static DataObject find(FileObject fileObject) throws DataObjectNotFoundException {
        if (fileObject == null) {
            throw new IllegalArgumentException("Called DataObject.find on null");
        }
        try {
            if (!fileObject.isValid()) {
                throw new FileStateInvalidException(fileObject.toString());
            }
            DataObject dataObject = DataObjectPool.getPOOL().find(fileObject);
            if (dataObject != null) {
                return dataObject;
            }
            DataLoaderPool dataLoaderPool = DataLoaderPool.getDefault();
            assert (dataLoaderPool != null) : "No DataLoaderPool found in " + Lookup.getDefault();
            dataObject = dataLoaderPool.findDataObject(fileObject);
            if (dataObject != null) {
                return dataObject;
            }
            throw new DataObjectNotFoundException(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
        catch (IOException iOException) {
            throw (DataObjectNotFoundException)new DataObjectNotFoundException(fileObject).initCause(iOException);
        }
    }

    public static Registry getRegistry() {
        return REGISTRY_INSTANCE;
    }

    public String getName() {
        return this.getPrimaryFile().getName();
    }

    public String toString() {
        return super.toString() + '[' + this.getPrimaryFile() + ']';
    }

    public final DataFolder getFolder() {
        FileObject fileObject = this.getPrimaryFile().getParent();
        return fileObject == null ? null : DataFolder.findFolder(fileObject);
    }

    public final DataObject copy(final DataFolder dataFolder) throws IOException {
        final DataObject[] dataObjectArray = new DataObject[1];
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataObjectArray[0] = DataObject.this.handleCopy(dataFolder);
            }
        }, null);
        DataObject.fireOperationEvent(new OperationEvent.Copy(dataObjectArray[0], this), 1);
        return dataObjectArray[0];
    }

    protected abstract DataObject handleCopy(DataFolder var1) throws IOException;

    final DataObject copyRename(final DataFolder dataFolder, final String string, final String string2) throws IOException {
        final DataObject[] dataObjectArray = new DataObject[1];
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataObjectArray[0] = DataObject.this.handleCopyRename(dataFolder, string, string2);
            }
        }, null);
        DataObject.fireOperationEvent(new OperationEvent(dataObjectArray[0]), 7);
        return dataObjectArray[0];
    }

    protected DataObject handleCopyRename(DataFolder dataFolder, String string, String string2) throws IOException {
        throw new IOException("Unsupported operation");
    }

    public final void delete() throws IOException {
        this.invokeAtomicAction(this.getPrimaryFile(), new FileSystem.AtomicAction(){

            public void run() throws IOException {
                DataObject.this.handleDelete();
                DataObjectPool.getPOOL().countRegistration(DataObject.this.item().primaryFile);
                DataObject.this.item().deregister(false);
                DataObject.this.item().setDataObject(null);
            }
        }, this.synchObject());
        this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        DataObject.fireOperationEvent(new OperationEvent(this), 3);
    }

    protected abstract void handleDelete() throws IOException;

    public final void rename(String string) throws IOException {
        if (string != null && string.trim().length() == 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(this.getName());
            String string2 = NbBundle.getMessage(DataObject.class, (String)"MSG_NotValidName", (Object)this.getName());
            Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)string2);
            throw illegalArgumentException;
        }
        class Op
        implements FileSystem.AtomicAction {
            FileObject oldPf;
            FileObject newPf;
            String oldName;
            String newName;

            Op() {
            }

            public void run() throws IOException {
                this.oldName = DataObject.this.getName();
                if (this.oldName.equals(this.newName)) {
                    return;
                }
                this.oldPf = DataObject.this.getPrimaryFile();
                this.newPf = DataObject.this.handleRename(this.newName);
                if (this.oldPf != this.newPf) {
                    DataObject.this.changeItem(DataObject.this.item().changePrimaryFile(this.newPf));
                }
                this.newName = DataObject.this.getName();
            }
        }
        Op op = new Op();
        op.newName = string;
        FileObject fileObject = this.getPrimaryFile().getParent();
        if (fileObject == null) {
            fileObject = this.getPrimaryFile();
        }
        this.invokeAtomicAction(fileObject, op, this.synchObject());
        if (op.oldName.equals(op.newName)) {
            return;
        }
        if (op.oldPf != op.newPf) {
            this.firePropertyChange(PROP_PRIMARY_FILE, op.oldPf, op.newPf);
        }
        this.firePropertyChange(PROP_NAME, op.oldName, op.newName);
        this.firePropertyChange(PROP_FILES, null, null);
        DataObject.fireOperationEvent(new OperationEvent.Rename(this, op.oldName), 4);
    }

    protected abstract FileObject handleRename(String var1) throws IOException;

    public final void move(final DataFolder dataFolder) throws IOException {
        class Op
        implements FileSystem.AtomicAction {
            FileObject old;

            Op() {
            }

            public void run() throws IOException {
                if (DataObject.this.getFolder() == null) {
                    return;
                }
                if (dataFolder.equals(DataObject.this.getFolder())) {
                    return;
                }
                this.old = DataObject.this.getPrimaryFile();
                FileObject fileObject = DataObject.this.handleMove(dataFolder);
                DataObject.this.changeItem(DataObject.this.item().changePrimaryFile(fileObject));
            }
        }
        Op op = new Op();
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), op, this.synchObject());
        this.firePropertyChange(PROP_PRIMARY_FILE, op.old, this.getPrimaryFile());
        DataObject.fireOperationEvent(new OperationEvent.Move(this, op.old), 2);
    }

    protected abstract FileObject handleMove(DataFolder var1) throws IOException;

    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        return DataShadow.create(dataFolder, this);
    }

    public final DataShadow createShadow(final DataFolder dataFolder) throws IOException {
        final DataShadow[] dataShadowArray = new DataShadow[1];
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataShadowArray[0] = DataObject.this.handleCreateShadow(dataFolder);
            }
        }, null);
        DataObject.fireOperationEvent(new OperationEvent.Copy(dataShadowArray[0], this), 5);
        return dataShadowArray[0];
    }

    public final DataObject createFromTemplate(DataFolder dataFolder) throws IOException {
        return this.createFromTemplate(dataFolder, null);
    }

    public final DataObject createFromTemplate(DataFolder dataFolder, String string) throws IOException {
        return this.createFromTemplate(dataFolder, string, Collections.emptyMap());
    }

    public final DataObject createFromTemplate(DataFolder dataFolder, String string, Map<String, ? extends Object> map) throws IOException {
        CreateAction createAction = new CreateAction(this, dataFolder, string, map);
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), createAction, null);
        DataObject.fireOperationEvent(new OperationEvent.Copy(createAction.result, this), 6);
        return createAction.result;
    }

    protected abstract DataObject handleCreateFromTemplate(DataFolder var1, String var2) throws IOException;

    private static void fireOperationEvent(OperationEvent operationEvent, int n) {
        DataLoaderPool.getDefault().fireOperationEvent(operationEvent, n);
    }

    Object synchObject() {
        return synchObject;
    }

    private void invokeAtomicAction(FileObject fileObject, final FileSystem.AtomicAction atomicAction, final Object object) throws IOException {
        class WrapRun
        implements FileSystem.AtomicAction {
            WrapRun() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Object object2 = object;
                synchronized (object2) {
                    atomicAction.run();
                }
            }
        }
        FileSystem.AtomicAction atomicAction2 = object != null ? new WrapRun() : atomicAction;
        if (Boolean.getBoolean("netbeans.dataobject.insecure.operation")) {
            DataObjectPool.getPOOL().runAtomicActionSimple(fileObject, atomicAction2);
            return;
        }
        if (this instanceof DataFolder) {
            DataObjectPool.getPOOL().runAtomicActionSimple(fileObject, atomicAction2);
        } else {
            DataObjectPool.getPOOL().runAtomicAction(fileObject, atomicAction2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = listenersMethodLock;
        synchronized (object) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        Object object = listenersMethodLock;
        synchronized (object) {
            if (this.vetoableChangeSupport == null) {
                this.vetoableChangeSupport = new VetoableChangeSupport(this);
            }
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)((Node.Cookie)clazz.cast(this));
        }
        return null;
    }

    public Lookup getLookup() {
        Class<?> clazz = this.getClass();
        if (warnedClasses.add(clazz)) {
            LOG.warning("Should override getLookup() in " + clazz + ", e.g.: [MultiDataObject.this.]getCookieSet().getLookup()");
        }
        if (this.isValid()) {
            return this.getNodeDelegateImpl().getLookup();
        }
        return this.createNodeDelegate().getLookup();
    }

    protected <T extends Node.Cookie> T getCookie(DataShadow dataShadow, Class<T> clazz) {
        return this.getCookie(clazz);
    }

    public Object writeReplace() {
        return new Replace(this);
    }

    static String getString(String string) {
        return NbBundle.getMessage(DataObject.class, (String)string);
    }

    void recognizedByFolder() {
    }

    void notifyFileRenamed(FileRenameEvent fileRenameEvent) {
        if (fileRenameEvent.getFile().equals(this.getPrimaryFile())) {
            this.firePropertyChange(PROP_NAME, fileRenameEvent.getName(), this.getName());
        }
    }

    void notifyFileDeleted(FileEvent fileEvent) {
    }

    void notifyFileChanged(FileEvent fileEvent) {
    }

    void notifyFileDataCreated(FileEvent fileEvent) {
    }

    void notifyAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        String string;
        if (!EA_ASSIGNED_LOADER.equals(fileAttributeEvent.getName())) {
            return;
        }
        FileObject fileObject = fileAttributeEvent.getFile();
        if (!(fileObject == null || (string = (String)fileObject.getAttribute(EA_ASSIGNED_LOADER)) != null && string.equals(this.getLoader().getClass().getName()))) {
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            hashSet.add(fileObject);
            if (!DataObjectPool.getPOOL().revalidate(hashSet).isEmpty()) {
                LOG.info("It was not possible to invalidate data object: " + this);
            } else {
                FolderList.changedDataSystem(fileObject.getParent());
            }
        }
    }

    static {
        DataObjectAccessor.DEFAULT = new DataObjectAccessorImpl();
        REGISTRY_INSTANCE = new Registry();
        warnedClasses = Collections.synchronizedSet(new WeakSet());
    }

    static final class CreateAction
    implements FileSystem.AtomicAction {
        public DataObject result;
        private String name;
        private DataFolder f;
        private DataObject orig;
        private Map<String, ? extends Object> param;
        private static ThreadLocal<CreateAction> CURRENT = new ThreadLocal();

        public CreateAction(DataObject dataObject, DataFolder dataFolder, String string, Map<String, ? extends Object> map) {
            this.orig = dataObject;
            this.f = dataFolder;
            this.name = string;
            this.param = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            DataFolder dataFolder = DataObjectEncodingQueryImplementation.enterIgnoreTargetFolder(this.f);
            CreateAction createAction = CURRENT.get();
            try {
                CURRENT.set(this);
                this.result = this.orig.handleCreateFromTemplate(this.f, this.name);
            }
            finally {
                DataObjectEncodingQueryImplementation.exitIgnoreTargetFolder(dataFolder);
                CURRENT.set(createAction);
            }
        }

        public static Map<String, Object> findParameters(String string) {
            CreateAction createAction = CURRENT.get();
            if (createAction == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (CreateFromTemplateAttributesProvider object : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
                Map<String, ?> map = object.attributesFor(createAction.orig, createAction.f, createAction.name);
                if (map == null) continue;
                for (Map.Entry<String, ?> entry : map.entrySet()) {
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (createAction.param != null) {
                for (Map.Entry entry : createAction.param.entrySet()) {
                    hashMap.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (!hashMap.containsKey(DataObject.PROP_NAME) && string != null) {
                if (Boolean.TRUE.equals(hashMap.get("freeFileExtension"))) {
                    string = string.replaceFirst("[.].*", "");
                }
                hashMap.put(DataObject.PROP_NAME, string);
            }
            if (!hashMap.containsKey("user")) {
                hashMap.put("user", System.getProperty("user.name"));
            }
            Date date = new Date();
            if (!hashMap.containsKey("date")) {
                hashMap.put("date", DateFormat.getDateInstance().format(date));
            }
            if (!hashMap.containsKey("time")) {
                hashMap.put("time", DateFormat.getTimeInstance().format(date));
            }
            if (!hashMap.containsKey("dateTime")) {
                hashMap.put("dateTime", date);
            }
            return Collections.unmodifiableMap(hashMap);
        }

        public static Map<String, Object> enhanceParameters(Map<String, Object> map, String string, String string2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
            if (!hashMap.containsKey("nameAndExt") && string != null) {
                if (!(string2 == null || string2.length() <= 0 || Boolean.TRUE.equals(map.get("freeFileExtension")) && string.indexOf(46) != -1)) {
                    hashMap.put("nameAndExt", string + '.' + string2);
                } else {
                    hashMap.put("nameAndExt", string);
                }
            }
            return Collections.unmodifiableMap(hashMap);
        }
    }

    private static final class DOSavable
    extends AbstractSavable
    implements Icon {
        final DataObject obj;

        public DOSavable(DataObject dataObject) {
            this.obj = dataObject;
        }

        public String findDisplayName() {
            return this.obj.getNodeDelegate().getDisplayName();
        }

        protected void handleSave() throws IOException {
            SaveCookie saveCookie = this.obj.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
        }

        public boolean equals(Object object) {
            if (object instanceof DOSavable) {
                DOSavable dOSavable = (DOSavable)object;
                return this.obj.equals(dOSavable.obj);
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        final void remove() {
            this.unregister();
        }

        final void add() {
            this.register();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon().paintIcon(component, graphics, n, n2);
        }

        @Override
        public int getIconWidth() {
            return this.icon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon().getIconHeight();
        }

        private Icon icon() {
            return ImageUtilities.image2Icon((Image)this.obj.getNodeDelegate().getIcon(1));
        }
    }

    private static final class ModifiedRegistry
    extends HashSet<DataObject> {
        static final long serialVersionUID = -2861723614638919680L;
        private static final Logger REGLOG = Logger.getLogger("org.openide.loaders.DataObject.Registry");
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        ModifiedRegistry() {
        }

        public final void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public final void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        @Override
        public boolean add(DataObject dataObject) {
            boolean bl = super.add(dataObject);
            REGLOG.log(Level.FINER, "Data Object {0} modified, change {1}", new Object[]{dataObject, bl});
            if (bl) {
                this.cs.fireChange();
            }
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = super.remove(object);
            REGLOG.log(Level.FINER, "Data Object {0} unmodified, change {1}", new Object[]{object, bl});
            if (bl) {
                this.cs.fireChange();
            }
            return bl;
        }
    }

    public static final class Registry {
        private Registry() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            modified.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            modified.removeChangeListener(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<DataObject> getModifiedSet() {
            Set set = syncModified;
            synchronized (set) {
                HashSet<DataObject> hashSet = new HashSet<DataObject>(syncModified);
                return hashSet;
            }
        }

        public DataObject[] getModified() {
            return this.getModifiedSet().toArray(new DataObject[0]);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registrations {
        public Registration[] value();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String mimeType();

        public String displayName() default "";

        public String iconBase() default "";

        public int position() default 0x7FFFFFFF;
    }

    public static interface Container
    extends Node.Cookie {
        public static final String PROP_CHILDREN = "children";

        public DataObject[] getChildren();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    public static interface Factory {
        public DataObject findDataObject(FileObject var1, Set<? super FileObject> var2) throws IOException;
    }

    private static final class Replace
    implements Serializable {
        private FileObject fo;
        private transient DataObject obj;
        private static final long serialVersionUID = -627843044348243058L;

        public Replace(DataObject dataObject) {
            this.obj = dataObject;
            this.fo = dataObject.getPrimaryFile();
        }

        public Object readResolve() {
            return this.obj;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.fo == null) {
                throw new FileNotFoundException();
            }
            this.obj = DataObject.find(this.fo);
        }
    }
}

