/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.seunjeon.elasticsearch;

import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenBuilder;

public class TokenizerOptions {
    public static final boolean DECOMPOUND = true;
    public static final boolean DEINFLECT = true;
    public static final boolean INDEX_EOJEOL = true;
    public static final String[] INDEX_POSES = TokenBuilder.INDEX_POSES_JAVA();
    public static final boolean POS_TAGGING = true;
    public static final int MAX_UNK_LENGTH = 8;
    private String userDictPath = null;
    private String[] userWords = new String[0];
    private boolean deCompound = true;
    private boolean deInflect = true;
    private boolean indexEojeol = true;
    private String[] indexPoses = INDEX_POSES;
    private String name = null;
    private boolean posTagging = true;
    private int maxUnkLength = 8;

    public static TokenizerOptions create(String name) {
        return new TokenizerOptions(name);
    }

    private TokenizerOptions(String name) {
        this.name = name;
    }

    public TokenizerOptions setPosTagging(boolean posTagging) {
        this.posTagging = posTagging;
        return this;
    }

    public TokenizerOptions setMaxUnkLength(int length) {
        this.maxUnkLength = length;
        return this;
    }

    public TokenizerOptions setUserDictPath(String userDictPath) {
        this.userDictPath = userDictPath;
        return this;
    }

    public TokenizerOptions setUserWords(String[] userWords) {
        this.userWords = userWords;
        return this;
    }

    public TokenizerOptions setDeCompound(boolean deCompound) {
        this.deCompound = deCompound;
        return this;
    }

    public TokenizerOptions setDeInflect(boolean deInflect) {
        this.deInflect = deInflect;
        return this;
    }

    public TokenizerOptions setIndexEojeol(boolean indexEojeol) {
        this.indexEojeol = indexEojeol;
        return this;
    }

    public TokenizerOptions setIndexPoses(String[] indexPoses) {
        this.indexPoses = indexPoses;
        return this;
    }

    public String getUserDictPath() {
        return this.userDictPath;
    }

    public String[] getUserWords() {
        return this.userWords;
    }

    public boolean getDeCompound() {
        return this.deCompound;
    }

    public boolean getDeInflect() {
        return this.deInflect;
    }

    public boolean getIndexEojeol() {
        return this.indexEojeol;
    }

    public String[] getIndexPoses() {
        return this.indexPoses;
    }

    public boolean getPosTagging() {
        return this.posTagging;
    }

    public int getMaxUnkLength() {
        return this.maxUnkLength;
    }

    public String getName() {
        return this.name;
    }
}

