/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.seunjeon.elasticsearch;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeFactory;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.LuceneToken;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenBuilder;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenizerOptions;
import org.elasticsearch.common.logging.ESLoggerFactory;

public class SeunjeonTokenizer
extends Tokenizer {
    private CharTermAttribute charTermAtt;
    private PositionIncrementAttribute posIncrAtt;
    private PositionLengthAttribute posLenAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;
    private Queue<LuceneToken> tokensQueue;
    private TokenBuilder tokenBuilder;
    Logger logger = null;

    public SeunjeonTokenizer(TokenizerOptions options) {
        super(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
        this.logger = ESLoggerFactory.getLogger((String)options.getName());
        this.initAttribute();
        TokenBuilder.setMaxUnkLength(options.getMaxUnkLength());
        if (options.getUserDictPath() != null) {
            TokenBuilder.setUserDict(options.getUserDictPath());
            this.logger.info(options.getUserDictPath() + " loading was successful.");
            if (options.getUserWords().length > 0) {
                this.logger.warn("ignored \"user_words\". because settings of \"user_dict_path\"");
            }
        } else {
            TokenBuilder.setUserDict(Arrays.asList(options.getUserWords()).iterator());
        }
        this.tokenBuilder = new TokenBuilder(options.getDeCompound(), options.getDeInflect(), options.getIndexEojeol(), options.getPosTagging(), TokenBuilder.convertPos(options.getIndexPoses()));
    }

    private void initAttribute() {
        this.charTermAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public void reset() throws IOException {
        super.reset();
        this.tokensQueue = new LinkedList<LuceneToken>(this.tokenBuilder.tokenize(this.getDocument()));
    }

    public final boolean incrementToken() throws IOException {
        if (this.tokensQueue.isEmpty()) {
            return false;
        }
        LuceneToken pos = this.tokensQueue.poll();
        this.posIncrAtt.setPositionIncrement(pos.positionIncr());
        this.posLenAtt.setPositionLength(pos.positionLength());
        this.offsetAtt.setOffset(this.correctOffset(pos.startOffset()), this.correctOffset(pos.endOffset()));
        String term = pos.charTerm();
        this.charTermAtt.copyBuffer(term.toCharArray(), 0, term.length());
        this.typeAtt.setType(pos.poses());
        return true;
    }

    private String getDocument() throws IOException {
        int n;
        StringWriter sw = new StringWriter();
        char[] buffer = new char[4096];
        while (-1 != (n = this.input.read(buffer))) {
            sw.write(buffer, 0, n);
        }
        return sw.toString().toLowerCase();
    }
}

