/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.mecab_ko_lucene_analyzer;

import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.MeCabKoTokenizer;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosAppender;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.StandardPosAppender;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.TokenizerOption;

public abstract class TokenizerFactoryBase
extends TokenizerFactory {
    protected PosAppender posAppender;
    protected TokenizerOption option = new TokenizerOption();

    public TokenizerFactoryBase(Map<String, String> args) {
        super(args);
        this.setDefaultOption();
        this.setMeCabArgs(args);
        this.setCompoundNounMinLength(args);
        this.setUseAdjectiveAndVerbOriginalForm(args);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    protected void setDefaultOption() {
    }

    protected abstract void setPosAppender();

    protected void setMeCabArgs(Map<String, String> args) {
        this.option.mecabArgs = this.get(args, "mecabArgs", this.option.mecabArgs);
    }

    protected void setCompoundNounMinLength(Map<String, String> args) {
        this.option.compoundNounMinLength = this.getInt(args, "compoundNounMinLength", this.option.compoundNounMinLength);
    }

    protected void setUseAdjectiveAndVerbOriginalForm(Map<String, String> args) {
        this.option.useAdjectiveAndVerbOriginalForm = this.getBoolean(args, "useAdjectiveAndVerbOriginalForm", this.option.useAdjectiveAndVerbOriginalForm);
    }

    public Tokenizer create(AttributeFactory factory) {
        return new MeCabKoTokenizer(factory, this.option, new StandardPosAppender(this.option));
    }
}

