/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.mecab_ko_lucene_analyzer;

import java.util.LinkedList;
import java.util.ListIterator;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Eojeol;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Pos;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosAppender;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosIdManager;
import org.chasen.mecab.MeCab;
import org.chasen.mecab.Node;

public class TokenGenerator {
    public static final int NO_DECOMPOUND = 9999;
    public static final int DEFAULT_COMPOUND_NOUN_MIN_LENGTH = 3;
    private final PosAppender appender;
    private LinkedList<Pos> posList = new LinkedList();
    private ListIterator<Pos> posIter;
    private int compoundNounMinLength;

    public TokenGenerator(PosAppender appender, int compoundNounMinLength, Node beginNode) {
        this.appender = appender;
        this.compoundNounMinLength = compoundNounMinLength;
        this.convertNodeListToPosList(beginNode);
        this.posIter = this.posList.listIterator();
    }

    private void convertNodeListToPosList(Node beginNode) {
        Node node = beginNode.getNext();
        Pos prevPos = new Pos("", PosIdManager.PosId.UNKNOWN, 0, 0, 0);
        while (!TokenGenerator.isEosNode(node)) {
            Pos curPos = new Pos(node, prevPos.getEndOffset());
            if (curPos.getPosId() == PosIdManager.PosId.PREANALYSIS) {
                this.posList.addAll(TokenGenerator.getAnalyzedPoses(curPos));
            } else {
                this.posList.add(curPos);
            }
            prevPos = curPos;
            node = node.getNext();
        }
    }

    private static boolean isEosNode(Node node) {
        return node == null || node.getStat() == MeCab.MECAB_EOS_NODE;
    }

    public static LinkedList<Pos> getAnalyzedPoses(Pos pos) {
        LinkedList<Pos> output = new LinkedList<Pos>();
        String indexExp = pos.getExpression();
        if (indexExp == null) {
            output.add(pos);
            return output;
        }
        String[] posExps = indexExp.split("\\+");
        if (posExps.length == 1) {
            output.add(pos);
            return output;
        }
        for (String posExp : posExps) {
            output.add(new Pos(posExp, 0));
        }
        Pos prevPos = null;
        for (Pos curPos : output) {
            if (prevPos == null) {
                curPos.setStartOffset(pos.getStartOffset());
                prevPos = curPos;
                continue;
            }
            if (curPos.getPositionIncr() == 0) {
                curPos.setStartOffset(prevPos.getStartOffset());
                continue;
            }
            curPos.setStartOffset(prevPos.getEndOffset());
            prevPos = curPos;
        }
        return output;
    }

    public LinkedList<Pos> getNextEojeolTokens() {
        Eojeol eojeol = new Eojeol(this.appender, this.compoundNounMinLength);
        while (this.posIter.hasNext()) {
            Pos curPos = this.posIter.next();
            if (eojeol.append(curPos)) continue;
            this.posIter.previous();
            LinkedList<Pos> poses = eojeol.generateTokens();
            if (poses != null) {
                return poses;
            }
            eojeol.clear();
        }
        return eojeol.generateTokens();
    }
}

