/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.mecab_ko_lucene_analyzer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Appendable;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Eojeol;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Pos;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosAppender;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosIdManager;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.TokenizerOption;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.util.XpnDiscriminator;

public class StandardPosAppender
extends PosAppender {
    public static Set<Appendable> appendableSet = new HashSet<Appendable>();

    public StandardPosAppender(TokenizerOption option) {
        super(option);
    }

    @Override
    public boolean isAppendable(Pos left, Pos right) {
        if (right.getNode() != null && right.hasSpace()) {
            return false;
        }
        return appendableSet.contains(new Appendable(left.getEndPosId(), right.getStartPosId()));
    }

    @Override
    public boolean isSkippablePos(Pos pos) {
        PosIdManager.PosId posId = pos.getPosId();
        return posId == PosIdManager.PosId.SF || posId.in(PosIdManager.PosId.SP, PosIdManager.PosId.SE);
    }

    @Override
    public LinkedList<Pos> getTokensFrom(Eojeol eojeol) {
        this.preprocessXpn(eojeol);
        LinkedList<Pos> output = this.getAdditionalPosesFrom(eojeol);
        this.insertEojeolPosTo(eojeol, output);
        return output;
    }

    private void preprocessXpn(Eojeol eojeol) {
        if (eojeol.getNumPoses() < 2) {
            return;
        }
        Pos first = eojeol.getPos(0);
        Pos second = eojeol.getPos(1);
        if (!first.isPosIdOf(PosIdManager.PosId.XPN) || !second.isPosIdOf(PosIdManager.PosId.NNG) && !second.isPosIdOf(PosIdManager.PosId.NR) && !second.isPosIdOf(PosIdManager.PosId.NP)) {
            return;
        }
        if (XpnDiscriminator.isIndependentXpn(first.getSurface())) {
            eojeol.setToCompoundNoun();
        } else {
            LinkedList<Pos> eojeolPosList = eojeol.getPosList();
            Pos xpn = eojeolPosList.poll();
            Pos noun = eojeolPosList.poll();
            Pos newNoun = xpn.append(noun, PosIdManager.PosId.NNG, 1);
            newNoun.setPositionLength(1);
            eojeolPosList.addFirst(newNoun);
        }
    }

    private LinkedList<Pos> getAdditionalPosesFrom(Eojeol eojeol) {
        LinkedList<Pos> poses = eojeol.getPosList();
        if (eojeol.hasCompoundNoun()) {
            Pos pos;
            LinkedList<Pos> output = new LinkedList<Pos>();
            Pos prevPos = null;
            int numAbsolutePos = 0;
            Iterator iterator = poses.iterator();
            while (iterator.hasNext() && this.isAbsolutePos(pos = (Pos)iterator.next())) {
                output.add(pos);
                ++numAbsolutePos;
                if (prevPos == null) {
                    prevPos = pos;
                    continue;
                }
                if (this.areBothSingleLengthNoun(prevPos, pos)) {
                    prevPos = pos;
                    continue;
                }
                Pos compound = prevPos.append(pos, PosIdManager.PosId.COMPOUND, 0);
                output.add(output.size() - 1, compound);
                prevPos = pos;
            }
            if (numAbsolutePos >= 3) {
                output.add(1, this.generateWholeCompoundNoun(poses));
            }
            return output;
        }
        LinkedList<Pos> output = new LinkedList<Pos>();
        for (Pos pos : poses) {
            Pos firstPos;
            if (this.isAbsolutePos(pos)) {
                pos.setPositionIncr(0);
                output.add(pos);
            }
            if (!pos.isPosIdOf(PosIdManager.PosId.INFLECT) || !this.isAbsolutePos(firstPos = this.extractFirstPos(pos)) || firstPos.getSurfaceLength() > pos.getSurfaceLength()) continue;
            output.add(firstPos);
        }
        return output;
    }

    private boolean areBothSingleLengthNoun(Pos p1, Pos p2) {
        return p1.getPosId().in(PosIdManager.PosId.NNG, PosIdManager.PosId.NNP) && p1.getSurfaceLength() == 1 && p2.getPosId().in(PosIdManager.PosId.NNG, PosIdManager.PosId.NNP) && p2.getSurfaceLength() == 1;
    }

    private Pos generateWholeCompoundNoun(LinkedList<Pos> poses) {
        Pos pos;
        Pos wholeCompoundNoun = poses.getFirst();
        Iterator iterator = poses.subList(1, poses.size()).iterator();
        while (iterator.hasNext() && this.isAbsolutePos(pos = (Pos)iterator.next())) {
            wholeCompoundNoun = wholeCompoundNoun.append(pos, PosIdManager.PosId.COMPOUND, 0);
        }
        return wholeCompoundNoun;
    }

    private Pos insertEojeolPosTo(Eojeol eojeol, LinkedList<Pos> eojeolTokens) {
        Pos eojeolPos;
        LinkedList<Pos> posList = eojeol.getPosList();
        if (posList.size() == 1) {
            if (eojeolTokens.isEmpty()) {
                eojeolTokens.add(posList.getFirst());
            }
            if (eojeolTokens.getFirst() != posList.getFirst()) {
                eojeolTokens.addFirst(posList.getFirst());
            }
            eojeolPos = eojeolTokens.getFirst();
            eojeolPos.setPositionIncr(1);
        } else if (eojeol.hasCompoundNoun() && eojeolTokens.size() > 0) {
            int positionLength = this.recalcEojeolPositionLength(eojeolTokens);
            eojeolPos = new Pos(eojeol.getTerm(), PosIdManager.PosId.EOJEOL, eojeol.getStartOffset(), 0, positionLength);
            eojeolPos.setPos(this.concatMophemes(posList));
            if (eojeolTokens.size() < 2 || !eojeolPos.equalsOffset(eojeolTokens.get(1))) {
                eojeolTokens.add(1, eojeolPos);
            }
        } else {
            eojeolPos = new Pos(eojeol.getTerm(), PosIdManager.PosId.EOJEOL, eojeol.getStartOffset(), 1, 1);
            eojeolPos.setPos(this.concatMophemes(posList));
            eojeolTokens.addFirst(eojeolPos);
        }
        return eojeolPos;
    }

    private String concatMophemes(List<Pos> poses) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < poses.size(); ++i) {
            if (i != 0) {
                buff.append("+");
            }
            buff.append(poses.get(i).getMophemes());
        }
        return buff.toString();
    }

    private int recalcEojeolPositionLength(LinkedList<Pos> eojeolTokens) {
        int positionLength = 0;
        for (Pos pos : eojeolTokens) {
            positionLength += pos.getPositionIncr();
        }
        return positionLength;
    }

    private boolean isAbsolutePos(Pos pos) {
        if (this.option.useAdjectiveAndVerbOriginalForm) {
            return pos.getPosId().in(PosIdManager.PosId.NNG, PosIdManager.PosId.NR) || pos.isPosIdOf(PosIdManager.PosId.COMPOUND) || pos.isPosIdOf(PosIdManager.PosId.MAG) || pos.isPosIdOf(PosIdManager.PosId.MM) || pos.isPosIdOf(PosIdManager.PosId.XR) || pos.isPosIdOf(PosIdManager.PosId.SH) || pos.isPosIdOf(PosIdManager.PosId.SL) || pos.isPosIdOf(PosIdManager.PosId.SN) || pos.isPosIdOf(PosIdManager.PosId.UNKNOWN) || pos.isPosIdOf(PosIdManager.PosId.VA) || pos.isPosIdOf(PosIdManager.PosId.VV) || pos.isPosIdOf(PosIdManager.PosId.XPN) || pos.isPosIdOf(PosIdManager.PosId.XSN);
        }
        return pos.getPosId().in(PosIdManager.PosId.NNG, PosIdManager.PosId.NR) || pos.isPosIdOf(PosIdManager.PosId.COMPOUND) || pos.isPosIdOf(PosIdManager.PosId.MAG) || pos.isPosIdOf(PosIdManager.PosId.MM) || pos.isPosIdOf(PosIdManager.PosId.XR) || pos.isPosIdOf(PosIdManager.PosId.SH) || pos.isPosIdOf(PosIdManager.PosId.SL) || pos.isPosIdOf(PosIdManager.PosId.SN) || pos.isPosIdOf(PosIdManager.PosId.UNKNOWN) || pos.isPosIdOf(PosIdManager.PosId.XPN) || pos.isPosIdOf(PosIdManager.PosId.XSN);
    }

    private Pos extractFirstPos(Pos inflectPos) {
        if (!inflectPos.isPosIdOf(PosIdManager.PosId.INFLECT)) {
            return null;
        }
        String first = inflectPos.getExpression().split("\\+")[0];
        String[] datas = first.split("/");
        if (datas.length != 3) {
            return null;
        }
        String surface = datas[0];
        PosIdManager.PosId posId = PosIdManager.PosId.convertFrom(datas[1]);
        int startOffset = inflectPos.getStartOffset();
        return new Pos(surface, posId, startOffset, 0, 1);
    }

    static {
        appendableSet.add(new Appendable(PosIdManager.PosId.E, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.XR, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.VV, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.VA, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.VX, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.VCP, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.VCN, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.XSV, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.XSA, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNG, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNP, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNB, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNBC, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.NP, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.NR, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.COMPOUND, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.MAG, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.XR, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.UNKNOWN, PosIdManager.PosId.XSV));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNG, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNP, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNB, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNBC, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.NP, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.NR, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.COMPOUND, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.MAG, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.XR, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.UNKNOWN, PosIdManager.PosId.XSA));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNG, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNP, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNB, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNBC, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.NP, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.NR, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.COMPOUND, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.XSN, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.UNKNOWN, PosIdManager.PosId.VCP));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNG, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNP, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNB, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNBC, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.NP, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.NR, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.COMPOUND, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.UNKNOWN, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NNG));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NR));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NP));
        appendableSet.add(new Appendable(PosIdManager.PosId.XSN, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.E, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.MAG, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.J, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.SL, PosIdManager.PosId.J));
        appendableSet.add(new Appendable(PosIdManager.PosId.SH, PosIdManager.PosId.J));
    }
}

