/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.mecab_ko_lucene_analyzer;

public final class PosIdManager {

    public static enum PosId {
        UNKNOWN(0),
        COMPOUND(1),
        INFLECT(2),
        PREANALYSIS(3),
        E(100),
        IC(110),
        J(120),
        MAG(130),
        MAJ(131),
        MM(140),
        NNG(150),
        NNP(151),
        NNB(152),
        NNBC(153),
        NP(154),
        NR(155),
        SF(160),
        SH(161),
        SL(162),
        SN(163),
        SP(164),
        SSC(165),
        SSO(166),
        SC(167),
        SY(168),
        SE(169),
        VA(170),
        VCN(171),
        VCP(172),
        VV(173),
        VX(174),
        XPN(181),
        XR(182),
        XSA(183),
        XSN(184),
        XSV(185),
        EOJEOL(900);

        private int num;

        private PosId(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }

        public static PosId convertFrom(int posIdNum) {
            switch (posIdNum) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return COMPOUND;
                }
                case 2: {
                    return INFLECT;
                }
                case 3: {
                    return PREANALYSIS;
                }
                case 100: {
                    return E;
                }
                case 110: {
                    return IC;
                }
                case 120: {
                    return J;
                }
                case 130: {
                    return MAG;
                }
                case 131: {
                    return MAJ;
                }
                case 140: {
                    return MM;
                }
                case 150: {
                    return NNG;
                }
                case 151: {
                    return NNP;
                }
                case 152: {
                    return NNB;
                }
                case 153: {
                    return NNBC;
                }
                case 154: {
                    return NP;
                }
                case 155: {
                    return NR;
                }
                case 160: {
                    return SF;
                }
                case 161: {
                    return SH;
                }
                case 162: {
                    return SL;
                }
                case 163: {
                    return SN;
                }
                case 164: {
                    return SP;
                }
                case 165: {
                    return SSC;
                }
                case 166: {
                    return SSO;
                }
                case 167: {
                    return SC;
                }
                case 168: {
                    return SY;
                }
                case 169: {
                    return SE;
                }
                case 170: {
                    return VA;
                }
                case 171: {
                    return VCN;
                }
                case 172: {
                    return VCP;
                }
                case 173: {
                    return VV;
                }
                case 174: {
                    return VX;
                }
                case 181: {
                    return XPN;
                }
                case 182: {
                    return XR;
                }
                case 183: {
                    return XSA;
                }
                case 184: {
                    return XSN;
                }
                case 185: {
                    return XSV;
                }
                case 900: {
                    return EOJEOL;
                }
            }
            if (200 <= posIdNum && posIdNum < 300) {
                return INFLECT;
            }
            return UNKNOWN;
        }

        public static PosId convertFrom(String tagString) {
            tagString = tagString.toUpperCase();
            try {
                if (tagString.charAt(0) == 'J') {
                    return J;
                }
                if (tagString.charAt(0) == 'E' && tagString.charAt(1) != 'J') {
                    return E;
                }
                return PosId.valueOf(tagString);
            }
            catch (Exception e) {
                return UNKNOWN;
            }
        }

        public boolean in(PosId start, PosId end) {
            return start.getNum() <= this.getNum() && this.getNum() <= end.getNum();
        }
    }
}

